/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.rituals;

import com.ma.api.particles.ParticleInit;
import com.ma.config.GeneralModConfig;
import com.ma.events.delayed.DelayedEventQueue;
import com.ma.events.delayed.TimedDelayedEvent;
import com.ma.tools.math.MathUtilities;
import com.ma.tools.math.Vector3;
import com.mojang.datafixers.util.Pair;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SUpdateTimePacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityTimeChangeBall
extends Entity {
    private static final DataParameter<Byte> ENTITY_STATE = EntityDataManager.func_187226_a(EntityTimeChangeBall.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> TIME_CHANGE_TYPE = EntityDataManager.func_187226_a(EntityTimeChangeBall.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final Byte STATE_WAITING = 0;
    private static final Byte STATE_SHOOTING = 1;
    public static final int WAIT_TIME = 120;
    public static final int LERP_TIME = 100;
    public static final Byte TIME_CHANGE_DAY = 0;
    public static final Byte TIME_CHANGE_NIGHT = 1;
    private static final String EVENT_ID = "timeChange";
    private int age;
    Vector3 startPoint;
    Vector3 endPoint;
    Vector3 controlPoint1;
    Vector3 controlPoint2;
    Vector3d lastPosition;
    boolean pointsSet = false;

    public EntityTimeChangeBall(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.func_184224_h(true);
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    public void func_70071_h_() {
        this.setAge(this.getAge() + 1);
        if (this.field_70170_p.field_72995_K) {
            int max_particles_per_tick = 5;
            int numParticles = Math.max((int)Math.ceil((float)this.getAge() / 120.0f * (float)max_particles_per_tick), max_particles_per_tick);
            float radiusScale = 0.25f;
            for (int i = 0; i < numParticles; ++i) {
                this.field_70170_p.func_195590_a((IParticleData)ParticleInit.SPARKLE_VELOCITY.get(), true, this.func_226277_ct_() + (Math.random() - 0.5) * (double)radiusScale, this.func_226278_cu_() + (Math.random() - 0.5) * (double)radiusScale, this.func_226281_cx_() + (Math.random() - 0.5) * (double)radiusScale, 0.0, -0.5, 0.0);
            }
        }
        if (this.getAge() < 120) {
            float f = (float)this.getAge() / 120.0f;
            this.func_213293_j(1.0f + f, -1.0f - f * 9.0f, 1.0f + f);
            return;
        }
        if (this.getAge() >= 120 && this.getState() != STATE_SHOOTING.byteValue()) {
            this.setState(STATE_SHOOTING);
            if (!this.field_70170_p.field_72995_K) {
                this.queueTimeChange();
            }
        }
        if (this.getState() == STATE_SHOOTING.byteValue()) {
            if (!this.pointsSet) {
                this.setPoints();
            }
            float f = ((float)this.getAge() - 120.0f) / 100.0f;
            float f1 = ((float)this.getAge() + 1.0f - 120.0f) / 100.0f;
            this.lastPosition = this.func_213303_ch();
            Vector3 curPoint = Vector3.bezier(this.startPoint, this.endPoint, this.controlPoint1, this.controlPoint2, f);
            Vector3 nextPoint = Vector3.bezier(this.startPoint, this.endPoint, this.controlPoint1, this.controlPoint2, f1);
            this.func_70107_b(curPoint.x, curPoint.y, curPoint.z);
            Vector3 diff = nextPoint.sub(curPoint).normalize();
            float angle = (float)(Math.atan2(diff.x, diff.y) * 180.0 / Math.PI);
            this.func_213293_j(2.0, -10.0, 2.0);
            this.field_70125_A = angle;
            if (this.getAge() >= 220) {
                this.remove(false);
            }
        }
    }

    private boolean queueTimeChange() {
        int targetTime = -1;
        long wrappedWorldTime = this.field_70170_p.func_72820_D() % 24000L;
        if (this.field_70170_p.func_72935_r() && this.getTimeChangeType() == TIME_CHANGE_NIGHT.byteValue()) {
            targetTime = (int)(13000L - wrappedWorldTime);
        } else if (this.field_70170_p.func_226690_K_() && this.getTimeChangeType() == TIME_CHANGE_DAY.byteValue()) {
            targetTime = 24000 - (int)wrappedWorldTime;
        }
        if (targetTime == -1) {
            return false;
        }
        if (!DelayedEventQueue.hasEvent(this.field_70170_p, EVENT_ID)) {
            DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<Pair>(EVENT_ID, 100, new Pair((Object)((ServerWorld)this.field_70170_p), (Object)targetTime), EntityTimeChangeBall::flipDayNight));
            return true;
        }
        return false;
    }

    private static void flipDayNight(String identifier, Pair<ServerWorld, Integer> data) {
        int shift;
        ServerWorld world = (ServerWorld)data.getFirst();
        int timeRemaining = (Integer)data.getSecond();
        int n = shift = (Boolean)GeneralModConfig.MA_GRADUAL_TIME_CHANGE.get() != false ? MathUtilities.clamp(timeRemaining, 0, 100) : timeRemaining;
        if (shift == 0) {
            return;
        }
        world.func_241114_a_(world.func_72820_D() + (long)shift);
        SUpdateTimePacket pkt = new SUpdateTimePacket(world.func_82737_E(), world.func_72820_D(), world.func_82736_K().func_223586_b(GameRules.field_223607_j));
        world.func_73046_m().func_184103_al().func_232642_a_((IPacket)pkt, world.func_234923_W_());
        DelayedEventQueue.pushEvent((World)world, new TimedDelayedEvent<Pair>(identifier, 3, new Pair((Object)world, (Object)(timeRemaining - shift)), EntityTimeChangeBall::flipDayNight));
    }

    private void setPoints() {
        this.startPoint = new Vector3(this);
        this.endPoint = this.getCelestialPosition();
        this.controlPoint1 = Vector3.lerp(this.startPoint, this.endPoint, 0.25f);
        this.controlPoint2 = Vector3.lerp(this.startPoint, this.endPoint, 0.75f);
        this.controlPoint1.y = this.endPoint.y;
        this.controlPoint2.y = this.endPoint.y;
        this.pointsSet = true;
    }

    private Vector3 getCelestialPosition() {
        float celestialAngleRads = this.field_70170_p.func_72929_e(0.0f) + 1.5707964f;
        if (this.getTimeChangeType() == TIME_CHANGE_DAY.byteValue()) {
            celestialAngleRads = (float)((double)celestialAngleRads + Math.PI);
        }
        double cAngle = Math.cos(celestialAngleRads);
        double sAngle = Math.sin(celestialAngleRads);
        float distance = 150.0f;
        return new Vector3(this.func_226277_ct_() + cAngle * (double)distance, this.func_226278_cu_() + sAngle * (double)distance, this.func_226281_cx_());
    }

    public void setTimeChangeType(byte type) {
        this.field_70180_af.func_187227_b(TIME_CHANGE_TYPE, (Object)type);
    }

    public byte getTimeChangeType() {
        return (Byte)this.field_70180_af.func_187225_a(TIME_CHANGE_TYPE);
    }

    public byte getState() {
        return (Byte)this.field_70180_af.func_187225_a(ENTITY_STATE);
    }

    private void setState(byte state) {
        this.field_70180_af.func_187227_b(ENTITY_STATE, (Object)state);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ENTITY_STATE, (Object)STATE_WAITING);
        this.field_70180_af.func_187214_a(TIME_CHANGE_TYPE, (Object)TIME_CHANGE_DAY);
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70623_bb() {
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }
}

