/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.sorcery.base;

import com.ma.api.affinity.Affinity;
import com.ma.api.sound.SFX;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Shape;
import com.ma.sound.EntityAliveLoopingSound;
import com.ma.spells.crafting.ModifiedSpellPart;
import com.ma.spells.crafting.SpellRecipe;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class ChanneledSpellEntity
extends Entity {
    private static final DataParameter<Optional<UUID>> CASTER_UUID = EntityDataManager.func_187226_a(ChanneledSpellEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<CompoundNBT> SPELL_RECIPE = EntityDataManager.func_187226_a(ChanneledSpellEntity.class, (IDataSerializer)DataSerializers.field_192734_n);
    private static final String NBT_CASTER_UUID = "caster_uuid";
    private static final String NBT_SPELL = "spell";
    private PlayerEntity __cachedCaster = null;
    private SpellRecipe __cachedRecipe = null;
    private boolean __playedsound = false;
    private Affinity[] cachedAffinities = null;

    public ChanneledSpellEntity(EntityType<? extends ChanneledSpellEntity> entityType, World world) {
        super(entityType, world);
        this.func_189654_d(true);
        this.func_184224_h(true);
    }

    public ChanneledSpellEntity(EntityType<? extends ChanneledSpellEntity> entityType, PlayerEntity caster, ISpellDefinition spell, World world) {
        this(entityType, world);
        this.setCaster(caster);
        this.setSpell(spell);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa >= this.getMaxAge()) {
            this.remove(false);
            return;
        }
        PlayerEntity caster = this.getCaster();
        if (caster == null || !caster.func_70089_S() || !caster.field_70170_p.func_234923_W_().equals(this.field_70170_p.func_234923_W_()) || caster.func_184605_cv() <= 0 || caster.func_184607_cu().func_190926_b()) {
            if (!this.field_70170_p.field_72995_K) {
                this.remove(false);
            }
            return;
        }
        SpellRecipe recipe = this.getSpell();
        if (!this.field_70170_p.field_72995_K && !recipe.isValid()) {
            this.remove(false);
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa > 0 && (this.getApplicationRate() == 1 || this.field_70173_aa % this.getApplicationRate() == 0)) {
                this.applyEffect(caster.func_184607_cu(), recipe, caster, (ServerWorld)this.field_70170_p);
            }
        } else {
            this.spawnParticles();
            this.playSounds();
        }
    }

    protected int getApplicationRate() {
        return 10;
    }

    protected abstract void applyEffect(ItemStack var1, SpellRecipe var2, PlayerEntity var3, ServerWorld var4);

    protected SoundEvent getSoundEffect(SpellRecipe recipe) {
        switch (recipe.getHighestAffinity()) {
            case ARCANE: {
                return SFX.Loops.ARCANE;
            }
            case EARTH: {
                return SFX.Loops.EARTH;
            }
            case ENDER: {
                return SFX.Loops.ENDER;
            }
            case FIRE: {
                return SFX.Loops.FIRE;
            }
            case HELLFIRE: {
                return SFX.Loops.FIRE;
            }
            case LIGHTNING: {
                return SFX.Loops.LIGHTNING;
            }
            case WATER: {
                return SFX.Loops.WATER;
            }
            case ICE: {
                return SFX.Loops.ICE;
            }
            case WIND: {
                return SFX.Loops.AIR;
            }
        }
        return SFX.Loops.MANAWEAVING;
    }

    protected abstract void spawnAirParticles();

    protected abstract void spawnEarthParticles();

    protected abstract void spawnFireParticles(boolean var1, boolean var2);

    protected abstract void spawnWaterParticles(boolean var1);

    protected abstract void spawnEnderParticles();

    protected abstract void spawnArcaneParticles();

    private void spawnParticles() {
        SpellRecipe recipe = this.getSpell();
        if (recipe == null) {
            return;
        }
        if (this.cachedAffinities == null) {
            this.cachedAffinities = recipe.getAffinity().keySet().toArray(new Affinity[0]);
        }
        switch (this.cachedAffinities[(int)(Math.random() * (double)this.cachedAffinities.length)]) {
            case ARCANE: {
                this.spawnArcaneParticles();
                break;
            }
            case EARTH: {
                this.spawnEarthParticles();
                break;
            }
            case ENDER: {
                this.spawnEnderParticles();
                break;
            }
            case FIRE: {
                this.spawnFireParticles(false, false);
                break;
            }
            case HELLFIRE: {
                this.spawnFireParticles(true, false);
                break;
            }
            case LIGHTNING: {
                this.spawnFireParticles(true, true);
                break;
            }
            case WATER: {
                this.spawnWaterParticles(false);
                break;
            }
            case ICE: {
                this.spawnWaterParticles(true);
                break;
            }
            case WIND: {
                this.spawnAirParticles();
                break;
            }
            default: {
                this.spawnArcaneParticles();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playSounds() {
        if (this.__playedsound) {
            return;
        }
        SpellRecipe recipe = this.getSpell();
        if (recipe == null) {
            return;
        }
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new EntityAliveLoopingSound(this.getSoundEffect(recipe), this));
        this.__playedsound = true;
    }

    protected float getShapeAttributeByAge(Attribute attr) {
        float base;
        SpellRecipe recipe = this.getSpell();
        if (recipe == null || recipe.getShape() == null) {
            return 0.0f;
        }
        float adjusted = ((ModifiedSpellPart)recipe.getShape()).getValue(attr);
        if (adjusted < (base = ((ModifiedSpellPart)recipe.getShape()).getDefaultValue(attr))) {
            return adjusted;
        }
        return base + (adjusted - base) * Math.min((float)this.field_70173_aa / 30.0f, 1.0f);
    }

    @Nullable
    public PlayerEntity getCaster() {
        Optional uuid;
        if (this.__cachedCaster == null && (uuid = (Optional)this.field_70180_af.func_187225_a(CASTER_UUID)).isPresent()) {
            this.__cachedCaster = this.field_70170_p.func_217371_b((UUID)uuid.get());
        }
        return this.__cachedCaster;
    }

    public void setCaster(PlayerEntity player) {
        if (player != null) {
            this.field_70180_af.func_187227_b(CASTER_UUID, Optional.of(player.func_110124_au()));
        }
    }

    public float getShapeAttribute(Attribute attr) {
        SpellRecipe recipe = this.getSpell();
        if (recipe == null || recipe.getShape() == null) {
            return 0.0f;
        }
        return ((ModifiedSpellPart)recipe.getShape()).getValue(attr);
    }

    protected int getMaxAge() {
        if (this.getSpell() == null || this.getSpell().getShape() == null || ((ModifiedSpellPart)this.getSpell().getShape()).getPart() == null) {
            return 100;
        }
        return ((Shape)((ModifiedSpellPart)this.getSpell().getShape()).getPart()).maxChannelTime(this.getSpell().getShape());
    }

    public SpellRecipe getSpell() {
        if (this.__cachedRecipe == null) {
            this.__cachedRecipe = SpellRecipe.fromNBT((CompoundNBT)this.field_70180_af.func_187225_a(SPELL_RECIPE));
        }
        return this.__cachedRecipe;
    }

    public void setSpell(ISpellDefinition spell) {
        CompoundNBT nbt = new CompoundNBT();
        spell.writeToNBT(nbt);
        this.field_70180_af.func_187227_b(SPELL_RECIPE, (Object)nbt);
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_218657_a(NBT_SPELL, (INBT)this.field_70180_af.func_187225_a(SPELL_RECIPE));
        Optional uuid = (Optional)this.field_70180_af.func_187225_a(CASTER_UUID);
        if (uuid.isPresent()) {
            compound.func_74778_a(NBT_CASTER_UUID, ((UUID)uuid.get()).toString());
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_74764_b(NBT_SPELL)) {
            this.field_70180_af.func_187227_b(SPELL_RECIPE, (Object)((CompoundNBT)compound.func_74781_a(NBT_SPELL)));
        }
        if (compound.func_74764_b(NBT_CASTER_UUID)) {
            UUID uuid = UUID.fromString(compound.func_74779_i(NBT_CASTER_UUID));
            this.field_70180_af.func_187227_b(CASTER_UUID, Optional.of(uuid));
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(CASTER_UUID, Optional.of(UUID.randomUUID()));
        this.field_70180_af.func_187214_a(SPELL_RECIPE, (Object)new CompoundNBT());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

