/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.sorcery.targeting;

import com.ma.api.particles.ParticleInit;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.entities.EntityInit;
import com.ma.entities.sorcery.base.ChanneledSpellEntity;
import com.ma.spells.SpellCaster;
import com.ma.spells.crafting.SpellRecipe;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntitySpellEmanation
extends ChanneledSpellEntity {
    public EntitySpellEmanation(EntityType<? extends EntitySpellEmanation> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntitySpellEmanation(PlayerEntity caster, ISpellDefinition spell, World world) {
        super((EntityType<? extends ChanneledSpellEntity>)((EntityType)EntityInit.SPELL_EMANATION.get()), caster, spell, world);
        this.func_70107_b(caster.func_226277_ct_(), caster.func_226278_cu_(), caster.func_226281_cx_());
    }

    @Override
    public void func_70071_h_() {
        if (this.getCaster() != null) {
            this.func_70107_b(this.getCaster().func_226277_ct_(), this.getCaster().func_225608_bj_() ? this.getCaster().func_226278_cu_() - 1.0 : this.getCaster().func_226278_cu_(), this.getCaster().func_226281_cx_());
        }
        super.func_70071_h_();
    }

    @Override
    protected void applyEffect(ItemStack stack, SpellRecipe recipe, PlayerEntity caster, ServerWorld world) {
        if (caster == null) {
            return;
        }
        float radius_h = this.getShapeAttributeByAge(Attribute.WIDTH);
        float radius_v = this.getShapeAttributeByAge(Attribute.HEIGHT);
        SpellSource source = new SpellSource((LivingEntity)caster);
        SpellContext context = new SpellContext(world, recipe);
        if (recipe.getComponents().stream().anyMatch(c -> ((Component)c.getPart()).targetsEntities())) {
            AxisAlignedBB bb = new AxisAlignedBB(this.func_226277_ct_() - (double)radius_h, this.func_226278_cu_(), this.func_226281_cx_() - (double)radius_h, this.func_226277_ct_() + (double)radius_h, this.func_226278_cu_() + (double)radius_v, this.func_226281_cx_() + (double)radius_h);
            List entities = world.func_72839_b((Entity)caster, bb);
            for (Entity e : entities) {
                SpellCaster.ApplyComponents(recipe, source, new SpellTarget(e), context);
            }
        }
        if (recipe.getComponents().stream().anyMatch(c -> ((Component)c.getPart()).targetsBlocks())) {
            BlockPos origin = this.func_233580_cy_();
            int i = -((int)radius_h);
            while ((float)i < radius_h) {
                int j = 0;
                while ((float)j < radius_v) {
                    int k = -((int)radius_h);
                    while ((float)k < radius_h) {
                        BlockPos adjusted = origin.func_177982_a(i, j, k);
                        SpellCaster.ApplyComponents(recipe, source, new SpellTarget(adjusted, Direction.UP), context);
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    @Override
    protected void spawnAirParticles() {
        Vector3d me = this.func_213303_ch();
        float radius = this.getShapeAttributeByAge(Attribute.WIDTH);
        float particle_spread = 0.0f;
        for (int i = 0; i < 20; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleInit.AIR_ORBIT.get(), me.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), me.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), me.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), (double)0.2f, (double)0.15f, (double)radius);
        }
    }

    @Override
    protected void spawnEarthParticles() {
        Vector3d me = this.func_213303_ch();
        float radius = this.getShapeAttributeByAge(Attribute.WIDTH);
        for (int i = 0; i < 50; ++i) {
            double angle = Math.random() * 2.0 * Math.PI;
            Vector3d offset = new Vector3d(Math.cos(angle) * (double)radius, 0.0, Math.sin(angle) * (double)radius);
            Vector3d pos = me.func_178787_e(offset);
            this.field_70170_p.func_195594_a((IParticleData)ParticleInit.DUST.get(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.1, 0.0);
        }
    }

    @Override
    protected void spawnFireParticles(boolean hellfire, boolean lightning) {
        Vector3d me = this.func_213303_ch();
        float radius = this.getShapeAttributeByAge(Attribute.WIDTH);
        if (!lightning) {
            for (int i = 0; i < 50; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                Vector3d offset = new Vector3d(Math.cos(angle) * (double)radius, 0.0, Math.sin(angle) * (double)radius);
                Vector3d pos = me.func_178787_e(offset);
                this.field_70170_p.func_195594_a(hellfire ? (IParticleData)ParticleInit.HELLFIRE.get() : (IParticleData)ParticleInit.FLAME.get(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.1, 0.0);
            }
        } else {
            Vector3d offset = new Vector3d((double)(-radius) + Math.random() * (double)radius * 2.0, (double)(-radius) + Math.random() * (double)radius * 2.0, (double)(-radius) + Math.random() * (double)radius * 2.0);
            Vector3d pos = me.func_178787_e(offset);
            this.field_70170_p.func_195594_a((IParticleData)ParticleInit.LIGHTNING_BOLT.get(), me.field_72450_a, me.field_72448_b, me.field_72449_c, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        }
    }

    @Override
    protected void spawnWaterParticles(boolean frost) {
        Vector3d me = this.func_213303_ch();
        float radius = this.getShapeAttributeByAge(Attribute.WIDTH);
        for (int i = 0; i < 50; ++i) {
            double angle = Math.random() * 2.0 * Math.PI;
            Vector3d offset = new Vector3d(Math.cos(angle) * (double)radius, 0.0, Math.sin(angle) * (double)radius);
            Vector3d pos = me.func_178787_e(offset);
            this.field_70170_p.func_195594_a(frost ? (IParticleData)ParticleInit.FROST.get() : (IParticleData)ParticleInit.WATER.get(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.1, 0.0);
        }
    }

    @Override
    protected void spawnEnderParticles() {
        Vector3d me = this.func_213303_ch();
        float radius = this.getShapeAttributeByAge(Attribute.WIDTH);
        for (int i = 0; i < 50; ++i) {
            double angle = Math.random() * 2.0 * Math.PI;
            Vector3d offset = new Vector3d(Math.cos(angle) * (double)radius, (double)0.1f, Math.sin(angle) * (double)radius);
            Vector3d pos = me.func_178787_e(offset);
            this.field_70170_p.func_195594_a((IParticleData)ParticleInit.ENDER.get(), me.field_72450_a, pos.field_72448_b, me.field_72449_c, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        }
    }

    @Override
    protected void spawnArcaneParticles() {
        Vector3d me = this.func_213303_ch();
        float radius = this.getShapeAttributeByAge(Attribute.WIDTH);
        for (int i = 0; i < 50; ++i) {
            double angle = Math.random() * 2.0 * Math.PI;
            Vector3d offset = new Vector3d(Math.cos(angle) * (double)radius, (double)0.1f + Math.abs(Math.sin((float)this.field_70173_aa / 0.02f)) * 1.75, Math.sin(angle) * (double)radius);
            Vector3d pos = me.func_178787_e(offset);
            this.field_70170_p.func_195594_a((IParticleData)ParticleInit.ARCANE_LERP.get(), me.field_72450_a, pos.field_72448_b, me.field_72449_c, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        }
    }
}

