/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.sorcery.targeting;

import com.ma.api.affinity.Affinity;
import com.ma.api.blocks.ISpellInteractibleBlock;
import com.ma.api.entities.ISpellInteractibleEntity;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.entities.EntityInit;
import com.ma.events.delayed.DelayedEventQueue;
import com.ma.events.delayed.TimedDelayedSpellEffect;
import com.ma.spells.SpellCaster;
import com.ma.spells.crafting.ModifiedSpellPart;
import com.ma.spells.crafting.SpellRecipe;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntitySpellSmite
extends DamagingProjectileEntity {
    private static final DataParameter<CompoundNBT> SPELL_RECIPE = EntityDataManager.func_187226_a(EntitySpellSmite.class, (IDataSerializer)DataSerializers.field_192734_n);
    private static final Vector3d DOWN = new Vector3d(0.0, -1.0, 0.0);
    private List<Entity> hitEntities;
    public UUID shootingEntity;
    private int ticksInAir;
    private ArrayList<Affinity> affinities;
    private HashMap<Affinity, BiConsumer<Integer, Float>> particleFunctions = new HashMap();

    public EntitySpellSmite(EntityType<? extends EntitySpellSmite> type, World world) {
        super((EntityType)EntityInit.SMITE_PROJECTILE.get(), world);
        this.func_189654_d(true);
        this.particleFunctions.put(Affinity.ARCANE, this::spawnArcaneParticles);
        this.particleFunctions.put(Affinity.ENDER, this::spawnEnderParticles);
        this.particleFunctions.put(Affinity.FIRE, this::spawnFireParticles);
        this.particleFunctions.put(Affinity.HELLFIRE, this::spawnHellfireParticles);
        this.particleFunctions.put(Affinity.LIGHTNING, this::spawnLightningParticles);
        this.particleFunctions.put(Affinity.WATER, this::spawnWaterParticles);
        this.particleFunctions.put(Affinity.ICE, this::spawnFrostParticles);
        this.particleFunctions.put(Affinity.WIND, this::spawnWindParticles);
        this.particleFunctions.put(Affinity.EARTH, this::spawnEarthParticles);
    }

    public EntitySpellSmite(World worldIn, Vector3d position, CompoundNBT recipe, LivingEntity shooter) {
        super((EntityType)EntityInit.SMITE_PROJECTILE.get(), worldIn);
        this.func_70107_b(position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
        this.func_189654_d(true);
        this.func_212361_a((Entity)shooter);
        this.setSpellRecipe(recipe);
    }

    public void spawnParticles(int particleCount, float partialTick) {
        Affinity aff;
        if (this.affinities == null) {
            SpellRecipe recipe = SpellRecipe.fromNBT((CompoundNBT)this.field_70180_af.func_187225_a(SPELL_RECIPE));
            this.affinities = new ArrayList<Affinity>(recipe.getAffinity().keySet());
        }
        if (this.affinities != null && this.particleFunctions.containsKey((Object)(aff = this.affinities.get((int)(Math.random() * (double)this.affinities.size()))))) {
            this.particleFunctions.get((Object)aff).accept(particleCount, Float.valueOf(partialTick));
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SPELL_RECIPE, (Object)new CompoundNBT());
    }

    public void setSpellRecipe(CompoundNBT recipe) {
        this.field_70180_af.func_187227_b(SPELL_RECIPE, (Object)recipe);
    }

    protected void entityHit(Entity entity) {
        this.applyEffect(this.func_233580_cy_(), this.func_174811_aO(), entity);
        this.func_70106_y();
    }

    protected void blockHit(BlockPos pos, Direction face) {
        this.applyEffect(pos, Direction.DOWN, null);
        this.func_70106_y();
    }

    private void applyEffect(BlockPos impactPoint, Direction face, @Nullable Entity hitEntity) {
        if (this.getShooterAsPlayer() == null) {
            this.func_70106_y();
            return;
        }
        SpellSource source = new SpellSource((LivingEntity)this.getShooterAsPlayer());
        SpellRecipe recipe = SpellRecipe.fromNBT((CompoundNBT)this.field_70180_af.func_187225_a(SPELL_RECIPE));
        if (recipe.isValid() && !this.field_70170_p.field_72995_K) {
            int vRadius;
            BlockState state = this.field_70170_p.func_180495_p(impactPoint);
            if (state.func_177230_c() instanceof ISpellInteractibleBlock && ((ISpellInteractibleBlock)state.func_177230_c()).onHitBySpell(this.field_70170_p, impactPoint, recipe)) {
                this.func_70106_y();
                return;
            }
            if (hitEntity != null && hitEntity instanceof ISpellInteractibleEntity && ((ISpellInteractibleEntity)hitEntity).onShapeTarget(recipe, source)) {
                this.func_70106_y();
                return;
            }
            float spellRadius = ((ModifiedSpellPart)recipe.getShape()).getValue(Attribute.RADIUS);
            float spellVerticalRadius = ((ModifiedSpellPart)recipe.getShape()).getValue(Attribute.HEIGHT);
            SpellContext context = new SpellContext((ServerWorld)this.field_70170_p, recipe);
            int radius = (int)Math.floor(spellRadius);
            if (radius < 0) {
                radius = 0;
            }
            if ((vRadius = (int)Math.floor(spellVerticalRadius) - 1) < 0) {
                vRadius = 0;
            }
            if (recipe.getComponents().stream().anyMatch(c -> ((Component)c.getPart()).targetsBlocks())) {
                SpellCaster.spawnClientFX(this.field_70170_p, this.func_213303_ch(), source, recipe);
                int delay = 1;
                if (radius > 0 || hitEntity == null) {
                    Spiral s = new Spiral(radius * 2, radius * 2);
                    for (Point p : s.spiral()) {
                        for (int j = vRadius; j >= -vRadius; --j) {
                            BlockPos adjusted = impactPoint.func_177982_a(p.x, j, p.y);
                            int loopDelay = delay;
                            recipe.iterateComponents(c -> {
                                if (((Component)c.getPart()).targetsBlocks() && !context.hasBlockBeenAffected((Component)c.getPart(), adjusted)) {
                                    DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedSpellEffect("smiteLoop", (int)((float)loopDelay + c.getValue(Attribute.DELAY) * 20.0f), source, new SpellTarget(adjusted, face), (IModifiedSpellPart<Component>)c, context));
                                }
                            });
                        }
                        ++delay;
                    }
                }
            }
            if (recipe.getComponents().stream().anyMatch(c -> ((Component)c.getPart()).targetsEntities())) {
                List targets = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a((double)spellRadius, (double)spellVerticalRadius, (double)spellRadius).func_72321_a((double)(-spellRadius), 0.0, (double)(-spellRadius)), e -> !e.func_190530_aW());
                if (hitEntity != null && !targets.contains(hitEntity)) {
                    targets.add(hitEntity);
                }
                for (Entity target : targets) {
                    if (target == null || target == this.getShooterAsPlayer()) continue;
                    recipe.iterateComponents(c -> {
                        if (((Component)c.getPart()).targetsEntities() && !context.hasEntityBeenAffected((Component)c.getPart(), target)) {
                            ((Component)c.getPart()).ApplyEffect(source, new SpellTarget(target), (IModifiedSpellPart<Component>)c, context);
                            context.addAffectedEntity((Component)c.getPart(), target);
                        }
                    });
                }
            }
            switch (recipe.getHighestAffinity()) {
                case ARCANE: {
                    this.field_70170_p.func_184133_a(null, impactPoint, SFX.Spell.Impact.AoE.ARCANE, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    this.field_70170_p.func_184133_a(null, impactPoint, SoundEvents.field_191244_bn, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                case EARTH: {
                    this.field_70170_p.func_184133_a(null, impactPoint, SFX.Spell.Impact.AoE.EARTH, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                case ENDER: {
                    this.field_70170_p.func_184133_a(null, impactPoint, SoundEvents.field_191244_bn, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                case FIRE: 
                case HELLFIRE: {
                    this.field_70170_p.func_184133_a(null, impactPoint, SFX.Spell.Impact.AoE.EARTH, SoundCategory.PLAYERS, 0.5f, 1.0f);
                    this.field_70170_p.func_184133_a(null, impactPoint, SoundEvents.field_187616_bj, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                case LIGHTNING: {
                    break;
                }
                case WATER: {
                    this.field_70170_p.func_184133_a(null, impactPoint, SoundEvents.field_204328_gh, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                case ICE: {
                    this.field_70170_p.func_184133_a(null, impactPoint, SoundEvents.field_187561_bM, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    this.field_70170_p.func_184133_a(null, impactPoint, SoundEvents.field_187813_fI, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                case WIND: {
                    this.field_70170_p.func_184133_a(null, impactPoint, SFX.Spell.Impact.AoE.WIND, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    break;
                }
            }
        }
    }

    protected void onHit(RayTraceResult raytraceResultIn) {
        RayTraceResult.Type raytraceresult$type = raytraceResultIn.func_216346_c();
        if (raytraceresult$type == RayTraceResult.Type.ENTITY) {
            this.func_213868_a((EntityRayTraceResult)raytraceResultIn);
        } else if (raytraceresult$type == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)raytraceResultIn;
            this.blockHit(blockraytraceresult.func_216350_a(), blockraytraceresult.func_216354_b());
        }
    }

    public void onRemovedFromWorld() {
        SpellRecipe recipe;
        super.onRemovedFromWorld();
        if (this.field_70170_p.field_72995_K && (recipe = SpellRecipe.fromNBT((CompoundNBT)this.field_70180_af.func_187225_a(SPELL_RECIPE))).isValid()) {
            this.spawnParticleBurst("", Float.valueOf(((ModifiedSpellPart)recipe.getShape()).getValue(Attribute.RADIUS)));
        }
    }

    private PlayerEntity getShooterAsPlayer() {
        Entity shooter = this.getShooter();
        if (shooter != null && shooter instanceof PlayerEntity) {
            return (PlayerEntity)shooter;
        }
        return null;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_70075_an() {
        return false;
    }

    protected float func_213316_a(Pose poseIn, EntitySize sizeIn) {
        return 0.0f;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    @Nullable
    public Entity getShooter() {
        return this.shootingEntity != null && this.field_70170_p instanceof ServerWorld ? ((ServerWorld)this.field_70170_p).func_217461_a(this.shootingEntity) : null;
    }

    public void func_212361_a(@Nullable Entity entityIn) {
        this.shootingEntity = entityIn == null ? null : entityIn.func_110124_au();
    }

    public void func_213281_b(CompoundNBT compound) {
        if (this.shootingEntity != null) {
            compound.func_186854_a("OwnerUUID", this.shootingEntity);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        if (compound.func_186855_b("OwnerUUID")) {
            this.shootingEntity = compound.func_186857_a("OwnerUUID");
        }
    }

    @Nullable
    protected EntityRayTraceResult rayTraceEntities(Vector3d startVec, Vector3d endVec) {
        return ProjectileHelper.func_221269_a((World)this.field_70170_p, (Entity)this, (Vector3d)startVec, (Vector3d)endVec, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(DOWN).func_186662_g(1.0), p_213871_1_ -> !p_213871_1_.func_175149_v() && p_213871_1_.func_70089_S() && p_213871_1_.func_70067_L() && (p_213871_1_ != this.getShooter() || this.ticksInAir >= 5));
    }

    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        Entity entity = p_213868_1_.func_216348_a();
        this.entityHit(entity);
        if (!entity.func_70089_S() && this.hitEntities != null) {
            this.hitEntities.add(entity);
        }
    }

    public void func_70071_h_() {
        Vector3d Vector3d3;
        SpellRecipe recipe;
        if (this.field_70173_aa == 3 && !this.field_70170_p.field_72995_K && (recipe = SpellRecipe.fromNBT((CompoundNBT)this.field_70180_af.func_187225_a(SPELL_RECIPE))) != null && recipe.isValid() && recipe.getHighestAffinity() == Affinity.LIGHTNING) {
            this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), SFX.Spell.Impact.AoE.LIGHTNING, SoundCategory.PLAYERS, 0.5f, (float)(0.6 + Math.random() * 0.8));
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        ++this.ticksInAir;
        Vector3d Vector3d2 = this.func_213303_ch();
        BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, Vector3d3 = Vector3d2.func_178787_e(DOWN), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)this));
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            Vector3d3 = raytraceresult.func_216347_e();
        }
        while (this.func_70089_S()) {
            EntityRayTraceResult entityraytraceresult = this.rayTraceEntities(Vector3d2, Vector3d3);
            if (entityraytraceresult != null) {
                raytraceresult = entityraytraceresult;
            }
            if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                Entity entity1 = this.getShooter();
                if (entity instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity)) {
                    raytraceresult = null;
                    entityraytraceresult = null;
                }
            }
            if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((DamagingProjectileEntity)this, (RayTraceResult)raytraceresult)) {
                this.onHit((RayTraceResult)raytraceresult);
                this.field_70160_al = true;
            }
            if (entityraytraceresult == null) break;
            raytraceresult = null;
        }
        float speedFactor = 0.99f;
        if (this.func_70090_H()) {
            if (this.affinities.contains((Object)Affinity.FIRE)) {
                if (!this.field_70170_p.field_72995_K) {
                    this.remove(false);
                }
                return;
            }
            for (int j = 0; j < 4; ++j) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
            if (!this.affinities.contains((Object)Affinity.WATER)) {
                speedFactor = 0.6f;
            }
        }
        Vector3d newPos = this.func_213303_ch().func_178787_e(DOWN.func_186678_a((double)speedFactor));
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        this.func_70107_b(newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c);
        this.func_145775_I();
        if (this.field_70173_aa > 200) {
            this.remove(false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntitySpellSmite.func_184183_bd()) * d0;
    }

    public void spawnParticleBurst(String identifier, Float radius) {
        if (this.affinities == null || this.affinities.size() == 0) {
            return;
        }
        IParticleData particle = null;
        int count = 180;
        double angleRads = 0.0;
        double step = Math.PI * 2 / (double)count;
        double spacing = 0.2;
        block11: for (int i = 0; i < count; ++i) {
            Vector3d dir;
            angleRads += step;
            Affinity affinity = this.affinities.get((int)Math.random() * this.affinities.size());
            switch (affinity) {
                case ARCANE: {
                    particle = (IParticleData)ParticleInit.ARCANE.get();
                    break;
                }
                case EARTH: {
                    particle = (IParticleData)ParticleInit.DUST.get();
                    break;
                }
                case ENDER: {
                    dir = new Vector3d(Math.cos(angleRads), Math.random() * 0.1, Math.sin(angleRads)).func_72432_b().func_186678_a((double)(radius.floatValue() * 5.0f)).func_178787_e(this.func_213303_ch());
                    this.field_70170_p.func_195594_a((IParticleData)ParticleInit.ENDER.get(), dir.field_72450_a, dir.field_72448_b, dir.field_72449_c, this.func_226277_ct_(), this.func_226278_cu_() + 0.25, this.func_226281_cx_());
                    continue block11;
                }
                case FIRE: {
                    particle = (IParticleData)ParticleInit.FLAME.get();
                    break;
                }
                case HELLFIRE: {
                    particle = (IParticleData)ParticleInit.HELLFIRE.get();
                    break;
                }
                case LIGHTNING: {
                    dir = new Vector3d(Math.cos(angleRads), (double)0.1f, Math.sin(angleRads)).func_72432_b().func_186678_a((double)(radius.floatValue() * 5.0f)).func_178787_e(this.func_213303_ch());
                    this.field_70170_p.func_195594_a((IParticleData)ParticleInit.LIGHTNING_BOLT.get(), this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), dir.field_72450_a, dir.field_72448_b + 1.0, dir.field_72449_c);
                    i += count / 10;
                    angleRads += step * (double)(count / 10);
                    continue block11;
                }
                case WATER: {
                    particle = (IParticleData)ParticleInit.WATER.get();
                    break;
                }
                case ICE: {
                    particle = (IParticleData)ParticleInit.FROST.get();
                    break;
                }
                case WIND: {
                    particle = (IParticleData)ParticleInit.AIR_VELOCITY.get();
                    break;
                }
                default: {
                    particle = (IParticleData)ParticleInit.SPARKLE_GRAVITY.get();
                }
            }
            if (particle == null) continue;
            dir = new Vector3d(Math.cos(angleRads), Math.random() * 0.1, Math.sin(angleRads)).func_72432_b();
            Vector3d vel = dir.func_186678_a((double)(0.3f * radius.floatValue()));
            dir = dir.func_186678_a(0.2);
            this.field_70170_p.func_195594_a(particle, this.func_226277_ct_() + dir.field_72450_a, this.func_226278_cu_() + Math.random(), this.func_226281_cx_() + dir.field_72449_c, vel.field_72450_a, vel.field_72448_b, vel.field_72449_c);
        }
    }

    public void spawnArcaneParticles(int particleCount, float partialTick) {
        for (int j = 0; j < particleCount; ++j) {
            Vector3d pos = this.func_213303_ch().func_178787_e(DOWN.func_186678_a((double)partialTick * Math.random()));
            Vector3d velocity = new Vector3d((double)-0.05f + Math.random() * (double)0.1f, (double)-0.05f + Math.random() * (double)0.1f, (double)-0.05f + Math.random() * (double)0.1f);
            this.field_70170_p.func_195594_a((IParticleData)ParticleInit.ARCANE.get(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
    }

    public void spawnEnderParticles(int particleCount, float partialTick) {
        Vector3d pos = this.func_213303_ch().func_178787_e(DOWN.func_186678_a((double)partialTick * Math.random()));
        float particle_spread = 0.5f;
        for (int j = 0; j < particleCount; ++j) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleInit.ENDER.get(), pos.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72448_b + -2.0, pos.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        }
    }

    public void spawnEarthParticles(int particleCount, float partialTick) {
        Vector3d pos = this.func_213303_ch().func_178787_e(DOWN.func_186678_a((double)partialTick * Math.random()));
        float particle_spread = 0.05f;
        for (int j = 0; j < particleCount; ++j) {
            Vector3d velocity = new Vector3d((double)-0.05f + Math.random() * (double)0.1f, -0.5, (double)-0.05f + Math.random() * (double)0.1f);
            this.field_70170_p.func_195594_a((IParticleData)ParticleInit.DUST.get(), pos.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
    }

    public void spawnWaterParticles(int particleCount, float partialTick) {
        float particle_spread = 0.05f;
        for (int j = 0; j < particleCount; ++j) {
            Vector3d pos = this.func_213303_ch().func_178787_e(DOWN.func_186678_a(Math.random()));
            Vector3d velocity = new Vector3d((double)-0.05f + Math.random() * (double)0.1f, (double)-0.05f, (double)-0.05f + Math.random() * (double)0.1f);
            this.field_70170_p.func_195594_a((IParticleData)ParticleInit.WATER.get(), pos.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
    }

    public void spawnFireParticles(int particleCount, float partialTick) {
        for (int j = 0; j < particleCount; ++j) {
            Vector3d pos = this.func_213303_ch().func_72441_c(0.0, -Math.random(), 0.0);
            Vector3d velocity = new Vector3d(0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleInit.FLAME.get(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
    }

    public void spawnHellfireParticles(int particleCount, float partialTick) {
        Vector3d pos = this.func_213303_ch().func_178787_e(DOWN.func_186678_a((double)partialTick * Math.random()));
        float particle_spread = 0.05f;
        for (int j = 0; j < particleCount; ++j) {
            Vector3d velocity = new Vector3d((double)-0.05f + Math.random() * (double)0.1f, (double)-0.05f + Math.random() * (double)0.1f, (double)-0.05f + Math.random() * (double)0.1f);
            this.field_70170_p.func_195594_a((IParticleData)ParticleInit.HELLFIRE.get(), pos.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
    }

    public void spawnWindParticles(int particleCount, float partialTick) {
        Vector3d pos;
        float particle_spread = 0.0f;
        float v = 0.4f;
        float hVel = v / 2.0f;
        for (int i = 0; i < particleCount; ++i) {
            pos = this.func_213303_ch().func_178787_e(DOWN.func_186678_a((double)partialTick * Math.random()));
            this.field_70170_p.func_195594_a((IParticleData)ParticleInit.AIR_ORBIT.get(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, (double)0.6f * Math.random() + (double)0.1f, (double)-0.2f, 0.25);
        }
        if (Math.random() < (double)0.8f) {
            return;
        }
        pos = this.func_213303_ch().func_178787_e(DOWN.func_186678_a((double)partialTick * Math.random()));
        v = 0.1f;
        hVel = 0.05f;
        Biome curBiome = this.field_70170_p.func_226691_t_(this.func_233580_cy_());
        switch (curBiome.func_201856_r()) {
            case BEACH: 
            case DESERT: {
                Vector3d velocity = new Vector3d((double)(-hVel) + Math.random() * (double)v, (double)(-hVel) + Math.random() * (double)v, (double)(-hVel) + Math.random() * (double)v);
                this.field_70170_p.func_195594_a((IParticleData)ParticleInit.DUST.get(), pos.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
                break;
            }
            case FOREST: 
            case JUNGLE: 
            case PLAINS: 
            case SAVANNA: {
                this.field_70170_p.func_195594_a((IParticleData)ParticleInit.EARTH.get(), pos.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), 0.12156862765550613, 0.4431372582912445, 0.12156862765550613);
                break;
            }
            case ICY: 
            case TAIGA: 
            case EXTREME_HILLS: 
            case MESA: {
                Vector3d velocity = new Vector3d((double)(-hVel) + Math.random() * (double)v, (double)(-hVel) + Math.random() * (double)v, (double)(-hVel) + Math.random() * (double)v);
                this.field_70170_p.func_195594_a((IParticleData)ParticleInit.FROST.get(), pos.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
                break;
            }
            case NETHER: {
                break;
            }
            case OCEAN: 
            case RIVER: 
            case SWAMP: {
                Vector3d velocity = new Vector3d((double)(-hVel) + Math.random() * (double)v, (double)(-hVel) + Math.random() * (double)v, (double)(-hVel) + Math.random() * (double)v);
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, pos.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
                break;
            }
            case THEEND: {
                this.field_70170_p.func_195594_a((IParticleData)ParticleInit.ENDER.get(), pos.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                break;
            }
        }
    }

    public void spawnFrostParticles(int particleCount, float partialTick) {
        Vector3d pos = this.func_213303_ch().func_178787_e(DOWN.func_186678_a((double)partialTick * Math.random()));
        float particle_spread = 0.05f;
        for (int j = 0; j < particleCount; ++j) {
            Vector3d velocity = new Vector3d((double)-0.05f + Math.random() * (double)0.1f, (double)-0.05f + Math.random() * (double)0.1f, (double)-0.05f + Math.random() * (double)0.1f);
            this.field_70170_p.func_195594_a((IParticleData)ParticleInit.FROST.get(), pos.field_72450_a + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72448_b + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.field_72449_c + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
    }

    public void spawnLightningParticles(int particleCount, float partialTick) {
        BlockPos projected_impact = new BlockPos(this.func_213303_ch());
        for (int count = 0; this.field_70170_p.func_175623_d(projected_impact) && count < 30; ++count) {
            projected_impact = projected_impact.func_177977_b();
        }
        this.field_70170_p.func_195594_a((IParticleData)ParticleInit.LIGHTNING_BOLT.get(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_226277_ct_(), (double)projected_impact.func_177956_o(), this.func_226281_cx_());
    }

    private static class Spiral {
        private static final Point ORIGIN = new Point(0, 0);
        private final int width;
        private final int height;
        private Point point;
        private Direction direction = Direction.E;
        private List<Point> list = new ArrayList<Point>();

        public Spiral(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public List<Point> spiral() {
            this.point = ORIGIN;
            int steps = 1;
            while (this.list.size() < this.width * this.height) {
                this.advance(steps);
                this.advance(steps);
                ++steps;
            }
            return this.list;
        }

        private void advance(int n) {
            for (int i = 0; i < n; ++i) {
                if (this.inBounds(this.point)) {
                    this.list.add(this.point);
                }
                this.point = this.direction.advance(this.point);
            }
            this.direction = this.direction.next();
        }

        private boolean inBounds(Point p) {
            return Spiral.between(-this.width / 2, this.width / 2, p.x) && Spiral.between(-this.height / 2, this.height / 2, p.y);
        }

        private static boolean between(int low, int high, int n) {
            return low <= n && n <= high;
        }

        private static enum Direction {
            E(1, 0){

                @Override
                Direction next() {
                    return N;
                }
            }
            ,
            N(0, 1){

                @Override
                Direction next() {
                    return W;
                }
            }
            ,
            W(-1, 0){

                @Override
                Direction next() {
                    return S;
                }
            }
            ,
            S(0, -1){

                @Override
                Direction next() {
                    return E;
                }
            };

            private int dx;
            private int dy;

            Point advance(Point point) {
                return new Point(point.x + this.dx, point.y + this.dy);
            }

            abstract Direction next();

            private Direction(int dx, int dy) {
                this.dx = dx;
                this.dy = dy;
            }
        }
    }
}

