/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.summon;

import com.ma.entities.EntityInit;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityAnimusBlock
extends MobEntity
implements IMob {
    protected static final DataParameter<BlockPos> ORIGIN = EntityDataManager.func_187226_a(EntityAnimusBlock.class, (IDataSerializer)DataSerializers.field_187200_j);
    protected static final DataParameter<Integer> BLOCK_STATE_ID = EntityDataManager.func_187226_a(EntityAnimusBlock.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> DURATION = EntityDataManager.func_187226_a(EntityAnimusBlock.class, (IDataSerializer)DataSerializers.field_187192_b);
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private boolean wasOnGround;
    private boolean fireImmune = false;
    private BlockState fallTile = Blocks.field_150354_m.func_176223_P();

    public EntityAnimusBlock(EntityType<? extends MobEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
    }

    public EntityAnimusBlock(World worldIn, BlockState state, BlockPos pos, int duration) {
        this((EntityType<? extends MobEntity>)((EntityType)EntityInit.ANIMUS_BLOCK.get()), worldIn);
        this.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
        this.fallTile = state;
        this.field_70156_m = true;
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(BLOCK_STATE_ID, (Object)Block.func_196246_j((BlockState)this.fallTile));
            this.field_70180_af.func_187227_b(DURATION, (Object)duration);
            this.field_70180_af.func_187227_b(ORIGIN, (Object)pos);
        }
        this.fireImmune = this.fallTile.getFireSpreadSpeed((IBlockReader)worldIn, pos, Direction.DOWN) == 0;
    }

    public AxisAlignedBB func_174813_aQ() {
        return super.func_174813_aQ();
    }

    public boolean func_230279_az_() {
        return this.fireImmune;
    }

    public void func_70071_h_() {
        if (this.field_70173_aa == 1 && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_180501_a((BlockPos)this.field_70180_af.func_187225_a(ORIGIN), Blocks.field_150350_a.func_176223_P(), 3);
        }
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        super.func_70071_h_();
        if (this.field_70122_E && !this.wasOnGround) {
            int i = 1;
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
                this.field_70170_p.func_195594_a(this.getSquishParticle(), this.func_226277_ct_() + (double)f2, this.func_226278_cu_(), this.func_226281_cx_() + (double)f3, 0.0, 0.0, 0.0);
            }
            this.func_184185_a(this.getSquishSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E && this.wasOnGround) {
            this.squishAmount = 1.0f;
        }
        this.wasOnGround = this.field_70122_E;
        this.alterSquishAmount();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa >= (Integer)this.field_70180_af.func_187225_a(DURATION)) {
            this.remove(false);
            BlockState target = this.field_70170_p.func_180495_p(this.func_233580_cy_());
            FakePlayer player = FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.field_70170_p));
            ItemStack stack = new ItemStack((IItemProvider)this.func_213339_cH().func_177230_c());
            if (this.field_70170_p.func_175623_d(this.func_233580_cy_()) || target.func_196953_a(new BlockItemUseContext((PlayerEntity)player, Hand.MAIN_HAND, stack, new BlockRayTraceResult(this.func_213303_ch(), this.func_184172_bi(), this.func_233580_cy_(), true)))) {
                this.field_70170_p.func_175656_a(this.func_233580_cy_(), this.func_213339_cH());
                this.func_213339_cH().func_177230_c().func_180633_a(this.field_70170_p, this.func_233580_cy_(), this.func_213339_cH(), (LivingEntity)this, stack);
            } else {
                this.func_199701_a_(stack);
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ORIGIN, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(BLOCK_STATE_ID, (Object)Block.func_196246_j((BlockState)Blocks.field_150354_m.func_176223_P()));
        this.field_70180_af.func_187214_a(DURATION, (Object)10);
    }

    public void setOrigin(BlockPos origin) {
        this.field_70180_af.func_187227_b(ORIGIN, (Object)origin);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockPos getOrigin() {
        return (BlockPos)this.field_70180_af.func_187225_a(ORIGIN);
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    protected SoundEvent getSquishSound() {
        return this.func_213339_cH().func_215695_r().func_185841_e();
    }

    protected SoundEvent getJumpSound() {
        return this.func_213339_cH().func_215695_r().func_185845_c();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public BlockState func_213339_cH() {
        return Block.func_196257_b((int)((Integer)this.field_70180_af.func_187225_a(BLOCK_STATE_ID)));
    }

    public void func_70037_a(CompoundNBT compound) {
        this.fallTile = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("BlockState"));
        if (this.fallTile.func_196958_f()) {
            this.fallTile = Blocks.field_150354_m.func_176223_P();
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_218657_a("BlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.fallTile));
    }

    protected IParticleData getSquishParticle() {
        return new BlockParticleData(ParticleTypes.field_197611_d, this.func_213339_cH());
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(20) + 10;
    }

    public static AttributeModifierMap.MutableAttribute getGlobalAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233823_f_, 5.0);
    }

    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_213339_cH() == Blocks.field_150335_W.func_176223_P()) {
                this.func_70106_y();
                this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 4.0f, Explosion.Mode.NONE);
                return;
            }
            if (this.func_213339_cH().func_177230_c() instanceof FireBlock) {
                this.func_70106_y();
                entityIn.func_70097_a(DamageSource.field_76370_b, 5.0f);
                entityIn.func_70015_d(10);
                return;
            }
        }
        if (entityIn == this.func_70638_az()) {
            this.dealDamage((LivingEntity)entityIn);
        }
    }

    protected void dealDamage(LivingEntity entityIn) {
        if (this.func_70089_S()) {
            int i = 3;
            if (this.func_70068_e((Entity)entityIn) < 0.6 * (double)i * 0.6 * (double)i && this.func_70685_l((Entity)entityIn) && entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), this.getAttackDamage())) {
                this.func_184185_a(SoundEvents.field_187870_fk, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.func_174815_a((LivingEntity)this, (Entity)entityIn);
            }
        }
    }

    protected float getAttackDamage() {
        return (float)this.func_233637_b_(Attributes.field_233823_f_);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new FloatGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FaceRandomGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new HopGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, false, e -> !(e instanceof EntityAnimusBlock) && e instanceof IMob && Math.abs(e.func_226278_cu_() - this.func_226278_cu_()) <= 4.0));
    }

    static class MoveHelperController
    extends MovementController {
        private float yRot;
        private int jumpDelay;
        private final EntityAnimusBlock slime;
        private boolean isAggressive;

        public MoveHelperController(EntityAnimusBlock slimeIn) {
            super((MobEntity)slimeIn);
            this.slime = slimeIn;
            this.yRot = 180.0f * slimeIn.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float yRotIn, boolean aggressive) {
            this.yRot = yRotIn;
            this.isAggressive = aggressive;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = MovementController.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != MovementController.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = MovementController.Action.WAIT;
                if (this.field_75648_a.func_233570_aj_()) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_233637_b_(Attributes.field_233821_d_)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.func_70683_ar().func_75660_a();
                        this.slime.func_184185_a(this.slime.getJumpSound(), this.slime.func_70599_aP(), 1.0f);
                    } else {
                        this.slime.field_70702_br = 0.0f;
                        this.slime.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_233637_b_(Attributes.field_233821_d_)));
                }
            }
        }
    }

    static class HopGoal
    extends Goal {
        private final EntityAnimusBlock slime;

        public HopGoal(EntityAnimusBlock slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !this.slime.func_184218_aH();
        }

        public void func_75246_d() {
            ((MoveHelperController)this.slime.func_70605_aq()).setSpeed(1.0);
        }
    }

    static class FloatGoal
    extends Goal {
        private final EntityAnimusBlock slime;

        public FloatGoal(EntityAnimusBlock slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            slimeIn.func_70661_as().func_212239_d(true);
        }

        public boolean func_75250_a() {
            return (this.slime.func_70090_H() || this.slime.func_180799_ab()) && this.slime.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75246_d() {
            if (this.slime.func_70681_au().nextFloat() < 0.8f) {
                this.slime.func_70683_ar().func_75660_a();
            }
            ((MoveHelperController)this.slime.func_70605_aq()).setSpeed(1.2);
        }
    }

    static class FaceRandomGoal
    extends Goal {
        private final EntityAnimusBlock slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public FaceRandomGoal(EntityAnimusBlock slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return this.slime.func_70638_az() == null && (this.slime.field_70122_E || this.slime.func_70090_H() || this.slime.func_180799_ab() || this.slime.func_70644_a(Effects.field_188424_y)) && this.slime.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75246_d() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.slime.func_70681_au().nextInt(60);
                this.chosenDegrees = this.slime.func_70681_au().nextInt(360);
            }
            ((MoveHelperController)this.slime.func_70605_aq()).setDirection(this.chosenDegrees, false);
        }
    }

    static class AttackGoal
    extends Goal {
        private final EntityAnimusBlock slime;
        private int growTieredTimer;

        public AttackGoal(EntityAnimusBlock slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.slime.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            return livingentity instanceof PlayerEntity && ((PlayerEntity)livingentity).field_71075_bZ.field_75102_a ? false : this.slime.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75249_e() {
            this.growTieredTimer = 300;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            LivingEntity livingentity = this.slime.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            if (livingentity instanceof PlayerEntity && ((PlayerEntity)livingentity).field_71075_bZ.field_75102_a) {
                return false;
            }
            return --this.growTieredTimer > 0;
        }

        public void func_75246_d() {
            this.slime.func_70625_a((Entity)this.slime.func_70638_az(), 10.0f, 10.0f);
            ((MoveHelperController)this.slime.func_70605_aq()).setDirection(this.slime.field_70177_z, true);
        }
    }
}

