/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.utility;

import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.spells.crafting.SpellRecipe;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntitySpellFX
extends Entity {
    private static final DataParameter<CompoundNBT> SPELL_RECIPE = EntityDataManager.func_187226_a(EntitySpellFX.class, (IDataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<Integer> SFX = EntityDataManager.func_187226_a(EntitySpellFX.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> CASTER_UUID = EntityDataManager.func_187226_a(EntitySpellFX.class, (IDataSerializer)DataSerializers.field_187194_d);
    private SpellRecipe _cachedRecipe;
    private int age = 0;
    private boolean playedSound = false;

    public EntitySpellFX(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public void func_70071_h_() {
        PlayerEntity caster = this.getCaster(this.field_70170_p);
        if (caster != null) {
            if (!this.playedSound) {
                this.getRecipe().iterateComponents(c -> {
                    if (((Component)c.getPart()).SoundEffect() != null) {
                        this.field_70170_p.func_184133_a(this.getCaster(this.field_70170_p), this.func_233580_cy_(), ((Component)c.getPart()).SoundEffect(), SoundCategory.PLAYERS, 0.25f, 1.0f);
                    }
                });
                this.playedSound = true;
            }
            if (this.field_70170_p.field_72995_K && this.getRecipe() != null) {
                this.getRecipe().iterateComponents(c -> ((Component)c.getPart()).SpawnParticles(this.field_70170_p, this.func_213303_ch(), this.age, this.getCaster(this.field_70170_p), this.getRecipe()));
            }
        }
        ++this.age;
        if (this.age >= 100) {
            this.remove(false);
        }
    }

    public boolean func_70075_an() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public void func_70024_g(double x, double y, double z) {
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SFX, (Object)-1);
        this.field_70180_af.func_187214_a(CASTER_UUID, (Object)"");
        this.field_70180_af.func_187214_a(SPELL_RECIPE, (Object)new CompoundNBT());
    }

    public void setRecipe(ISpellDefinition recipe) {
        CompoundNBT nbt = new CompoundNBT();
        recipe.writeToNBT(nbt);
        this.field_70180_af.func_187227_b(SPELL_RECIPE, (Object)nbt);
    }

    @Nullable
    private SpellRecipe getRecipe() {
        if (this._cachedRecipe == null) {
            CompoundNBT nbt = (CompoundNBT)this.field_70180_af.func_187225_a(SPELL_RECIPE);
            this._cachedRecipe = SpellRecipe.fromNBT(nbt);
        }
        return this._cachedRecipe;
    }

    public void setCasterUUID(@Nullable PlayerEntity player) {
        if (player != null && player.func_110124_au() != null) {
            this.field_70180_af.func_187227_b(CASTER_UUID, (Object)player.func_110124_au().toString());
        }
    }

    @Nullable
    public PlayerEntity getCaster(World world) {
        String s = (String)this.field_70180_af.func_187225_a(CASTER_UUID);
        try {
            UUID uuid = UUID.fromString(s);
            return world.func_217371_b(uuid);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

