/*
 * Decompiled with CFR 0.152.
 */
package com.ma.events;

import com.ma.api.capabilities.IWorldMagic;
import com.ma.api.events.SpellCastEvent;
import com.ma.api.spells.DamageTypes;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.worlddata.WorldMagicProvider;
import com.ma.effects.EffectInit;
import com.ma.gui.containers.providers.NamedCantrips;
import com.ma.gui.containers.providers.NamedGuideBook;
import com.ma.items.ItemGuideBook;
import com.ma.items.ItemInit;
import com.ma.items.artifice.ItemEnderguardAmulet;
import com.ma.items.artifice.ItemWardingAmulet;
import com.ma.items.artifice.ItemWitherguardAmulet;
import com.ma.items.artifice.curio.ItemEmberglowBracelet;
import com.ma.tools.math.MathUtilities;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.LecternBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.LecternTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkHooks;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="mana-and-artifice", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEventHandler {
    @SubscribeEvent
    public static void onItemRightClicked(PlayerInteractEvent.RightClickItem event) {
        PlayerEntity player = event.getPlayer();
        if (!player.field_70170_p.field_72995_K && event.getItemStack() != null && event.getItemStack().func_77973_b() == Items.field_151116_aA) {
            CommonEventHandler.handleRightClick_Leather(player, event);
        }
    }

    private static void handleRightClick_Leather(PlayerEntity player, PlayerInteractEvent.RightClickItem event) {
        ItemStack activeStack = player.func_184586_b(event.getHand());
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vector3d vec3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        Vector3d vec3d1 = vec3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        BlockRayTraceResult raytraceresult = player.field_70170_p.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.SOURCE_ONLY, (Entity)player));
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            int level;
            BlockState state = player.field_70170_p.func_180495_p(raytraceresult.func_216350_a());
            if (state == Blocks.field_150355_j.func_176223_P()) {
                ItemStack vellum = new ItemStack((IItemProvider)ItemInit.VELLUM.get());
                if (!event.getPlayer().func_191521_c(vellum)) {
                    event.getPlayer().func_146097_a(vellum, true, true);
                }
                activeStack.func_190918_g(1);
            } else if (state.func_177230_c() == Blocks.field_150383_bp && (level = ((Integer)state.func_177229_b((Property)BlockStateProperties.field_208130_ae)).intValue()) > 0) {
                ItemStack vellum = new ItemStack((IItemProvider)ItemInit.VELLUM.get(), 2);
                if (!event.getPlayer().func_191521_c(vellum)) {
                    event.getPlayer().func_146097_a(vellum, true, true);
                }
                ((CauldronBlock)Blocks.field_150383_bp.getBlock()).func_176590_a(player.field_70170_p, raytraceresult.func_216350_a(), state, level - 1);
                activeStack.func_190918_g(1);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockActivated(PlayerInteractEvent.RightClickBlock event) {
        IWorldMagic worldMagic;
        LazyOptional worldMagicContainer;
        TileEntity te;
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        if (world.func_180495_p(event.getPos()).func_177230_c() == Blocks.field_222428_lQ && (te = world.func_175625_s(event.getPos())) instanceof LecternTileEntity) {
            ItemStack bookStack = ((LecternTileEntity)te).func_214033_c();
            if (bookStack.func_77973_b() == ItemInit.GUIDE_BOOK.get()) {
                event.setCanceled(true);
                if (event.getPlayer().func_225608_bj_()) {
                    ((LecternTileEntity)te).func_214045_a(ItemStack.field_190927_a);
                    LecternBlock.func_220155_a((World)world, (BlockPos)event.getPos(), (BlockState)world.func_180495_p(event.getPos()), (boolean)false);
                    if (!event.getPlayer().func_191521_c(bookStack)) {
                        event.getPlayer().func_199701_a_(bookStack);
                    }
                } else if (!((ItemGuideBook)ItemInit.GUIDE_BOOK.get()).checkMagicUnlock((ServerWorld)world, event.getPlayer())) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)event.getPlayer()), (INamedContainerProvider)new NamedGuideBook());
                }
                return;
            }
            if (bookStack.func_77973_b() == ItemInit.CANTRIP_BOOK.get()) {
                event.setCanceled(true);
                if (event.getPlayer().func_225608_bj_()) {
                    ((LecternTileEntity)te).func_214045_a(ItemStack.field_190927_a);
                    LecternBlock.func_220155_a((World)world, (BlockPos)event.getPos(), (BlockState)world.func_180495_p(event.getPos()), (boolean)false);
                    if (!event.getPlayer().func_191521_c(bookStack)) {
                        event.getPlayer().func_199701_a_(bookStack);
                    }
                } else {
                    event.getPlayer().getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                        if (m.isMagicUnlocked()) {
                            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)event.getPlayer()), (INamedContainerProvider)new NamedCantrips());
                        } else {
                            event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.cantrip_book.confusion"), Util.field_240973_b_);
                        }
                    });
                }
                return;
            }
        }
        if ((worldMagicContainer = world.getCapability(WorldMagicProvider.MAGIC)).isPresent() && !(worldMagic = (IWorldMagic)worldMagicContainer.orElse(null)).canPlayerUnlock(event.getPos(), event.getPlayer())) {
            event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.rune_warding.warded"), Util.field_240973_b_);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockLeftClicked(PlayerInteractEvent.LeftClickBlock event) {
        IWorldMagic worldMagic;
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        LazyOptional worldMagicContainer = world.getCapability(WorldMagicProvider.MAGIC);
        if (worldMagicContainer.isPresent() && !(worldMagic = (IWorldMagic)worldMagicContainer.orElse(null)).canPlayerUnlock(event.getPos(), event.getPlayer())) {
            event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.rune_warding.warded"), Util.field_240973_b_);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        World world = (World)event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        IWorldMagic worldMagic = (IWorldMagic)world.getCapability(WorldMagicProvider.MAGIC).orElse(null);
        if (worldMagic != null && !worldMagic.canPlayerUnlock(event.getPos(), event.getPlayer())) {
            event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.rune_warding.warded"), Util.field_240973_b_);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.TRICKERY_BRACELET.get(), (LivingEntity)event.player).ifPresent(t -> event.player.func_82142_c(event.player.func_225608_bj_() || event.player.func_70644_a(Effects.field_76441_p) || event.player.func_70644_a((Effect)EffectInit.TRUE_INVISIBILITY.get())));
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        MobEntity monster;
        if (event.getEntityLiving().func_70660_b((Effect)EffectInit.WATERY_GRAVE.get()) != null && event.getEntityLiving().func_70090_H()) {
            event.getEntityLiving().func_70024_g(0.0, -0.2, 0.0);
        }
        if (event.getEntityLiving().func_70660_b((Effect)EffectInit.GRAVITY_WELL.get()) != null && event.getEntityLiving().field_70160_al && !event.getEntityLiving().func_70090_H() && !event.getEntityLiving().func_180799_ab()) {
            event.getEntityLiving().func_70024_g(0.0, -0.2, 0.0);
        }
        if (event.getEntityLiving().func_70660_b((Effect)EffectInit.PILGRIM.get()) != null) {
            if (!event.getEntityLiving().getPersistentData().func_74767_n("pilgrim_applied")) {
                event.getEntityLiving().field_70138_W += 1.0f;
                event.getEntityLiving().getPersistentData().func_74757_a("pilgrim_applied", true);
            }
        } else if (event.getEntityLiving().getPersistentData().func_74767_n("pilgrim_applied")) {
            event.getEntityLiving().field_70138_W -= 1.0f;
            event.getEntityLiving().getPersistentData().func_74757_a("pilgrim_applied", false);
        }
        if (event.getEntityLiving() instanceof MobEntity && (monster = (MobEntity)event.getEntityLiving()).func_70638_az() != null && monster.func_70638_az().func_70660_b((Effect)EffectInit.TRUE_INVISIBILITY.get()) != null && monster.func_70068_e((Entity)monster.func_70638_az()) > 9.0) {
            monster.func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving().func_70660_b((Effect)EffectInit.PILGRIM.get()) != null) {
            event.getEntityLiving().func_70024_g((double)((float)(event.getEntityLiving().func_213322_ci().field_72450_a * 0.15)), 0.25, (double)((float)(event.getEntityLiving().func_213322_ci().field_72449_c * 0.15)));
        }
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (player.func_70660_b((Effect)EffectInit.GRAVITY_WELL.get()) != null) {
                event.setDistance(event.getDistance() * 2.0f);
            }
            if (player.field_71071_by.func_70301_a(EquipmentSlotType.CHEST.func_188454_b()).func_77973_b() == ItemInit.SPECTRAL_ELYTRA.get()) {
                event.setDistance(event.getDistance() - 5.0f);
            }
        }
        if (event.getEntityLiving().func_70660_b((Effect)EffectInit.PILGRIM.get()) != null) {
            event.setDistance(event.getDistance() - 2.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        PlayerEntity player;
        if (event.getEntityLiving() instanceof PlayerEntity && (player = (PlayerEntity)event.getEntityLiving()).func_70660_b((Effect)EffectInit.CHRONO_ANCHOR.get()) != null) {
            player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                if (m.getChronoAnchorData().canRevert(player)) {
                    event.setCanceled(true);
                    player.func_195063_d((Effect)EffectInit.CHRONO_ANCHOR.get());
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getPlayer().func_70660_b((Effect)EffectInit.CHRONO_ANCHOR.get()) != null) {
            event.getPlayer().func_195063_d((Effect)EffectInit.CHRONO_ANCHOR.get());
        }
        event.getPlayer().getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
            m.setSyncGrimoire();
            m.forceSync();
        });
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        Entity source;
        boolean reduce;
        EffectInstance fire_shield = event.getEntityLiving().func_70660_b((Effect)EffectInit.FIRE_SHIELD.get());
        EffectInstance mana_shield = event.getEntityLiving().func_70660_b((Effect)EffectInit.MANA_SHIELD.get());
        EffectInstance briar_shield = event.getEntityLiving().func_70660_b((Effect)EffectInit.BRIARTHORN_BARRIER.get());
        EffectInstance life_tap = event.getEntityLiving().func_70660_b((Effect)EffectInit.LIFE_TAP.get());
        boolean bl = reduce = !event.getSource().func_76363_c();
        if (event.getSource() == DamageSource.field_82727_n && ((ItemWitherguardAmulet)ItemInit.WITHERGUARD_AMULET.get()).isEquippedAndHasMana(event.getEntityLiving(), 1.0f, true)) {
            event.setCanceled(true);
            return;
        }
        if (reduce && event.getSource().func_82725_o() && ((ItemWardingAmulet)ItemInit.WARDING_AMULET.get()).isEquippedAndHasMana(event.getEntityLiving(), 1.0f, true)) {
            event.setAmount(event.getAmount() - event.getAmount() * 0.1f);
        }
        if (event.getSource().func_76347_k()) {
            LivingEntity living = event.getEntityLiving();
            CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.EMBERGLOW_BRACELET.get(), living).ifPresent(t -> {
                event.setCanceled(true);
                if (living instanceof PlayerEntity) {
                    ((ItemEmberglowBracelet)ItemInit.EMBERGLOW_BRACELET.get()).consumeMana((ItemStack)t.getRight(), event.getAmount(), (PlayerEntity)living);
                }
            });
            if (fire_shield != null && reduce) {
                float reduction = event.getAmount() * 0.1f * (float)(fire_shield.func_76458_c() + 1);
                event.setAmount(event.getAmount() - reduction);
            }
        }
        if (mana_shield != null && reduce) {
            float reduction = event.getAmount() * 0.2f * (float)MathUtilities.clamp(mana_shield.func_76458_c() + 1, 1, 5);
            event.getEntityLiving().getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                float amountReduced = reduction;
                if (m.getMana() < amountReduced * 20.0f) {
                    amountReduced = m.getMana() / 20.0f;
                }
                m.consume(amountReduced * 20.0f);
                event.setAmount(event.getAmount() - amountReduced);
            });
        }
        if ((source = event.getSource().func_76346_g()) != null && source instanceof LivingEntity) {
            float damage;
            boolean retaliate;
            LivingEntity sourceLiving;
            LivingEntity living = event.getEntityLiving();
            double dist = living.func_70068_e((Entity)(sourceLiving = (LivingEntity)source));
            boolean bl2 = retaliate = dist <= 25.0;
            if (briar_shield != null) {
                if (event.getSource().func_76355_l().equals("thorns") || event.getSource().func_76355_l().equals("poison") || event.getSource().func_76355_l().equals("sting") || event.getSource().func_76355_l().equals("cactus") || event.getSource().func_76355_l().equals("sweetBerryBush")) {
                    float reduction = event.getAmount() * 0.1f * (float)(briar_shield.func_76458_c() + 1);
                    event.setAmount(event.getAmount() - reduction);
                }
                if (retaliate) {
                    damage = (briar_shield.func_76458_c() + 1) * 2;
                    sourceLiving.func_70097_a(DamageTypes.causeSourcedBriarDamage(living), damage);
                }
            }
            if (fire_shield != null && retaliate) {
                damage = (fire_shield.func_76458_c() + 1) * 2;
                sourceLiving.func_70097_a(DamageTypes.causeSourcedFireDamage(living), damage);
            }
            if (life_tap != null) {
                float healing = event.getAmount() * 0.05f * (float)(life_tap.func_76458_c() + 1);
                sourceLiving.func_70691_i(healing);
            }
            if (source instanceof PlayerEntity) {
                PlayerEntity sourcePlayer = (PlayerEntity)source;
                if (!event.getSource().func_76352_a()) {
                    CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.EMBERGLOW_BRACELET.get(), (LivingEntity)sourcePlayer).ifPresent(t -> {
                        if (living.func_70068_e(source) < 4.0) {
                            living.func_70015_d(4);
                        }
                        ((ItemStack)t.getRight()).func_222118_a(1, living, damager -> CuriosApi.getCuriosHelper().onBrokenCurio((String)t.getLeft(), ((Integer)t.getMiddle()).intValue(), damager));
                    });
                }
                if (sourcePlayer.func_225608_bj_() && sourcePlayer.func_184614_ca().func_190926_b()) {
                    CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.TRICKERY_BRACELET.get(), (LivingEntity)sourcePlayer).ifPresent(t -> {
                        living.func_233627_a_(5.0f, sourcePlayer.func_226277_ct_() - living.func_226277_ct_(), sourcePlayer.func_226281_cx_() - living.func_226281_cx_());
                        ((ItemStack)t.getRight()).func_222118_a(1, living, damager -> CuriosApi.getCuriosHelper().onBrokenCurio((String)t.getLeft(), ((Integer)t.getMiddle()).intValue(), damager));
                    });
                }
            }
        }
        if (event.getAmount() <= 0.0f) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onSpellCast(SpellCastEvent event) {
        CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.LEY_LINE_BRACELET.get(), (LivingEntity)event.getCaster()).ifPresent(t -> {});
    }

    @SubscribeEvent
    public static void onPlaySoundAtEntity(PlaySoundAtEntityEvent event) {
        if (event.getEntity() != null && event.getEntity() instanceof LivingEntity && ((LivingEntity)event.getEntity()).func_70660_b((Effect)EffectInit.TRUE_INVISIBILITY.get()) != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onMobGriefingEvent(EntityMobGriefingEvent event) {
        CreeperEntity creeper;
        Optional player;
        if (event.getEntity() instanceof CreeperEntity && (player = creeper.field_70170_p.func_175647_a(PlayerEntity.class, (creeper = (CreeperEntity)event.getEntity()).func_174813_aQ().func_186662_g(5.0), p -> ((ItemEnderguardAmulet)ItemInit.ENDERGUARD_AMULET.get()).isEquippedAndHasMana((LivingEntity)p, 50.0f, false)).stream().findFirst()).isPresent()) {
            CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.ENDERGUARD_AMULET.get(), (LivingEntity)player.get()).ifPresent(t -> {
                if (((ItemEnderguardAmulet)ItemInit.ENDERGUARD_AMULET.get()).consumeMana((ItemStack)t.right, 50.0f, (PlayerEntity)player.get())) {
                    int count = 0;
                    while (count++ < 50) {
                        double z;
                        double y;
                        double x = creeper.func_226277_ct_() + (creeper.func_70681_au().nextDouble() - 0.5) * 32.0;
                        Vector3d newPos = new Vector3d(x, y = MathHelper.func_151237_a((double)(creeper.func_226278_cu_() + (double)(creeper.func_70681_au().nextInt(16) - 8)), (double)0.0, (double)(creeper.field_70170_p.func_234938_ad_() - 1)), z = creeper.func_226281_cx_() + (creeper.func_70681_au().nextDouble() - 0.5) * 32.0);
                        if (!(newPos.func_72436_e(((PlayerEntity)player.get()).func_213303_ch()) >= 36.0) || !creeper.func_213373_a(x, y, z, true)) continue;
                        event.setResult(Event.Result.DENY);
                        creeper.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                        break;
                    }
                }
            });
        }
    }
}

