/*
 * Decompiled with CFR 0.152.
 */
package com.ma.events.delayed;

import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.events.delayed.IDelayedEvent;

public class TimedDelayedSpellEffect
implements IDelayedEvent {
    private int delay;
    private SpellSource source;
    private SpellTarget target;
    private IModifiedSpellPart<Component> component;
    private SpellContext context;
    private String identifier;

    public TimedDelayedSpellEffect(String identifier, int delay, SpellSource source, SpellTarget target, IModifiedSpellPart<Component> c, SpellContext context) {
        this.delay = delay;
        this.source = source;
        this.target = target;
        this.component = c;
        this.context = context;
    }

    @Override
    public boolean tick() {
        --this.delay;
        if (this.delay == 0) {
            if (this.source != null && this.target != null && this.context != null && this.component != null) {
                if (this.target.isBlock() && this.component.getPart().targetsBlocks() && !this.context.hasBlockBeenAffected(this.component.getPart(), this.target.getBlock())) {
                    this.component.getPart().ApplyEffect(this.source, this.target, this.component, this.context);
                    this.context.addAffectedBlock(this.component.getPart(), this.target.getBlock());
                } else if (this.target.isEntity() && this.component.getPart().targetsEntities() && !this.context.hasEntityBeenAffected(this.component.getPart(), this.target.getEntity())) {
                    this.component.getPart().ApplyEffect(this.source, this.target, this.component, this.context);
                    this.context.addAffectedEntity(this.component.getPart(), this.target.getEntity());
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String getID() {
        return this.identifier;
    }
}

