/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui;

import com.ma.api.capabilities.ICantrip;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.gui.GuiTextures;
import com.ma.gui.containers.ContainerCantrips;
import com.ma.network.ClientMessageDispatcher;
import com.ma.recipes.RecipeInit;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.ma.tools.render.GuiRenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiCantrips
extends ContainerScreen<ContainerCantrips> {
    ArrayList<ManaweavingPattern> playerKnownPatterns;
    IPlayerProgression progression;
    IPlayerMagic magic;
    ArrayList<Integer[]> cantripPatterns;
    int patternSpacing = 40;

    public GuiCantrips(ContainerCantrips screenContainer, PlayerInventory inv, ITextComponent title) {
        super((Container)screenContainer, inv, title);
        this.field_146999_f = 256;
        this.field_147000_g = 256;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.playerKnownPatterns = new ArrayList();
        this.progression = (IPlayerProgression)this.field_230706_i_.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        this.magic = (IPlayerMagic)this.field_230706_i_.field_71439_g.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        this.field_230706_i_.field_71441_e.func_199532_z().func_241447_a_(RecipeInit.MANAWEAVING_PATTERN_TYPE).stream().forEach(p -> {
            if (p.getTier() <= this.progression.getTier()) {
                this.playerKnownPatterns.add((ManaweavingPattern)p);
            }
        });
        this.cantripPatterns = new ArrayList();
        RecipeManager clientRecipeManager = this.field_230706_i_.field_71441_e.func_199532_z();
        for (int i = 0; i < this.magic.getCantripData().countRegisteredCantrips(); ++i) {
            ICantrip cantrip = this.magic.getCantripData().getCantrip(i);
            if (cantrip.getTier() > this.progression.getTier()) continue;
            this.cantripPatterns.add(new Integer[3]);
            for (int j = 0; j < 3; ++j) {
                if (cantrip != null) {
                    Optional pattern = clientRecipeManager.func_215367_a(cantrip.getPattern(j));
                    if (pattern.isPresent() && pattern.get() instanceof ManaweavingPattern) {
                        this.cantripPatterns.get((int)i)[j] = pattern != null ? this.playerKnownPatterns.indexOf(pattern.get()) : -1;
                        continue;
                    }
                    this.cantripPatterns.get((int)i)[j] = -1;
                    continue;
                }
                this.cantripPatterns.get((int)i)[j] = -1;
            }
        }
        if (this.progression.getTier() >= this.magic.getCantripData().getCantrip(0).getTier()) {
            this.initRowSelectionButtons(13, 45, 0);
        }
        if (this.progression.getTier() >= this.magic.getCantripData().getCantrip(1).getTier()) {
            this.initRowSelectionButtons(13, 99, 1);
        }
        if (this.progression.getTier() >= this.magic.getCantripData().getCantrip(2).getTier()) {
            this.initRowSelectionButtons(13, 153, 2);
        }
        if (this.progression.getTier() >= this.magic.getCantripData().getCantrip(3).getTier()) {
            this.initRowSelectionButtons(134, 45, 3);
        }
        if (this.progression.getTier() >= this.magic.getCantripData().getCantrip(4).getTier()) {
            this.initRowSelectionButtons(134, 99, 4);
        }
        if (this.progression.getTier() >= this.magic.getCantripData().getCantrip(5).getTier()) {
            this.initRowSelectionButtons(134, 153, 5);
        }
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        for (int i = 0; i < this.cantripPatterns.size(); ++i) {
            int patternIndex;
            ArrayList<ResourceLocation> patternIDs = new ArrayList<ResourceLocation>();
            for (int j = 0; j < this.cantripPatterns.get(i).length && (patternIndex = this.cantripPatterns.get(i)[j].intValue()) >= 0 && patternIndex < this.playerKnownPatterns.size(); ++j) {
                patternIDs.add(this.playerKnownPatterns.get(patternIndex).func_199560_c());
            }
            this.magic.getCantripData().setPattern(i, patternIDs);
        }
        ClientMessageDispatcher.sendCantripUpdateMessage(this.magic);
    }

    private void initRowSelectionButtons(int x, int y, int cantripIndex) {
        int i = 0;
        while (i < 3) {
            int count = i++;
            this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + x, this.field_147009_r + y, 3, 5, 3, 242, 5, GuiTextures.CANTRIP_BOOK, 256, 256, button -> {
                int idx = this.cantripPatterns.get(cantripIndex)[count] - 1;
                if (idx < (count < 2 ? 0 : -1)) {
                    idx = this.playerKnownPatterns.size() - 1;
                }
                this.cantripPatterns.get((int)cantripIndex)[count] = idx;
            }));
            this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + x + 25, this.field_147009_r + y, 3, 5, 0, 242, 5, GuiTextures.CANTRIP_BOOK, 256, 256, button -> {
                int idx = this.cantripPatterns.get(cantripIndex)[count] + 1;
                if (idx >= this.playerKnownPatterns.size()) {
                    idx = count < 2 ? 0 : -1;
                }
                this.cantripPatterns.get((int)cantripIndex)[count] = idx;
            }));
            x += this.patternSpacing;
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        int i;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GuiTextures.CANTRIP_BOOK);
        int topLeftCornerX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int topLeftCornerY = (this.field_230709_l_ - this.field_147000_g) / 2;
        int leftPageCenter = topLeftCornerX + 50;
        this.func_238474_b_(matrixStack, topLeftCornerX, topLeftCornerY, 0, 0, 256, 178);
        this.func_238474_b_(matrixStack, topLeftCornerX + 47, topLeftCornerY + 178, 94, 178, 162, 76);
        int pageY = topLeftCornerY + 5;
        if (this.progression.getTier() >= this.magic.getCantripData().getCantrip(0).getTier()) {
            this.func_238474_b_(matrixStack, leftPageCenter, pageY, 32, 178, 32, 32);
            pageY += 34;
            for (i = 0; i < 3; ++i) {
                this.func_238474_b_(matrixStack, topLeftCornerX + 18 + this.patternSpacing * i, pageY, 64, 178, 18, 18);
            }
            pageY += 20;
        }
        if (this.progression.getTier() >= this.magic.getCantripData().getCantrip(1).getTier()) {
            this.func_238474_b_(matrixStack, leftPageCenter, pageY, 0, 210, 32, 32);
            pageY += 34;
            for (i = 0; i < 3; ++i) {
                this.func_238474_b_(matrixStack, topLeftCornerX + 18 + this.patternSpacing * i, pageY, 64, 178, 18, 18);
            }
            pageY += 20;
        }
        if (this.progression.getTier() >= this.magic.getCantripData().getCantrip(2).getTier()) {
            this.func_238474_b_(matrixStack, leftPageCenter, pageY, 0, 178, 32, 32);
            pageY += 34;
            for (i = 0; i < 3; ++i) {
                this.func_238474_b_(matrixStack, topLeftCornerX + 18 + this.patternSpacing * i, pageY, 64, 178, 18, 18);
            }
        }
        if (this.progression.getTier() >= this.magic.getCantripData().getCantrip(3).getTier()) {
            pageY = topLeftCornerY + 5;
            this.func_238474_b_(matrixStack, topLeftCornerX + 135, pageY, 32, 210, 32, 32);
            this.func_238474_b_(matrixStack, topLeftCornerX + 144, pageY + 18, 6, 242, 14, 8);
            this.func_238474_b_(matrixStack, topLeftCornerX + 179, pageY + 9, 64, 196, 18, 18);
            pageY += 34;
            for (i = 0; i < 3; ++i) {
                this.func_238474_b_(matrixStack, topLeftCornerX + 139 + this.patternSpacing * i, pageY, 64, 178, 18, 18);
            }
        }
        if (this.progression.getTier() >= this.magic.getCantripData().getCantrip(4).getTier()) {
            this.func_238474_b_(matrixStack, topLeftCornerX + 135, pageY += 20, 32, 210, 32, 32);
            this.func_238474_b_(matrixStack, topLeftCornerX + 144, pageY + 18, 6, 242, 14, 8);
            this.func_238474_b_(matrixStack, topLeftCornerX + 144, pageY + 12, 6, 242, 14, 8);
            this.func_238474_b_(matrixStack, topLeftCornerX + 179, pageY + 9, 64, 196, 18, 18);
            pageY += 34;
            for (i = 0; i < 3; ++i) {
                this.func_238474_b_(matrixStack, topLeftCornerX + 139 + this.patternSpacing * i, pageY, 64, 178, 18, 18);
            }
        }
        if (this.progression.getTier() >= this.magic.getCantripData().getCantrip(5).getTier()) {
            this.func_238474_b_(matrixStack, topLeftCornerX + 135, pageY += 20, 32, 210, 32, 32);
            this.func_238474_b_(matrixStack, topLeftCornerX + 144, pageY + 18, 6, 242, 14, 8);
            this.func_238474_b_(matrixStack, topLeftCornerX + 144, pageY + 12, 6, 242, 14, 8);
            this.func_238474_b_(matrixStack, topLeftCornerX + 144, pageY + 6, 6, 242, 14, 8);
            this.func_238474_b_(matrixStack, topLeftCornerX + 179, pageY + 9, 64, 196, 18, 18);
            pageY += 34;
            for (i = 0; i < 3; ++i) {
                this.func_238474_b_(matrixStack, topLeftCornerX + 139 + this.patternSpacing * i, pageY, 64, 178, 18, 18);
            }
        }
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        GuiRenderUtils.bindManaweaveTextureRenderer();
        if (this.cantripPatterns.size() >= 1) {
            this.drawManaweavePatternCombo(matrixStack, 33, 41, this.cantripPatterns.get(0));
        }
        if (this.cantripPatterns.size() >= 2) {
            this.drawManaweavePatternCombo(matrixStack, 33, 95, this.cantripPatterns.get(1));
        }
        if (this.cantripPatterns.size() >= 3) {
            this.drawManaweavePatternCombo(matrixStack, 33, 149, this.cantripPatterns.get(2));
        }
        if (this.cantripPatterns.size() >= 4) {
            this.drawManaweavePatternCombo(matrixStack, 154, 41, this.cantripPatterns.get(3));
        }
        if (this.cantripPatterns.size() >= 5) {
            this.drawManaweavePatternCombo(matrixStack, 154, 95, this.cantripPatterns.get(4));
        }
        if (this.cantripPatterns.size() >= 6) {
            this.drawManaweavePatternCombo(matrixStack, 154, 149, this.cantripPatterns.get(5));
        }
    }

    private void drawManaweavePatternCombo(MatrixStack matrixStack, int x, int y, Integer[] patterns) {
        float scale = 0.1f;
        for (int i = 0; i < patterns.length; ++i) {
            Integer index = patterns[i];
            if (index != null && index >= 0) {
                ManaweavingPattern p = this.playerKnownPatterns.get(index);
                GuiRenderUtils.renderManaweavePattern(matrixStack, (int)((float)x / scale), (int)((float)y / scale), scale, p);
            }
            x += this.patternSpacing;
        }
    }
}

