/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui;

import com.google.common.collect.Lists;
import com.ma.Registries;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.sound.SFX;
import com.ma.api.spells.base.ISpellComponent;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.config.GeneralClientConfig;
import com.ma.config.MAClientConfig;
import com.ma.events.delayed.DelayedEventQueue;
import com.ma.events.delayed.TimedDelayedEvent;
import com.ma.gui.GuiTextures;
import com.ma.gui.HUDOverlayRenderer;
import com.ma.gui.containers.ContainerGuideBook;
import com.ma.guide.EntryCategories;
import com.ma.guide.GuideBookEntries;
import com.ma.guide.GuidebookEntry;
import com.ma.guide.RelatedRecipe;
import com.ma.guide.interfaces.IEntrySection;
import com.ma.guide.recipe.RecipeBlank;
import com.ma.guide.recipe.RecipeRendererBase;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableInt;

@OnlyIn(value=Dist.CLIENT)
public class GuiGuideBook
extends ContainerScreen<ContainerGuideBook> {
    private static final int X_PAGE_LEFT = 13;
    private static final int X_PAGE_RIGHT = 133;
    public static final int X_MAX = 110;
    public static final int Y_PAGE_START = 10;
    public static final int Y_MAX = 158;
    GuidebookEntry currentEntry = null;
    ImageButton prevPage = null;
    ImageButton nextPage = null;
    ImageButton back = null;
    ImageButton switchConfig_HUD = null;
    ImageButton switchConfig_HUDPOS = null;
    ImageButton switchConfig_BACK = null;
    ImageButton switchConfig_PINSIZE = null;
    ImageButton search = null;
    ITextComponent searchTerm;
    TextFieldWidget searchBox;
    RecipeBlank searchBackground;
    RecipeRendererBase currentRecipe = null;
    ImageButton closeRecipe = null;
    ImageButton pinRecipe = null;
    int page = 0;
    int max_pages = 1;
    boolean isSearching = false;
    IPlayerProgression progression = null;
    static List<ITextComponent> currentTooltip = new ArrayList<ITextComponent>();
    private ArrayList<ImageButton> relatedTabs;
    private ArrayList<CategoryItemButton> categoryButtons;
    private ArrayList<CodexSearchResult> searchResults;
    private EntryCategories currentCategory = EntryCategories.BASICS;

    protected GuiGuideBook(ContainerGuideBook container, PlayerInventory playerInventory, ITextComponent textComponent) {
        super((Container)container, playerInventory, textComponent);
        this.field_146999_f = 256;
        this.field_147000_g = 178;
        this.relatedTabs = new ArrayList();
        this.categoryButtons = new ArrayList();
        this.searchResults = new ArrayList();
        if (this.field_230706_i_ == null) {
            this.field_230706_i_ = Minecraft.func_71410_x();
        }
        this.progression = (IPlayerProgression)this.field_230706_i_.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        GuideBookEntries.INSTANCE.reload();
        this.categoryButtons.clear();
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.prevPage = new PaperImageButton(i + 10, j + 158, 14, 14, 0, 178, 14, GuiTextures.GUIDE_BOOK, 256, 256, button -> this.decrementPage());
        this.nextPage = new PaperImageButton(i + 233, j + 158, 14, 14, 14, 178, 14, GuiTextures.GUIDE_BOOK, 256, 256, button -> this.incrementPage());
        this.prevPage.field_230693_o_ = false;
        this.prevPage.field_230694_p_ = false;
        this.func_230480_a_((Widget)this.prevPage);
        this.func_230480_a_((Widget)this.nextPage);
        this.search = new PaperImageButton(i + 15, j + this.field_147000_g - 6, 18, 28, 118, 178, 28, GuiTextures.GUIDE_BOOK, 256, 256, button -> this.toggleSearch()).setTooltip((ITextComponent)new TranslationTextComponent("gui.mana-and-artifice.codex_search"));
        this.searchTerm = new TranslationTextComponent("gui.mana-and-artifice.codex_search");
        this.searchBox = new TextFieldWidget(this.field_230706_i_.field_71466_p, i + this.field_146999_f / 2 - 80, j - 33, 160, 20, this.searchTerm);
        this.searchBox.func_146203_f(60);
        this.searchBox.func_212954_a(this::runSearch);
        this.searchBackground = new RecipeBlank(this.field_147003_i + (this.field_146999_f - 218) / 2, this.field_147009_r + (this.field_147000_g - 256) / 2);
        this.func_230480_a_((Widget)this.search);
        this.back = new PaperImageButton(i - 20, j + this.field_147000_g / 2 - 14, 20, 38, 84, 178, 38, GuiTextures.GUIDE_BOOK, 256, 256, button -> this.setupIndexView());
        this.func_230480_a_((Widget)this.back);
        this.switchConfig_HUD = new PaperImageButton(i + 35, j + this.field_147000_g - 6, 18, 28, 136, 178, 28, GuiTextures.GUIDE_BOOK, 256, 256, button -> {
            int cur = MAClientConfig.CODEX_BACK_MODE.ordinal();
            GeneralClientConfig.CODEX_BACK_STYLE.set((Object)((cur + 1) % MAClientConfig.CodexMode.values().length));
            MAClientConfig.bakeConfig();
            ((PaperImageButton)button).setTooltip((ITextComponent)new TranslationTextComponent(MAClientConfig.CODEX_BACK_MODE.getLocalizationKey()));
        }).setTooltip((ITextComponent)new TranslationTextComponent(MAClientConfig.CODEX_BACK_MODE.getLocalizationKey()));
        this.switchConfig_HUDPOS = new PaperImageButton(i + 55, j + this.field_147000_g - 6, 18, 28, 172, 178, 28, GuiTextures.GUIDE_BOOK, 256, 256, button -> {
            int cur = MAClientConfig.HUD_POS.ordinal();
            GeneralClientConfig.HUD_POSITION.set((Object)((cur + 1) % MAClientConfig.HudPos.values().length));
            MAClientConfig.bakeConfig();
            ((PaperImageButton)button).setTooltip((ITextComponent)new TranslationTextComponent(MAClientConfig.HUD_POS.getLocalizationKey()));
        }).setTooltip((ITextComponent)new TranslationTextComponent(MAClientConfig.HUD_POS.getLocalizationKey()));
        this.switchConfig_PINSIZE = new PaperImageButton(i + 75, j + this.field_147000_g - 6, 18, 28, 190, 178, 28, GuiTextures.GUIDE_BOOK, 256, 256, button -> {
            int cur = MAClientConfig.PIN_SIZE.ordinal();
            GeneralClientConfig.PINNED_RECIPE_SCALE.set((Object)((cur + 1) % MAClientConfig.HudMode.values().length));
            MAClientConfig.bakeConfig();
            ((PaperImageButton)button).setTooltip((ITextComponent)new TranslationTextComponent(MAClientConfig.PIN_SIZE.getLocalizationKey()));
        }).setTooltip((ITextComponent)new TranslationTextComponent(MAClientConfig.PIN_SIZE.getLocalizationKey()));
        this.switchConfig_BACK = new PaperImageButton(i + 95, j + this.field_147000_g - 6, 18, 28, 154, 178, 28, GuiTextures.GUIDE_BOOK, 256, 256, button -> {
            int cur = MAClientConfig.HUD_MODE.ordinal();
            GeneralClientConfig.HIDE_HUD_MODE.set((Object)((cur + 1) % MAClientConfig.HudMode.values().length));
            MAClientConfig.bakeConfig();
            ((PaperImageButton)button).setTooltip((ITextComponent)new TranslationTextComponent(MAClientConfig.HUD_MODE.getLocalizationKey()));
        }).setTooltip((ITextComponent)new TranslationTextComponent(MAClientConfig.HUD_MODE.getLocalizationKey()));
        this.func_230480_a_((Widget)this.switchConfig_HUD);
        this.func_230480_a_((Widget)this.switchConfig_HUDPOS);
        this.func_230480_a_((Widget)this.switchConfig_PINSIZE);
        this.func_230480_a_((Widget)this.switchConfig_BACK);
        this.closeRecipe = new PaperImageButton(i + 210, j - 30, 14, 14, 104, 178, 14, GuiTextures.GUIDE_BOOK, 256, 256, button -> {
            this.clearDisplayedRecipe();
            this.clearSearch();
        });
        this.pinRecipe = new ImageButton(i + 30, j - 30, 14, 14, 104, 206, 14, GuiTextures.GUIDE_BOOK, 256, 256, button -> {
            if (HUDOverlayRenderer.instance.getPinnedrecipe() != null && HUDOverlayRenderer.instance.getPinnedrecipe().equals((Object)this.currentRecipe)) {
                HUDOverlayRenderer.instance.setPinnedRecipe(null);
            } else {
                HUDOverlayRenderer.instance.setPinnedRecipe(this.currentRecipe.clone(0, 0, true));
            }
        });
        String lastEntry = this.progression.getLastCodexEntry();
        if (lastEntry != null && !lastEntry.isEmpty()) {
            this.setCurrentEntry(lastEntry);
        } else {
            this.setupIndexView();
        }
        AbstractMap.SimpleEntry<String, ResourceLocation[]> lastRecipe = this.progression.getLastCodexRecipe();
        if (lastRecipe != null && lastRecipe.getKey() != null && lastRecipe.getValue() != null && !lastRecipe.getKey().isEmpty() && lastRecipe.getValue().length > 0) {
            this.displayRecipe(new RelatedRecipe(lastRecipe.getValue(), lastRecipe.getKey()));
        }
    }

    public void func_231164_f_() {
        super.func_231164_f_();
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if ((MAClientConfig.CODEX_BACK_MODE == MAClientConfig.CodexMode.EscUIBack || MAClientConfig.CODEX_BACK_MODE == MAClientConfig.CodexMode.RMouseUIEscBack) && keyCode == 256) {
            if (this.isSearching) {
                this.clearSearch();
                return true;
            }
            if (this.currentRecipe != null) {
                this.clearDisplayedRecipe();
                return true;
            }
            if (this.currentEntry != null) {
                this.setupIndexView();
                return true;
            }
        }
        if (this.isSearching && keyCode != 256) {
            return this.func_241217_q_() != null && this.func_241217_q_().func_231046_a_(keyCode, scanCode, modifiers);
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if ((MAClientConfig.CODEX_BACK_MODE == MAClientConfig.CodexMode.RMouseUIBackEscOut || MAClientConfig.CODEX_BACK_MODE == MAClientConfig.CodexMode.RMouseUIEscBack) && button == 1) {
            if (this.isSearching) {
                this.clearSearch();
                return true;
            }
            if (this.currentRecipe != null) {
                this.clearDisplayedRecipe();
                return true;
            }
            if (this.currentEntry != null) {
                this.setupIndexView();
                return true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    private void displayRecipe(RelatedRecipe rr) {
        this.clearDisplayedRecipe();
        this.currentRecipe = rr.constructRenderer(this.field_147003_i + (this.field_146999_f - 218) / 2, this.field_147009_r + (this.field_147000_g - 256) / 2, this::setCurrentTooltip);
        this.progression.setLastCodexRecipe(rr.getType(), rr.getResourceLocations());
        if (this.currentRecipe != null) {
            for (Widget widget : this.field_230710_m_) {
                if (this.relatedTabs.contains(widget)) continue;
                widget.field_230693_o_ = false;
            }
            this.func_230480_a_(this.currentRecipe);
            this.func_230480_a_((Widget)this.closeRecipe);
            this.func_230480_a_((Widget)this.pinRecipe);
        }
    }

    private void clearDisplayedRecipe() {
        if (this.currentRecipe == null) {
            return;
        }
        this.progression.setLastCodexRecipe("", null);
        this.field_230710_m_.remove((Object)this.currentRecipe);
        this.field_230705_e_.remove((Object)this.currentRecipe);
        this.field_230710_m_.remove(this.closeRecipe);
        this.field_230705_e_.remove(this.closeRecipe);
        this.field_230710_m_.remove(this.pinRecipe);
        this.field_230705_e_.remove(this.pinRecipe);
        for (Widget widget : this.field_230710_m_) {
            widget.field_230693_o_ = true;
        }
        this.currentRecipe = null;
    }

    private void toggleSearch() {
        if (this.isSearching) {
            this.clearSearch();
        } else {
            this.showSearch();
        }
    }

    private void showSearch() {
        this.clearDisplayedRecipe();
        for (Widget widget : this.field_230710_m_) {
            widget.field_230693_o_ = false;
        }
        this.func_230480_a_(this.searchBackground);
        this.func_230480_a_((Widget)this.searchBox);
        this.func_230480_a_((Widget)this.closeRecipe);
        DelayedEventQueue.pushEvent((World)this.field_230706_i_.field_71441_e, new TimedDelayedEvent<String>("focus", 1, "focus", this::fixFocus));
        this.isSearching = true;
    }

    private void fixFocus(String identifier, String data) {
        this.searchBox.func_146195_b(false);
        this.searchBox.func_231049_c__(true);
        this.func_231035_a_((IGuiEventListener)this.searchBox);
    }

    private void clearSearch() {
        this.field_230710_m_.remove(this.searchBox);
        this.field_230705_e_.remove(this.searchBox);
        this.field_230710_m_.remove((Object)this.searchBackground);
        this.field_230705_e_.remove((Object)this.searchBackground);
        this.field_230710_m_.remove(this.closeRecipe);
        this.field_230705_e_.remove(this.closeRecipe);
        for (CodexSearchResult r : this.searchResults) {
            this.field_230710_m_.remove((Object)r);
            this.field_230705_e_.remove((Object)r);
        }
        this.searchResults.clear();
        this.searchBox.func_146180_a("");
        for (Widget widget : this.field_230710_m_) {
            widget.field_230693_o_ = true;
        }
        this.isSearching = false;
    }

    private void runSearch(String term) {
        if (term.length() < 3) {
            return;
        }
        for (CodexSearchResult r : this.searchResults) {
            this.field_230710_m_.remove((Object)r);
            this.field_230705_e_.remove((Object)r);
        }
        this.searchResults.clear();
        MutableInt yCoord = new MutableInt(this.field_147009_r - 10);
        List<GuideBookEntries.GuidebookSearchResult> results = GuideBookEntries.INSTANCE.searchEntries(term, this.progression.getTier(), 24);
        for (GuideBookEntries.GuidebookSearchResult e : results) {
            CodexSearchResult csr;
            if (e.isEntry()) {
                csr = new CodexSearchResult(this.field_147003_i + 35, yCoord.getValue(), e.getEntry().getCategory().getDisplayStack().func_200301_q().getString() + " > " + e.getEntry().getFirstTitle(), button -> {
                    this.clearSearch();
                    this.setCurrentEntry(e.getEntry().getName());
                });
                this.func_230480_a_((Widget)csr);
                this.searchResults.add(csr);
                yCoord.add(csr.func_238483_d_() + 2);
            } else if (e.isRecipe()) {
                TranslationTextComponent ttc = new TranslationTextComponent("gui.mana-and-artifice.codex_search.recipe." + e.getRecipe().getType());
                if (e.getOutputStack().func_77948_v()) {
                    Map enchs = EnchantmentHelper.func_82781_a((ItemStack)e.getOutputStack());
                    for (Map.Entry enchantment : enchs.entrySet()) {
                        ttc.func_230529_a_(((Enchantment)enchantment.getKey()).func_200305_d(((Integer)enchantment.getValue()).intValue()));
                    }
                    csr = new CodexSearchResult(this.field_147003_i + 35, yCoord.getValue(), ttc.getString(), button -> {
                        this.clearSearch();
                        this.displayRecipe(e.getRecipe());
                    });
                } else {
                    csr = new CodexSearchResult(this.field_147003_i + 35, yCoord.getValue(), ttc.func_230529_a_(e.getOutputStack().func_200301_q()).getString(), button -> {
                        this.clearSearch();
                        this.displayRecipe(e.getRecipe());
                    });
                }
                this.func_230480_a_((Widget)csr);
                this.searchResults.add(csr);
                yCoord.add(csr.func_238483_d_() + 2);
            }
            int n = yCoord.intValue();
            this.field_230712_o_.getClass();
            if (n <= this.field_147009_r + 200 - 9) continue;
            break;
        }
    }

    private void decrementPage() {
        this.page -= 2;
        if (this.max_pages > 1) {
            this.nextPage.field_230694_p_ = true;
            this.nextPage.field_230693_o_ = true;
        }
        if (this.page <= 0) {
            this.page = 0;
            this.prevPage.field_230694_p_ = false;
            this.prevPage.field_230693_o_ = false;
        }
    }

    private void incrementPage() {
        this.page += 2;
        if (this.max_pages > 1) {
            this.prevPage.field_230694_p_ = true;
            this.prevPage.field_230693_o_ = true;
        }
        if (this.page >= this.max_pages - 1) {
            this.page = this.max_pages - 1;
            if (this.page % 2 == 1) {
                ++this.page;
            }
            this.nextPage.field_230694_p_ = false;
            this.nextPage.field_230693_o_ = false;
        }
    }

    private void setCurrentTooltip(List<ITextComponent> lines) {
        currentTooltip.clear();
        currentTooltip.addAll(lines);
    }

    public void func_230430_a_(MatrixStack matrixStack, int p_render_1_, int p_render_2_, float p_render_3_) {
        currentTooltip.clear();
        super.func_230430_a_(matrixStack, p_render_1_, p_render_2_, p_render_3_);
        if (!currentTooltip.isEmpty()) {
            this.func_238654_b_(matrixStack, Lists.transform(currentTooltip, ITextComponent::func_241878_f), p_render_1_, p_render_2_);
        }
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.field_230706_i_.func_110434_K().func_110577_a(GuiTextures.GUIDE_BOOK);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_238474_b_(matrixStack, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.currentRecipe != null || this.isSearching) {
            return;
        }
        if (this.currentEntry != null) {
            this.renderCurrentEntry(matrixStack, mouseX, mouseY);
        } else {
            this.renderIndex(matrixStack);
        }
    }

    private void renderCurrentEntry(MatrixStack matrixStack, int mouseX, int mouseY) {
        int x = 13;
        int y = 10;
        List pageSections = this.currentEntry.getSections().stream().filter(s -> s.getPage() == this.page).collect(Collectors.toList());
        for (IEntrySection section : pageSections) {
            section.render(matrixStack, x, y, 110, 158);
            y += section.getHeight(158);
        }
        x = 133;
        y = 10;
        pageSections = this.currentEntry.getSections().stream().filter(s -> s.getPage() == this.page + 1).collect(Collectors.toList());
        for (IEntrySection section : pageSections) {
            section.render(matrixStack, x, y, 110, 158);
            y += section.getHeight(158);
        }
    }

    private void renderIndex(MatrixStack matrixStack) {
        String str = this.currentCategory.getDisplayStack().func_200301_q().getString();
        int padding = (110 - this.field_230706_i_.field_71466_p.func_78256_a(str)) / 2;
        this.field_230712_o_.func_238421_b_(matrixStack, str, (float)(13 + padding), 15.0f, 0x404040);
    }

    private void setCurrentEntry(String id) {
        this.hideCategoryView();
        this.clearRelatedTabs();
        this.currentEntry = GuideBookEntries.INSTANCE.getEntry(id);
        this.progression.setLastCodexEntry(id);
        this.setupEntryRelatedButtons();
        this.calculateMaxPageForEntry();
        this.page = 0;
    }

    private void setupIndexView() {
        this.currentEntry = null;
        this.clearRelatedTabs();
        this.setupCategorySelectionButtons();
        this.setupCategoryItemButtons();
        this.setupCategoryView(this.currentCategory);
        this.progression.setLastCodexEntry("");
    }

    private void setupCategoryView(EntryCategories value) {
        int playerTier = this.progression.getTier();
        this.max_pages = 1;
        this.page = 0;
        this.categoryButtons.forEach(c -> {
            c.field_230694_p_ = c.field_230693_o_ = c.category == value && c.tier <= playerTier;
            if (c.field_230693_o_) {
                this.max_pages = Math.max(this.max_pages, c.page);
            }
        });
        this.prevPage.field_230694_p_ = false;
        this.prevPage.field_230693_o_ = false;
        if (this.max_pages > 1) {
            this.nextPage.field_230694_p_ = true;
            this.nextPage.field_230693_o_ = true;
        } else {
            this.nextPage.field_230694_p_ = false;
            this.nextPage.field_230693_o_ = false;
        }
        this.back.field_230694_p_ = false;
        this.back.field_230693_o_ = false;
        this.currentCategory = value;
    }

    private void hideCategoryView() {
        this.categoryButtons.forEach(c -> {
            c.field_230694_p_ = false;
            c.field_230693_o_ = false;
        });
        this.back.field_230694_p_ = true;
        this.back.field_230693_o_ = true;
    }

    private void setupCategoryItemButtons() {
        if (this.categoryButtons.size() > 0) {
            return;
        }
        for (EntryCategories value : EntryCategories.values()) {
            int x = this.field_147003_i + 13;
            int y = this.field_147009_r + 10 + 20;
            int y_max = this.field_147009_r + 158;
            int render_page = 0;
            int entryCount = 1;
            List entries = GuideBookEntries.INSTANCE.getEntries(value).stream().collect(Collectors.toList());
            Collections.sort(entries, new Comparator<GuidebookEntry>(){

                @Override
                public int compare(GuidebookEntry o1, GuidebookEntry o2) {
                    Integer index2;
                    Integer index1 = o1.getIndex();
                    if (index1 == (index2 = Integer.valueOf(o2.getIndex()))) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    return index1.compareTo(index2);
                }
            });
            for (GuidebookEntry e : entries) {
                if (e.getTier() > this.progression.getTier()) continue;
                String disp = I18n.func_135052_a((String)e.getFirstTitle(), (Object[])new Object[0]);
                int countWidth = this.field_230712_o_.func_78256_a(" " + entryCount);
                List split_lines = this.field_230712_o_.func_238420_b_().func_238365_g_(disp, 110 - countWidth, Style.field_240709_b_);
                disp = ((ITextProperties)split_lines.get(split_lines.size() - 1)).getString();
                char spacer = '.';
                int width = this.field_230712_o_.func_78256_a(disp);
                int padding = 15 - countWidth;
                int spacerWidth = this.field_230712_o_.func_78256_a("" + spacer);
                int nonPaddedWidth = 110 - countWidth - padding;
                int requiredPaddingWidth = nonPaddedWidth - width;
                int numSpacers = 0;
                if (nonPaddedWidth > 0 && requiredPaddingWidth > spacerWidth) {
                    numSpacers = requiredPaddingWidth / spacerWidth;
                }
                if (numSpacers > 0) {
                    char[] spacers = new char[numSpacers];
                    Arrays.fill(spacers, spacer);
                    disp = disp + String.copyValueOf(spacers);
                }
                split_lines.set(split_lines.size() - 1, new StringTextComponent(disp));
                ArrayList<ITextComponent> split_lines_cast = new ArrayList<ITextComponent>();
                for (ITextProperties split : split_lines) {
                    split_lines_cast.add((ITextComponent)new StringTextComponent(split.getString()));
                }
                CategoryItemButton btn = new CategoryItemButton(value, e.getTier(), render_page, entryCount, x, y, split_lines_cast, button -> {
                    this.hideCategoryView();
                    this.setCurrentEntry(e.getName());
                });
                if (y + btn.func_238483_d_() > y_max) {
                    y = this.field_147009_r + 10 + 20;
                    x = ++render_page % 2 == 1 ? this.field_147003_i + 133 : this.field_147003_i + 13;
                    btn.field_230690_l_ = x;
                    btn.field_230691_m_ = y;
                    btn.page = render_page;
                }
                this.func_230480_a_((Widget)btn);
                this.categoryButtons.add(btn);
                y += btn.func_238483_d_();
                ++entryCount;
            }
        }
    }

    private void clearRelatedTabs() {
        for (ImageButton btn : this.relatedTabs) {
            this.field_230710_m_.remove(btn);
            this.field_230705_e_.remove(btn);
        }
    }

    private void calculateMaxPageForEntry() {
        this.max_pages = 1;
        if (this.currentEntry != null) {
            for (IEntrySection section : this.currentEntry.getSections()) {
                if (section.getPage() <= this.max_pages) continue;
                this.max_pages = section.getPage();
            }
        }
        this.prevPage.field_230694_p_ = false;
        this.prevPage.field_230693_o_ = false;
        if (this.max_pages > 1) {
            this.nextPage.field_230694_p_ = true;
            this.nextPage.field_230693_o_ = true;
        } else {
            this.nextPage.field_230694_p_ = false;
            this.nextPage.field_230693_o_ = false;
        }
    }

    private void setupCategorySelectionButtons() {
        int x = this.field_147003_i + this.field_146999_f - 7;
        int y = this.field_147009_r + 8;
        for (EntryCategories value : EntryCategories.values()) {
            ItemStack stack;
            boolean entryShown = false;
            List entries = GuideBookEntries.INSTANCE.getEntries(value).stream().collect(Collectors.toList());
            for (GuidebookEntry e : entries) {
                if (e.getTier() > this.progression.getTier()) continue;
                entryShown = true;
                break;
            }
            if (!entryShown || (stack = value.getDisplayStack()).func_190926_b()) continue;
            ImageItemStackButton btn = new ImageItemStackButton(x, y, 28, 18, 28, 214, 18, GuiTextures.GUIDE_BOOK, 256, 256, button -> this.setupCategoryView(value), stack, this.field_230707_j_, false);
            this.func_230480_a_((Widget)btn);
            this.relatedTabs.add(btn);
            y += 20;
        }
    }

    private void setupEntryRelatedButtons() {
        if (this.currentEntry == null) {
            return;
        }
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        int x = i + this.field_146999_f - 7;
        int y = j + 5;
        int y_step = 20;
        if (this.currentEntry.getRelatedRecipes().size() > 0) {
            y_step = Math.min(20, 170 / this.currentEntry.getRelatedRecipes().size());
        }
        int playerTier = this.progression.getTier();
        for (RelatedRecipe rr : this.currentEntry.getRelatedRecipes()) {
            ImageButton btn;
            if (rr.getTier() > playerTier) continue;
            if (rr.getType().equals("spell_part")) {
                ISpellComponent part = this.lookupSpell(rr.getResourceLocations()[0]);
                if (part == null) continue;
                btn = new ImageSpellPartButton(x, y, 28, 18, 56, 178, 18, GuiTextures.GUIDE_BOOK, 256, 256, button -> this.displayRecipe(rr), part.getGuiIcon(), part.getRegistryName());
                this.func_230480_a_((Widget)btn);
                this.relatedTabs.add(btn);
            } else {
                Optional pattern;
                ItemStack stack = this.lookupResource(rr.getResourceLocations()[0]);
                if (stack.func_190926_b() && (pattern = this.field_230706_i_.field_71441_e.func_199532_z().func_215367_a(rr.getResourceLocations()[0])).isPresent()) {
                    stack = ((IRecipe)pattern.get()).func_77571_b();
                }
                if (!stack.func_190926_b()) {
                    btn = new ImageItemStackButton(x, y, 28, 18, 56, 178, 18, GuiTextures.GUIDE_BOOK, 256, 256, button -> this.displayRecipe(rr), stack, this.field_230707_j_);
                    this.func_230480_a_((Widget)btn);
                    this.relatedTabs.add(btn);
                }
            }
            y += y_step;
        }
    }

    private ItemStack lookupResource(ResourceLocation rLoc) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(rLoc);
        if (item != null && item != Items.field_190931_a) {
            return new ItemStack((IItemProvider)item);
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(rLoc);
        if (block != null && block != Blocks.field_150350_a) {
            return new ItemStack((IItemProvider)block);
        }
        return ItemStack.field_190927_a;
    }

    private ISpellComponent lookupSpell(ResourceLocation rLoc) {
        ISpellComponent output = null;
        output = (ISpellComponent)Registries.Shape.getValue(rLoc);
        if (output != null) {
            return output;
        }
        output = (ISpellComponent)Registries.Component.getValue(rLoc);
        if (output != null) {
            return output;
        }
        output = (ISpellComponent)Registries.Modifier.getValue(rLoc);
        return output;
    }

    public class CodexSearchResult
    extends Button {
        private List<ITextProperties> split_lines;

        public CodexSearchResult(int x, int y, String text, Button.IPressable pressedAction) {
            GuiGuideBook.this.field_230712_o_.getClass();
            super(x, y, 205, 9 * GuiGuideBook.this.field_230712_o_.func_238420_b_().func_238362_b_((ITextProperties)new StringTextComponent(text), 200, Style.field_240709_b_).size(), (ITextComponent)new StringTextComponent(text), pressedAction);
            this.split_lines = GuiGuideBook.this.field_230712_o_.func_238420_b_().func_238362_b_((ITextProperties)new StringTextComponent(text), 200, Style.field_240709_b_);
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer fontrenderer = minecraft.field_71466_p;
            int j = this.getFGColor();
            int renderY = this.field_230691_m_;
            for (ITextProperties props : this.split_lines) {
                fontrenderer.func_238421_b_(matrixStack, props.getString(), (float)this.field_230690_l_, (float)renderY, this.getFGColor());
                minecraft.field_71466_p.getClass();
                renderY += 9;
            }
        }

        public int getFGColor() {
            return this.func_230449_g_() ? 0xB300B3 : 0x444444;
        }
    }

    public class CategoryItemButton
    extends Button {
        public int page;
        public final EntryCategories category;
        public final int tier;
        private final String count;
        private final List<ITextComponent> textLines;

        public CategoryItemButton(EntryCategories category, int tier, int page, int count, int x, int y, List<ITextComponent> text, Button.IPressable onPress) {
            ((GuiGuideBook)GuiGuideBook.this).field_230706_i_.field_71466_p.getClass();
            super(x, y, 110, 9 * text.size() + 5, text.get(0), onPress);
            this.page = page;
            this.category = category;
            this.count = "" + count;
            this.textLines = text;
            this.tier = tier;
        }

        public void setPage(int page) {
            this.page = page;
        }

        public void func_230988_a_(SoundHandler soundHandler) {
            soundHandler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SFX.Gui.PAGE_FLIP, (float)((float)(0.8 + Math.random() * 0.4))));
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (GuiGuideBook.this.page == this.page || GuiGuideBook.this.page == this.page - 1) {
                super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            }
        }

        protected boolean func_230992_c_(double mouseX, double mouseY) {
            return (this.page == GuiGuideBook.this.page || this.page - 1 == GuiGuideBook.this.page) && this.field_230693_o_ && this.field_230694_p_ && mouseX >= (double)this.field_230690_l_ && mouseY >= (double)this.field_230691_m_ && mouseX < (double)(this.field_230690_l_ + this.field_230688_j_) && mouseY < (double)(this.field_230691_m_ + this.field_230689_k_);
        }

        public void func_230431_b_(MatrixStack matrixStack, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer fontrenderer = minecraft.field_71466_p;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
            int j = this.getFGColor();
            int renderY = this.field_230691_m_;
            for (ITextProperties iTextProperties : this.textLines) {
                fontrenderer.func_238421_b_(matrixStack, iTextProperties.getString(), (float)this.field_230690_l_, (float)renderY, j | MathHelper.func_76123_f((float)(this.field_230695_q_ * 255.0f)) << 24);
                minecraft.field_71466_p.getClass();
                renderY += 9;
            }
            minecraft.field_71466_p.getClass();
            fontrenderer.func_238421_b_(matrixStack, this.count, (float)(this.field_230690_l_ + this.field_230688_j_ - fontrenderer.func_78256_a(this.count)), (float)(renderY -= 9), j | MathHelper.func_76123_f((float)(this.field_230695_q_ * 255.0f)) << 24);
        }

        public int getFGColor() {
            if (this.field_230692_n_ && this.field_230693_o_) {
                return 0xB300B3;
            }
            return 0x444444;
        }
    }

    public class PaperImageButton
    extends ImageButton {
        private ITextComponent tooltip;

        public PaperImageButton(int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, ResourceLocation resourceLocationIn, Button.IPressable onPressIn) {
            super(xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, resourceLocationIn, onPressIn);
        }

        public PaperImageButton(int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, ResourceLocation resourceLocationIn, int p_i51136_9_, int p_i51136_10_, Button.IPressable onPressIn, ITextComponent textIn) {
            super(xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, resourceLocationIn, p_i51136_9_, p_i51136_10_, onPressIn, textIn);
        }

        public PaperImageButton(int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, ResourceLocation resourceLocationIn, int p_i51135_9_, int p_i51135_10_, Button.IPressable onPressIn) {
            super(xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, resourceLocationIn, p_i51135_9_, p_i51135_10_, onPressIn);
        }

        public PaperImageButton setTooltip(ITextComponent tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            super.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
            if (this.field_230693_o_ && this.field_230694_p_ && this.func_230449_g_() && this.tooltip != null) {
                currentTooltip.add(this.tooltip);
            }
        }

        public void func_230988_a_(SoundHandler soundHandler) {
            soundHandler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SFX.Gui.PAGE_FLIP, (float)((float)(0.8 + Math.random() * 0.4))));
        }
    }

    public class ImageSpellPartButton
    extends ImageButton {
        final ResourceLocation spellTexture;
        final String translateKey;

        public ImageSpellPartButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int hoverOffset, ResourceLocation textureFile, int texWidth, int texHeight, Button.IPressable clickHandler, ResourceLocation spellTexture, ResourceLocation spellName) {
            super(x, y, width, height, xTexStart, yTexStart, hoverOffset, textureFile, texWidth, texHeight, clickHandler, (ITextComponent)new StringTextComponent(""));
            this.spellTexture = spellTexture;
            this.translateKey = spellName.toString();
        }

        public void func_230431_b_(MatrixStack matrixStack, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
            super.func_230431_b_(matrixStack, p_renderButton_1_, p_renderButton_2_, p_renderButton_3_);
            GuiGuideBook.this.field_230706_i_.func_110434_K().func_110577_a(this.spellTexture);
            RenderSystem.disableDepthTest();
            ImageSpellPartButton.func_238463_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + 3), (int)(this.field_230691_m_ + 1), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            RenderSystem.enableDepthTest();
            if (this.field_230693_o_ && this.field_230692_n_) {
                ArrayList<ITextComponent> tt = new ArrayList<ITextComponent>();
                tt.add((ITextComponent)new TranslationTextComponent(this.translateKey));
                currentTooltip = tt;
            }
        }

        public void func_230988_a_(SoundHandler soundHandler) {
            soundHandler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SFX.Gui.PAGE_FLIP, (float)((float)(0.8 + Math.random() * 0.4))));
        }
    }

    public class ImageItemStackButton
    extends ImageButton {
        final ItemStack iconStack;
        final ItemRenderer itemRenderer;
        final boolean includeTooltip;

        public ImageItemStackButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int hoverOffset, ResourceLocation textureFile, int texWidth, int texHeight, Button.IPressable clickHandler, ItemStack displayStack, ItemRenderer itemRenderer) {
            this(x, y, width, height, xTexStart, yTexStart, hoverOffset, textureFile, texWidth, texHeight, clickHandler, displayStack, itemRenderer, true);
        }

        public ImageItemStackButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int hoverOffset, ResourceLocation textureFile, int texWidth, int texHeight, Button.IPressable clickHandler, ItemStack displayStack, ItemRenderer itemRenderer, boolean displayFullTooltip) {
            super(x, y, width, height, xTexStart, yTexStart, hoverOffset, textureFile, texWidth, texHeight, clickHandler, displayStack.func_200301_q());
            this.iconStack = displayStack;
            this.itemRenderer = itemRenderer;
            this.includeTooltip = displayFullTooltip;
        }

        public void func_230431_b_(MatrixStack matrixStack, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
            super.func_230431_b_(matrixStack, p_renderButton_1_, p_renderButton_2_, p_renderButton_3_);
            this.itemRenderer.func_180450_b(this.iconStack, this.field_230690_l_ + 3, this.field_230691_m_ + 1);
            if (this.field_230693_o_ && this.field_230692_n_) {
                List lines;
                if (this.includeTooltip) {
                    lines = this.iconStack.func_82840_a((PlayerEntity)((GuiGuideBook)GuiGuideBook.this).field_230706_i_.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
                } else {
                    lines = new ArrayList<ITextComponent>();
                    lines.add(this.iconStack.func_200301_q());
                }
                ArrayList<ITextComponent> tt = new ArrayList<ITextComponent>();
                for (ITextComponent comp : lines) {
                    if (!this.includeTooltip) {
                        String unformatted = TextFormatting.func_110646_a((String)comp.getString());
                        StringTextComponent stc = new StringTextComponent(unformatted);
                        stc.func_240699_a_(TextFormatting.ITALIC);
                        tt.add((ITextComponent)stc);
                        continue;
                    }
                    tt.add(comp);
                }
                currentTooltip = tt;
            }
        }

        public void func_230988_a_(SoundHandler soundHandler) {
            soundHandler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SFX.Gui.PAGE_FLIP, (float)((float)(0.8 + Math.random() * 0.4))));
        }
    }
}

