/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui;

import com.ma.Registries;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.capabilities.IPlayerRoteSpells;
import com.ma.api.sound.SFX;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiable;
import com.ma.api.spells.base.ISpellComponent;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.parts.Modifier;
import com.ma.api.spells.parts.Shape;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.capabilities.playerdata.rote.PlayerRoteSpellsProvider;
import com.ma.gui.GuiTextures;
import com.ma.gui.containers.ContainerRoteBook;
import com.ma.network.ClientMessageDispatcher;
import com.ma.recipes.ItemAndPatternRecipe;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Point;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GuiRoteBook
extends ContainerScreen<ContainerRoteBook> {
    private static final int MAX_COMPONENTS = 5;
    ImageButton[] pieceWidgets;
    ImageButton activeShapeButton;
    ImageButton[] activeComponentButtons;
    ArrayList<ImageButton> shapeAttributeButtons;
    HashMap<Integer, ArrayList<ImageButton>> componentAttributeButtons;
    ArrayList<ImageButton> inactiveCategoryButtons;
    ArrayList<ImageButton> activeCategoryButtons;
    private SpellPartList list;
    final float textScaleFactor = 0.5f;
    static final int textColor = ColorHelper.PackedColor.func_233006_a_((int)255, (int)49, (int)49, (int)49);
    static final int textColorLight = ColorHelper.PackedColor.func_233006_a_((int)255, (int)200, (int)200, (int)200);
    final int colWidth = 40;
    final int rowHeight = 10;
    final int texSize = 32;
    ITextComponent currentTooltip = null;
    IPlayerRoteSpells playerRote = null;
    IPlayerProgression playerProgression = null;

    public GuiRoteBook(ContainerRoteBook screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.field_146999_f = 256;
        this.field_147000_g = 256;
        this.activeComponentButtons = new ImageButton[5];
        this.inactiveCategoryButtons = new ArrayList();
        this.activeCategoryButtons = new ArrayList();
    }

    public boolean func_231043_a_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        return this.list.func_231043_a_(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.playerRote = (IPlayerRoteSpells)this.field_230706_i_.field_71439_g.getCapability(PlayerRoteSpellsProvider.ROTE).orElse(null);
        this.playerProgression = (IPlayerProgression)this.field_230706_i_.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        this.list = new SpellPartList();
        this.field_230705_e_.add(this.list);
        this.shapeAttributeButtons = new ArrayList();
        this.componentAttributeButtons = new HashMap();
        for (int i = 0; i < 5; ++i) {
            this.componentAttributeButtons.put(i, new ArrayList());
        }
        this.mapUIToCurrentSpell();
        int x = this.field_147003_i + 248;
        int y = this.field_147009_r + 8;
        for (int i = 0; i < ((ContainerRoteBook)this.field_147002_h).getSize(); ++i) {
            int idx = i;
            this.inactiveCategoryButtons.add((ImageButton)this.func_230480_a_((Widget)new IndexButton(x, y, 28, 18, 0, 178, 18, GuiTextures.BOOK_OF_ROTE, 256, 256, btn -> {
                this.setActiveIndex(idx);
                ((ContainerRoteBook)this.field_147002_h).changeIndex(idx);
                this.mapUIToCurrentSpell();
            }, i + 1, false)));
            this.activeCategoryButtons.add((ImageButton)this.func_230480_a_((Widget)new IndexButton(x, y, 28, 18, 0, 214, 18, GuiTextures.BOOK_OF_ROTE, 256, 256, btn -> {}, i + 1, true)));
            y += 20;
        }
        this.setActiveIndex(((ContainerRoteBook)this.field_147002_h).getActiveIndex());
    }

    private void setActiveIndex(int index) {
        if (index < 0 || index >= this.activeCategoryButtons.size()) {
            return;
        }
        this.activeCategoryButtons.forEach(b -> {
            b.field_230693_o_ = false;
            b.field_230694_p_ = false;
        });
        this.inactiveCategoryButtons.forEach(b -> {
            b.field_230693_o_ = true;
            b.field_230694_p_ = true;
        });
        this.activeCategoryButtons.get((int)index).field_230693_o_ = true;
        this.activeCategoryButtons.get((int)index).field_230694_p_ = true;
        this.inactiveCategoryButtons.get((int)index).field_230693_o_ = false;
        this.inactiveCategoryButtons.get((int)index).field_230694_p_ = false;
    }

    private void mapUIToCurrentSpell() {
        int i;
        this.setupShapeAttributeButtons(null);
        if (this.activeShapeButton != null) {
            this.field_230710_m_.remove(this.activeShapeButton);
            this.field_230705_e_.remove(this.activeShapeButton);
        }
        for (int index : this.componentAttributeButtons.keySet()) {
            this.clearAttributeButtons(this.componentAttributeButtons.get(index));
        }
        for (i = 0; i < this.activeComponentButtons.length; ++i) {
            this.field_230710_m_.remove(this.activeComponentButtons[i]);
            this.field_230705_e_.remove(this.activeComponentButtons[i]);
            this.activeComponentButtons[i] = null;
        }
        if (((ContainerRoteBook)this.field_147002_h).getShape() != null) {
            this.setupShapeWidgetsFor(((ContainerRoteBook)this.field_147002_h).getShape().getPart());
        }
        for (i = 0; i < 5; ++i) {
            if (((ContainerRoteBook)this.field_147002_h).getComponent(i) == null) continue;
            this.setupComponentWidgetsFor(((ContainerRoteBook)this.field_147002_h).getComponent(i).getPart(), i);
        }
    }

    private void setupShapeAttributeButtons(Shape shape) {
        this.clearAttributeButtons(this.shapeAttributeButtons);
        if (shape == null) {
            return;
        }
        this.setupAttributeButtons(58, 35, this.shapeAttributeButtons, shape);
    }

    private void setupAttributeButtons(int xStart, int yStart, ArrayList<ImageButton> addTo, IModifiable modifiable) {
        int count = 0;
        for (AttributeValuePair attribute : modifiable.getModifiableAttributes()) {
            boolean attributeModifiable = false;
            for (Modifier m : Registries.Modifier.getValues()) {
                if (!m.modifiesType(attribute.getAttribute()) || !this.playerRote.isRote(m) && !this.field_230706_i_.field_71439_g.func_184812_l_()) continue;
                attributeModifiable = true;
                break;
            }
            int row = (int)Math.floor(count / 2);
            int col = count % 2;
            int xOffset = xStart + 40 * col;
            int yOffset = yStart + 10 * row;
            if (attributeModifiable) {
                ImageButton upButton = (ImageButton)this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + xOffset, this.field_147009_r + yOffset, 5, 3, 45, 0, 3, GuiTextures.WIDGETS, 128, 128, button -> ((ContainerRoteBook)this.field_147002_h).increaseAttribute(modifiable, attribute.getAttribute(), (World)this.field_230706_i_.field_71441_e, Screen.func_231173_s_())));
                ImageButton downButton = (ImageButton)this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + xOffset + 22, this.field_147009_r + yOffset, 5, 3, 50, 0, 3, GuiTextures.WIDGETS, 128, 128, button -> ((ContainerRoteBook)this.field_147002_h).decreaseAttribute(modifiable, attribute.getAttribute(), (World)this.field_230706_i_.field_71441_e, Screen.func_231173_s_())));
                addTo.add(upButton);
                addTo.add(downButton);
            }
            Point texCoord = GuiTextures.Attribute_Icon_Mappings.get((Object)attribute.getAttribute());
            int blitSize = 8;
            float scaleFactor = (float)blitSize / 52.0f;
            ImageButton iconButton = (ImageButton)this.func_230480_a_((Widget)new AttributeButton(this.field_147003_i + xOffset - 8, this.field_147009_r + yOffset - 2, blitSize, blitSize, (int)((float)texCoord.x * scaleFactor), (int)((float)texCoord.y * scaleFactor), 0, GuiTextures.ATTRIBUTE_ICONS, (int)(208.0f * scaleFactor), (int)(208.0f * scaleFactor), button -> {}, attribute.getAttribute().getLocaleKey()));
            addTo.add(iconButton);
            ++count;
        }
    }

    private void clearAttributeButtons(ArrayList<ImageButton> attributeButtons) {
        for (ImageButton button : attributeButtons) {
            this.field_230710_m_.remove(button);
            this.field_230705_e_.remove(button);
        }
        attributeButtons.clear();
    }

    private void setupShapeWidgetsFor(Shape shape) {
        int texSize = 32;
        if (shape != null) {
            if (this.activeShapeButton != null) {
                this.field_230710_m_.remove(this.activeShapeButton);
                this.field_230705_e_.remove(this.activeShapeButton);
            }
            this.activeShapeButton = (ImageButton)this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + 15, this.field_147009_r + 33, texSize, texSize, 0, 0, 0, shape.getGuiIcon(), texSize, texSize, button -> {
                ((ContainerRoteBook)this.field_147002_h).setShape(null);
                this.mapUIToCurrentSpell();
            }));
        }
        this.setupShapeAttributeButtons(shape);
    }

    private void OnShapeClicked(Shape shape) {
        ((ContainerRoteBook)this.field_147002_h).setShape(shape);
        this.mapUIToCurrentSpell();
    }

    private void setupComponentWidgetsFor(Component component, int index) {
        int texSize = 32;
        if (component != null) {
            if (this.activeComponentButtons[index] != null) {
                this.field_230710_m_.remove(this.activeComponentButtons[index]);
                this.field_230705_e_.remove(this.activeComponentButtons[index]);
            }
            AbstractMap.SimpleEntry<Integer, Integer> coords = this.getComponentRenderCoordinates(index);
            this.activeComponentButtons[index] = (ImageButton)this.func_230480_a_((Widget)new ImageButton(coords.getKey().intValue(), coords.getValue().intValue(), 32, 32, 0, 0, 0, component.getGuiIcon(), 32, 32, button -> {
                ((ContainerRoteBook)this.field_147002_h).removeComponent(index);
                this.mapUIToCurrentSpell();
            }));
        }
        this.setupComponentAttributeButtons(component, index);
    }

    private void setupComponentAttributeButtons(Component component, int index) {
        this.clearAttributeButtons(this.componentAttributeButtons.get(index));
        if (component == null) {
            return;
        }
        AbstractMap.SimpleEntry<Integer, Integer> coords = this.getComponentRenderCoordinates(index, -this.field_147003_i + 43, -this.field_147009_r + 2);
        this.setupAttributeButtons(coords.getKey(), coords.getValue(), this.componentAttributeButtons.get(index), component);
    }

    private void OnComponentClicked(Component component) {
        for (int i = 0; i < 5; ++i) {
            if (((ContainerRoteBook)this.field_147002_h).getComponent(i) != null) continue;
            ((ContainerRoteBook)this.field_147002_h).addComponent(component);
            this.mapUIToCurrentSpell();
            return;
        }
    }

    private AbstractMap.SimpleEntry<Integer, Integer> getComponentRenderCoordinates(int index) {
        return this.getComponentRenderCoordinates(index, 0, 0);
    }

    private AbstractMap.SimpleEntry<Integer, Integer> getComponentRenderCoordinates(int index, int offsetX, int offsetY) {
        int x = this.field_147003_i + 15;
        int y = this.field_147009_r + 78;
        if (index == 1 || index == 4) {
            y += 45;
        }
        if (index == 2) {
            y -= 45;
        }
        if (index > 1) {
            x += 120;
        }
        return new AbstractMap.SimpleEntry<Integer, Integer>(x + offsetX, y + offsetY);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        ((ContainerRoteBook)this.field_147002_h).copySpellChangesToInventory();
        ClientMessageDispatcher.sendRoteSpellsUpdate((ContainerRoteBook)this.field_147002_h);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.currentTooltip = null;
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.currentTooltip != null) {
            this.func_238652_a_(matrixStack, this.currentTooltip, mouseX, mouseY);
        }
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        int xPos = 65;
        int yPos = 35;
        int count = 0;
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
        if (((ContainerRoteBook)this.field_147002_h).getShape() != null) {
            for (Attribute attribute : ((ContainerRoteBook)this.field_147002_h).getShape().getContainedAttributes()) {
                int row = (int)Math.floor(count / 2);
                int col = count % 2;
                this.drawAttributeValue(matrixStack, xPos + col * 40, yPos + row * 10, ((ContainerRoteBook)this.field_147002_h).getShape().getValue(attribute));
                ++count;
            }
        }
        for (int i = 0; i < 5; ++i) {
            AbstractMap.SimpleEntry<Integer, Integer> coords = this.getComponentRenderCoordinates(i, -this.field_147003_i + 52, -this.field_147009_r + 3);
            xPos = coords.getKey();
            yPos = coords.getValue();
            count = 0;
            if (((ContainerRoteBook)this.field_147002_h).getComponent(i) == null) continue;
            for (Attribute attribute : ((ContainerRoteBook)this.field_147002_h).getComponent(i).getContainedAttributes()) {
                int row = (int)Math.floor(count / 2);
                int col = count % 2;
                this.drawAttributeValue(matrixStack, xPos + col * 40, yPos + row * 10, ((ContainerRoteBook)this.field_147002_h).getComponent(i).getValue(attribute));
                ++count;
            }
        }
        String header = I18n.func_135052_a((String)"gui.mana-and-artifice.mana_cost", (Object[])new Object[0]) + ":";
        String manaCost = String.format("%.1f", Float.valueOf(((ContainerRoteBook)this.field_147002_h).getManaCost((PlayerEntity)this.field_230706_i_.field_71439_g)));
        String complexityHeader = I18n.func_135052_a((String)"gui.mana-and-artifice.complexity", (Object[])new Object[0]) + ":";
        String complexity = String.format("%.1f / %d", Float.valueOf(((ContainerRoteBook)this.field_147002_h).getComplexity((PlayerEntity)this.field_230706_i_.field_71439_g)), this.playerProgression.getTierMaxComplexity());
        float manaCostWidth = (float)this.field_230712_o_.func_78256_a(manaCost) * 0.5f;
        float headerWidth = (float)this.field_230712_o_.func_78256_a(header) * 0.5f;
        float complexityHeaderWidth = (float)this.field_230712_o_.func_78256_a(complexityHeader) * 0.5f;
        float complexityWidth = (float)this.field_230712_o_.func_78256_a(complexity) * 0.5f;
        float padding = 2.0f;
        float summaryXPos = 240.0f - complexityHeaderWidth - complexityWidth - padding;
        float summaryYPos = 12.0f;
        this.field_230712_o_.func_238421_b_(matrixStack, complexityHeader, summaryXPos / 0.5f, summaryYPos / 0.5f, textColor);
        summaryXPos += complexityHeaderWidth + padding;
        if (((ContainerRoteBook)this.field_147002_h).getComplexity((PlayerEntity)this.field_230706_i_.field_71439_g) <= (float)this.playerProgression.getTierMaxComplexity()) {
            this.field_230712_o_.func_238421_b_(matrixStack, complexity, summaryXPos / 0.5f, summaryYPos / 0.5f, textColor);
        } else {
            this.field_230712_o_.func_238421_b_(matrixStack, complexity, summaryXPos / 0.5f, summaryYPos / 0.5f, TextFormatting.RED.func_211163_e().intValue());
        }
        summaryXPos = 240.0f - headerWidth - manaCostWidth - padding;
        this.field_230712_o_.getClass();
        summaryYPos = 12.0f + 9.0f * 0.5f;
        this.field_230712_o_.func_238421_b_(matrixStack, header, summaryXPos / 0.5f, summaryYPos / 0.5f, textColor);
        this.field_230712_o_.func_238421_b_(matrixStack, manaCost, (summaryXPos += headerWidth + padding) / 0.5f, summaryYPos / 0.5f, textColor);
        RenderSystem.popMatrix();
        String uiPrompt = new TranslationTextComponent("gui.mana-and-artifice.known_rote_spells").getString();
        this.field_230712_o_.func_238421_b_(matrixStack, uiPrompt, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_78256_a(uiPrompt) / 2), 242.0f, textColorLight);
        if (this.currentTooltip != null) {
            this.func_238652_a_(matrixStack, this.currentTooltip, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    private void drawAttributeValue(MatrixStack matrixStack, int x, int y, float value) {
        String valueString = String.format("%.1f", Float.valueOf(value));
        this.field_230712_o_.func_238421_b_(matrixStack, valueString, (float)x / 0.5f, (float)y / 0.5f, textColor);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GuiTextures.BOOK_OF_ROTE);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_238474_b_(matrixStack, i, j, 0, 0, this.field_146999_f, 178);
        this.func_238474_b_(matrixStack, i + 54, j + 178, 54, 178, 148, 78);
        this.list.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean func_231045_a_(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (this.list._scrolling) {
            return this.list.func_231045_a_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
        }
        return super.func_231045_a_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    public class IndexButton
    extends ImageButton {
        String indexString;
        boolean isActive;

        public IndexButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int hoverOffset, ResourceLocation textureFile, int texWidth, int texHeight, Button.IPressable clickHandler, int index, boolean active) {
            super(x, y, width, height, xTexStart, yTexStart, hoverOffset, textureFile, texWidth, texHeight, clickHandler, (ITextComponent)new StringTextComponent(""));
            this.indexString = "" + index;
            this.isActive = active;
        }

        public void func_230431_b_(MatrixStack matrixStack, int mousex, int mousey, float partialTick) {
            super.func_230431_b_(matrixStack, mousex, mousey, partialTick);
            if (this.field_230693_o_ && this.field_230694_p_) {
                GuiRoteBook.this.field_230712_o_.func_238421_b_(matrixStack, this.indexString, (float)(this.field_230690_l_ + 7), (float)(this.field_230691_m_ + 5), this.isActive ? textColor : textColorLight);
            }
        }

        public void func_230988_a_(SoundHandler soundHandler) {
            soundHandler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SFX.Gui.PAGE_FLIP, (float)((float)(0.8 + Math.random() * 0.4))));
        }
    }

    class AttributeButton
    extends ImageButton {
        private ITextComponent tooltip;

        public AttributeButton(int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, ResourceLocation resourceLocationIn, int p_i51135_9_, int p_i51135_10_, Button.IPressable onPressIn, String tooltip) {
            super(xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, resourceLocationIn, p_i51135_9_, p_i51135_10_, onPressIn);
            this.tooltip = new TranslationTextComponent(tooltip);
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            super.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
            if (this.func_230449_g_()) {
                GuiRoteBook.this.currentTooltip = this.tooltip;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class SpellPartList
    extends ExtendedList<SpellPartEntry> {
        private boolean _scrolling;

        public SpellPartList() {
            super(GuiRoteBook.this.field_230706_i_, 132, 58, GuiRoteBook.this.field_147009_r + 178, GuiRoteBook.this.field_147009_r + 236, 24);
            this._scrolling = false;
            this.func_230943_a_(false);
            this.func_230944_a_(false, 24);
            this.field_230675_l_ = GuiRoteBook.this.field_147003_i + 60;
            this.field_230674_k_ = this.field_230675_l_ + 132;
            int tier = ((IPlayerProgression)this.field_230668_b_.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null)).getTier();
            this.addIconsForAll(Registries.Shape.getValues().stream().filter(s -> {
                if (!((GuiRoteBook)GuiRoteBook.this).field_230706_i_.field_71439_g.func_184812_l_() && !GuiRoteBook.this.playerRote.isRote((ISpellComponent)s)) {
                    return false;
                }
                boolean valid = s.isCraftable();
                Optional<IRecipe> pattern = this.field_230668_b_.field_71441_e.func_199532_z().func_199510_b().stream().filter(r -> r.func_199560_c().equals((Object)s.getRegistryName())).findFirst();
                if (pattern.isPresent() && pattern.get() instanceof ItemAndPatternRecipe) {
                    valid &= ((ItemAndPatternRecipe)pattern.get()).getTier() <= tier;
                }
                return valid;
            }).collect(Collectors.toList()), s -> GuiRoteBook.this.OnShapeClicked((Shape)s));
            this.addIconsForAll(Registries.Component.getValues().stream().filter(s -> {
                if (!((GuiRoteBook)GuiRoteBook.this).field_230706_i_.field_71439_g.func_184812_l_() && !GuiRoteBook.this.playerRote.isRote((ISpellComponent)s)) {
                    return false;
                }
                boolean valid = s.isCraftable();
                Optional<IRecipe> pattern = this.field_230668_b_.field_71441_e.func_199532_z().func_199510_b().stream().filter(r -> r.func_199560_c().equals((Object)s.getRegistryName())).findFirst();
                if (pattern.isPresent() && pattern.get() instanceof ItemAndPatternRecipe) {
                    valid &= ((ItemAndPatternRecipe)pattern.get()).getTier() <= tier;
                }
                return valid;
            }).collect(Collectors.toList()), s -> GuiRoteBook.this.OnComponentClicked((Component)s));
        }

        private <T extends ISpellComponent> void addIconsForAll(Collection<T> parts, Consumer<ISpellComponent> clickHandler) {
            ArrayList<ISpellComponent> segment = new ArrayList<ISpellComponent>();
            for (ISpellComponent part : parts) {
                segment.add(part);
                if (segment.size() != 6) continue;
                this.func_230513_b_((AbstractList.AbstractListEntry)new SpellPartEntry(segment, clickHandler));
                segment.clear();
            }
            if (segment.size() > 0) {
                this.func_230513_b_((AbstractList.AbstractListEntry)new SpellPartEntry(segment, clickHandler));
            }
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            int scrollBarStartX = this.func_230952_d_();
            int scrollBarEndX = scrollBarStartX + 6;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int xPos = this.func_230968_n_();
            int yPos = this.field_230672_i_ - (int)this.func_230966_l_();
            this.func_238478_a_(matrixStack, xPos, yPos, mouseX, mouseY, partialTicks);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.disableAlphaTest();
            RenderSystem.shadeModel((int)7425);
            RenderSystem.disableTexture();
            if (this.func_230955_e_() > 0) {
                int scrollBarHeight = (int)((float)((this.field_230673_j_ - this.field_230672_i_) * (this.field_230673_j_ - this.field_230672_i_)) / (float)this.func_230945_b_());
                scrollBarHeight = MathHelper.func_76125_a((int)scrollBarHeight, (int)32, (int)(this.field_230673_j_ - this.field_230672_i_ - 8));
                int top = (int)this.func_230966_l_() * (this.field_230673_j_ - this.field_230672_i_ - scrollBarHeight) / this.func_230955_e_() + this.field_230672_i_;
                if (top < this.field_230672_i_) {
                    top = this.field_230672_i_;
                }
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                bufferbuilder.func_225582_a_((double)scrollBarStartX, (double)this.field_230673_j_, 0.0).func_225586_a_(0, 0, 0, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
                bufferbuilder.func_225582_a_((double)scrollBarEndX, (double)this.field_230673_j_, 0.0).func_225586_a_(0, 0, 0, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
                bufferbuilder.func_225582_a_((double)scrollBarEndX, (double)this.field_230672_i_, 0.0).func_225586_a_(0, 0, 0, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_225582_a_((double)scrollBarStartX, (double)this.field_230672_i_, 0.0).func_225586_a_(0, 0, 0, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                bufferbuilder.func_225582_a_((double)scrollBarStartX, (double)(top + scrollBarHeight), 0.0).func_225586_a_(128, 128, 128, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
                bufferbuilder.func_225582_a_((double)scrollBarEndX, (double)(top + scrollBarHeight), 0.0).func_225586_a_(128, 128, 128, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
                bufferbuilder.func_225582_a_((double)scrollBarEndX, (double)top, 0.0).func_225586_a_(128, 128, 128, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_225582_a_((double)scrollBarStartX, (double)top, 0.0).func_225586_a_(128, 128, 128, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                bufferbuilder.func_225582_a_((double)scrollBarStartX, (double)(top + scrollBarHeight - 1), 0.0).func_225586_a_(192, 192, 192, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
                bufferbuilder.func_225582_a_((double)(scrollBarEndX - 1), (double)(top + scrollBarHeight - 1), 0.0).func_225586_a_(192, 192, 192, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
                bufferbuilder.func_225582_a_((double)(scrollBarEndX - 1), (double)top, 0.0).func_225586_a_(192, 192, 192, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_225582_a_((double)scrollBarStartX, (double)top, 0.0).func_225586_a_(192, 192, 192, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
                tessellator.func_78381_a();
            }
            RenderSystem.enableTexture();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.enableAlphaTest();
            RenderSystem.disableBlend();
            this.field_230668_b_.func_110434_K().func_110577_a(GuiTextures.BOOK_OF_ROTE);
            int i = GuiRoteBook.this.field_147003_i;
            int j = GuiRoteBook.this.field_147009_r;
            this.func_238474_b_(matrixStack, i, j, 0, 0, GuiRoteBook.this.field_146999_f, 178);
            this.func_238474_b_(matrixStack, i + 54, j + 236, 54, 236, 148, 20);
        }

        @Nullable
        protected final SpellPartEntry getEntryAtPos(double mouseX, double mouseY) {
            int lowerXBound = this.func_230968_n_();
            int upperXBound = lowerXBound + this.func_230949_c_();
            int adjustedY = MathHelper.func_76128_c((double)(mouseY - (double)this.field_230672_i_)) + (int)this.func_230966_l_();
            int index = adjustedY / this.field_230669_c_;
            if (index >= 0 && adjustedY >= 0 && index < this.func_230965_k_() && mouseX < (double)this.func_230952_d_() && mouseX >= (double)lowerXBound && mouseX <= (double)upperXBound) {
                return (SpellPartEntry)((Object)this.func_231039_at__().get(index));
            }
            return null;
        }

        protected int func_230952_d_() {
            return this.func_230968_n_() + this.func_230949_c_();
        }

        protected int func_230962_i_(int p_getRowTop_1_) {
            return this.field_230672_i_ - (int)this.func_230966_l_() + p_getRowTop_1_ * this.field_230669_c_;
        }

        public int func_230949_c_() {
            return this.field_230670_d_;
        }

        protected void func_230947_b_(double p_updateScrollingState_1_, double p_updateScrollingState_3_, int p_updateScrollingState_5_) {
            super.func_230947_b_(p_updateScrollingState_1_, p_updateScrollingState_3_, p_updateScrollingState_5_);
            this._scrolling = p_updateScrollingState_5_ == 0 && p_updateScrollingState_1_ >= (double)this.func_230952_d_() && p_updateScrollingState_1_ < (double)(this.func_230952_d_() + 6);
        }

        public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            this.func_230947_b_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
            if (!this.func_231047_b_(p_mouseClicked_1_, p_mouseClicked_3_)) {
                return false;
            }
            SpellPartEntry e = this.getEntryAtPos(p_mouseClicked_1_, p_mouseClicked_3_);
            if (e != null) {
                if (e.func_231044_a_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) {
                    e.func_231049_c__(true);
                    return true;
                }
            } else if (p_mouseClicked_5_ == 0) {
                this.func_231037_b__(true);
                return true;
            }
            return this._scrolling;
        }

        public int func_230955_e_() {
            return Math.max(0, this.func_230945_b_() - (this.field_230673_j_ - this.field_230672_i_ - 4));
        }

        public void setSelected(@Nullable SpellPartEntry selected) {
            super.func_241215_a_((AbstractList.AbstractListEntry)selected);
        }

        @OnlyIn(value=Dist.CLIENT)
        public class SpellPartEntry
        extends ExtendedList.AbstractListEntry<SpellPartEntry> {
            private Collection<ISpellComponent> parts;
            private int spacing = 20;
            private ISpellComponent _hoveredComponent;
            private Consumer<ISpellComponent> _clickHandler;

            public SpellPartEntry(Collection<ISpellComponent> parts, Consumer<ISpellComponent> clickHandler) {
                this.parts = new ArrayList<ISpellComponent>(parts);
                this._hoveredComponent = null;
                this._clickHandler = clickHandler;
            }

            public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float p_render_9_) {
                int i = 0;
                for (ISpellComponent part : this.parts) {
                    if (part == null) continue;
                    int x = 5 + left + i++ * this.spacing;
                    int y = top + 4;
                    this.renderIcon(matrixStack, x, y, part.getGuiIcon());
                    if (!isHovered || mouseX < x || mouseX > x + this.spacing) continue;
                    GuiRoteBook.this.currentTooltip = new TranslationTextComponent(part.getRegistryName().toString());
                    this._hoveredComponent = part;
                }
            }

            public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
                SpellPartList.this.setSelected(this);
                if (this._clickHandler != null && this._hoveredComponent != null) {
                    this._clickHandler.accept(this._hoveredComponent);
                }
                return true;
            }

            private void renderIcon(MatrixStack matrixStack, int x, int y, ResourceLocation item) {
                SpellPartList.this.field_230668_b_.func_110434_K().func_110577_a(item);
                int size = 18;
                AbstractGui.func_238464_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)GuiRoteBook.this.func_230927_p_(), (float)0.0f, (float)0.0f, (int)size, (int)size, (int)size, (int)size);
            }
        }
    }
}

