/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui;

import com.ma.ManaAndArtifice;
import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.items.ChargeableItem;
import com.ma.api.items.IShowHud;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.config.MAClientConfig;
import com.ma.gui.GuiTextures;
import com.ma.guide.recipe.RecipeRendererBase;
import com.ma.items.ItemInit;
import com.ma.items.artifice.ItemSpectralElytra;
import com.ma.spells.crafting.SpellRecipe;
import com.ma.tools.math.MathUtilities;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.lwjgl.opengl.GL11;
import top.theillusivec4.curios.api.CuriosApi;

public class HUDOverlayRenderer
extends AbstractGui {
    private Minecraft mc;
    private RecipeRendererBase pinnedRecipe;
    private int cantripTimer = 0;
    private int cantripTimerMax = 1;
    private int cantripChevrons = 0;
    private boolean showTimerBar = true;
    private String castingCantrip = null;
    private float cantripAlpha = 0.0f;
    public static HUDOverlayRenderer instance;
    private static final int AFFINITIES_TO_DRAW = 2;
    HashMap<Affinity, ItemStack> affinityIcons = new HashMap<Affinity, ItemStack>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Affinity.ARCANE, new ItemStack((IItemProvider)ItemInit.ENCHANTMENT_FOCUS_ARCANE.get()));
            this.put(Affinity.WIND, new ItemStack((IItemProvider)ItemInit.ENCHANTMENT_FOCUS_AIR.get()));
            this.put(Affinity.EARTH, new ItemStack((IItemProvider)ItemInit.ENCHANTMENT_FOCUS_EARTH.get()));
            this.put(Affinity.WATER, new ItemStack((IItemProvider)ItemInit.ENCHANTMENT_FOCUS_WATER.get()));
            this.put(Affinity.FIRE, new ItemStack((IItemProvider)ItemInit.ENCHANTMENT_FOCUS_FIRE.get()));
            this.put(Affinity.ENDER, new ItemStack((IItemProvider)ItemInit.ENCHANTMENT_FOCUS_ENDER.get()));
            this.put(Affinity.UNKNOWN, ItemStack.field_190927_a);
            this.put(Affinity.HELLFIRE, ItemStack.field_190927_a);
            this.put(Affinity.ICE, ItemStack.field_190927_a);
            this.put(Affinity.LIGHTNING, ItemStack.field_190927_a);
        }
    };
    ItemRenderer ir;

    public HUDOverlayRenderer() {
        this.mc = Minecraft.func_71410_x();
        this.ir = this.mc.func_175599_af();
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.LOWEST)
    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        ClientPlayerEntity entityPlayerSP = HUDOverlayRenderer.instance.mc.field_71439_g;
        if (entityPlayerSP == null) {
            return;
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            if (MAClientConfig.HUD_MODE == MAClientConfig.HudMode.AlwaysShow || HUDOverlayRenderer.shouldConditionalShow(entityPlayerSP)) {
                instance.renderHUD(event.getMatrixStack(), event.getWindow().func_198107_o(), event.getWindow().func_198087_p(), event.getPartialTicks());
            }
            instance.renderPinnedRecipe(event.getMatrixStack(), event.getWindow().func_198107_o(), event.getWindow().func_198087_p());
            instance.renderCantripTimer(event.getMatrixStack(), event.getWindow().func_198107_o(), event.getWindow().func_198087_p(), event.getPartialTicks());
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (HUDOverlayRenderer.instance.cantripTimer > 0) {
            --HUDOverlayRenderer.instance.cantripTimer;
            if (HUDOverlayRenderer.instance.cantripTimer <= 10) {
                HUDOverlayRenderer.instance.cantripAlpha -= 0.1f;
            } else if (HUDOverlayRenderer.instance.cantripTimer >= HUDOverlayRenderer.instance.cantripTimerMax - 10) {
                HUDOverlayRenderer.instance.cantripAlpha += 0.1f;
            }
            if (HUDOverlayRenderer.instance.cantripTimer == 0) {
                HUDOverlayRenderer.instance.castingCantrip = null;
            }
        }
    }

    private static boolean shouldConditionalShow(ClientPlayerEntity entityPlayer) {
        if (MAClientConfig.HUD_MODE != MAClientConfig.HudMode.ConditionalShow) {
            return false;
        }
        return entityPlayer.func_184614_ca().func_77973_b() instanceof IShowHud || entityPlayer.func_184592_cb().func_77973_b() instanceof IShowHud || entityPlayer.func_184613_cA() && entityPlayer.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() instanceof ItemSpectralElytra;
    }

    public void renderHUD(MatrixStack matrixStack, int screenWidth, int screenHeight, float partialTicks) {
        ClientPlayerEntity player = this.mc.field_71439_g;
        FontRenderer fr = this.mc.field_71466_p;
        IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (magic == null || !magic.isMagicUnlocked()) {
            return;
        }
        Pair<Integer, Integer> coord = this.getHudCoordinates(screenWidth, screenHeight);
        int yPos = (Integer)coord.getSecond();
        int xPos = (Integer)coord.getFirst();
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        this.mc.func_110434_K().func_110577_a(GuiTextures.HUD_OVERLAY);
        this.renderManaBar(matrixStack, xPos, yPos, magic, (PlayerEntity)this.mc.field_71439_g, partialTicks);
        this.renderAffinity(matrixStack, magic, fr, screenWidth, screenHeight);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private Pair<Integer, Integer> getHudCoordinates(int screenWidth, int screenHeight) {
        int UIWidth = 155;
        int UIHeight = 30;
        switch (MAClientConfig.HUD_POS) {
            case BottomCenter: {
                return new Pair((Object)(screenWidth / 2 - UIWidth / 2), (Object)(screenHeight - UIHeight - 45));
            }
            case BottomLeft: {
                return new Pair((Object)10, (Object)(screenHeight - UIHeight));
            }
            case BottomRight: {
                return new Pair((Object)(screenWidth - UIWidth), (Object)(screenHeight - UIHeight));
            }
            case MiddleLeft: {
                if (this.pinnedRecipe != null) {
                    return new Pair((Object)10, (Object)(screenHeight / 2 + (int)((float)this.pinnedRecipe.func_238483_d_() * this.getPinSizeScale()) / 2));
                }
                return new Pair((Object)10, (Object)(screenHeight / 2 - UIHeight / 2));
            }
            case MiddleRight: {
                return new Pair((Object)(screenWidth - UIWidth), (Object)(screenHeight / 2 - UIHeight / 2));
            }
            case TopCenter: {
                return new Pair((Object)(screenWidth / 2 - UIWidth / 2), (Object)1);
            }
            case TopRight: {
                return new Pair((Object)(screenWidth - UIWidth), (Object)1);
            }
        }
        return new Pair((Object)10, (Object)1);
    }

    private float getPinSizeScale() {
        return MAClientConfig.PIN_SIZE == MAClientConfig.PinnedRecipeSize.Small ? 0.35f : (MAClientConfig.PIN_SIZE == MAClientConfig.PinnedRecipeSize.Medium ? 0.55f : 0.75f);
    }

    private void renderPinnedRecipe(MatrixStack matrixStack, int screenWidth, int screenHeight) {
        if (this.pinnedRecipe != null) {
            float scale = this.getPinSizeScale();
            GL11.glPushAttrib((int)1048575);
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)((float)(screenHeight / 2) - (float)this.pinnedRecipe.func_238483_d_() * scale / 2.0f), (float)0.0f);
            RenderSystem.scalef((float)scale, (float)scale, (float)scale);
            this.pinnedRecipe.func_230430_a_(matrixStack, 0, 0, 0.0f);
            RenderSystem.popMatrix();
            GL11.glPopAttrib();
            RenderSystem.disableAlphaTest();
        }
    }

    private void renderManaBar(MatrixStack matrixStack, int xPos, int yPos, IPlayerMagic magic, PlayerEntity player, float partialTicks) {
        if (magic.getMaxMana() <= 0.0f) {
            return;
        }
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)xPos, (float)yPos, (float)0.0f);
        xPos = 0;
        yPos = 0;
        int manaBarHeight = 15;
        int manaBarWidth = 192;
        int scaledManaBarWidth = (int)(magic.getMana() / magic.getMaxMana() * 192.0f);
        float scale = 0.4f;
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        this.func_238474_b_(matrixStack, xPos, yPos, 0, 0, 64, 64);
        RenderSystem.popMatrix();
        xPos = (int)((float)xPos + 55.0f * scale);
        yPos = (int)((float)yPos + 25.0f * scale);
        scale = 0.66f;
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        if (scaledManaBarWidth > 0) {
            this.func_238474_b_(matrixStack, xPos, yPos, 64, 15, scaledManaBarWidth, manaBarHeight);
            HUDOverlayRenderer.func_238463_a_((MatrixStack)matrixStack, (int)xPos, (int)yPos, (float)64.0f, (float)(30.0f + ((float)ManaAndArtifice.instance.proxy.getGameTicks() + partialTicks) % (float)(180 - manaBarHeight)), (int)scaledManaBarWidth, (int)manaBarHeight, (int)256, (int)256);
            float manaCost = SpellRecipe.fromNBT(player.func_184614_ca().func_77978_p()).getManaCost() + SpellRecipe.fromNBT(player.func_184592_cb().func_77978_p()).getManaCost();
            if (manaCost > 0.0f) {
                float manaCostPct = MathUtilities.clamp01(manaCost / magic.getMaxMana());
                if (manaCost > magic.getMana()) {
                    RenderSystem.color3f((float)1.0f, (float)0.0f, (float)0.0f);
                } else {
                    RenderSystem.color3f((float)1.0f, (float)0.0f, (float)1.0f);
                }
                int blitWidth = (int)((float)manaBarWidth * manaCostPct);
                HUDOverlayRenderer.func_238463_a_((MatrixStack)matrixStack, (int)Math.max(xPos + scaledManaBarWidth - blitWidth, xPos), (int)yPos, (float)64.0f, (float)(30.0f + ((float)ManaAndArtifice.instance.proxy.getGameTicks() + partialTicks) % (float)(180 - manaBarHeight)), (int)Math.min(blitWidth, scaledManaBarWidth), (int)manaBarHeight, (int)256, (int)256);
                RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        if (this.hasLowChargeItem()) {
            AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)(xPos + 192), (int)yPos, (int)16, (int)16, (float)0.0f, (float)64.0f, (int)32, (int)32, (int)256, (int)256);
        }
        this.func_238474_b_(matrixStack, xPos, yPos, 64, 0, manaBarWidth, manaBarHeight);
        int m = (int)((float)magic.getMagicXP() / (float)magic.getXPForLevel(magic.getMagicLevel() + 1) * 192.0f);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)xPos, (int)(yPos + 15), (int)(xPos + m), (int)(yPos + 17), (int)ColorHelper.PackedColor.func_233006_a_((int)255, (int)0, (int)0, (int)255));
        RenderSystem.popMatrix();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        String s = String.format("%.2f / %.2f", Float.valueOf(magic.getMana()), Float.valueOf(magic.getMaxMana()));
        if (this.mc.func_211821_e()) {
            fr.func_238421_b_(matrixStack, s, (float)(xPos + (52 - fr.func_78256_a(s) / 2)), (float)(yPos - 3), 0xE0E0E0);
        } else {
            fr.func_238421_b_(matrixStack, s, (float)(xPos + (52 - fr.func_78256_a(s) / 2)), (float)(yPos - 2), 0xE0E0E0);
        }
        s = "" + magic.getMagicLevel();
        if (this.mc.func_211821_e()) {
            fr.func_238421_b_(matrixStack, s, ((float)xPos - 4.5f - (float)(fr.func_78256_a(s) / 2)) * scale, ((float)yPos + 0.75f) * scale, ColorHelper.PackedColor.func_233006_a_((int)255, (int)100, (int)0, (int)100));
        } else {
            fr.func_238421_b_(matrixStack, s, ((float)xPos - 6.5f - (float)(fr.func_78256_a(s) / 2)) * scale, ((float)yPos + 2.75f) * scale, ColorHelper.PackedColor.func_233006_a_((int)255, (int)100, (int)0, (int)100));
        }
        RenderSystem.popMatrix();
    }

    private boolean hasLowChargeItem() {
        if (this.mc.field_71439_g.field_71071_by.field_70460_b.stream().anyMatch(is -> this.isChargeableAndLow((ItemStack)is))) {
            return true;
        }
        if (this.mc.field_71439_g.field_71071_by.field_70462_a.stream().anyMatch(is -> this.isChargeableAndLow((ItemStack)is))) {
            return true;
        }
        LazyOptional lazyCurios = CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)this.mc.field_71439_g);
        if (lazyCurios.isPresent()) {
            IItemHandlerModifiable curios = (IItemHandlerModifiable)lazyCurios.resolve().get();
            for (int i = 0; i < curios.getSlots(); ++i) {
                ChargeableItem ci;
                float pct;
                ItemStack is2 = curios.getStackInSlot(i);
                if (!(is2.func_77973_b() instanceof ChargeableItem) || !((pct = (ci = (ChargeableItem)is2.func_77973_b()).getMana(is2) / ci.getMaxMana()) < 0.1f)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isChargeableAndLow(ItemStack is) {
        ChargeableItem ci;
        float pct;
        return is.func_77973_b() instanceof ChargeableItem && (pct = (ci = (ChargeableItem)is.func_77973_b()).getMana(is) / ci.getMaxMana()) < 0.1f;
    }

    private void renderAffinity(MatrixStack matrixStack, IPlayerMagic magic, FontRenderer fr, int screenWidth, int screenHeight) {
        String s;
        List affs = magic.getSortedAffinityDepths().entrySet().stream().limit(2L).collect(Collectors.toList());
        int y = screenHeight - 5 - 14 * affs.size();
        int x = screenWidth - 45;
        int count = 0;
        if (MAClientConfig.HUD_POS == MAClientConfig.HudPos.BottomRight) {
            y = screenHeight - 45;
        }
        for (Map.Entry aff : affs) {
            if (count > 2 || ((Float)aff.getValue()).floatValue() < 0.5f) break;
            ItemStack affStack = this.affinityIcons.get(aff.getKey());
            if (affStack.func_190926_b()) continue;
            this.ir.func_175042_a(affStack, x, y);
            s = String.format("%.1f%%", aff.getValue());
            HUDOverlayRenderer.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)fr, (String)s, (int)(x + 16 + fr.func_78256_a(s) / 2), (int)(y + 4), (int)0xE0E0E0);
            if (MAClientConfig.HUD_POS == MAClientConfig.HudPos.BottomRight) {
                x -= 45;
            } else {
                y += 14;
            }
            ++count;
        }
        if (count > 0) {
            s = "Affinity: ";
            if (MAClientConfig.HUD_POS == MAClientConfig.HudPos.BottomRight) {
                HUDOverlayRenderer.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)fr, (String)s, (int)(screenWidth - 45 * affs.size() - fr.func_78256_a(s) / 2), (int)(y + 3), (int)0xE0E0E0);
            } else {
                int n = screenWidth - fr.func_78256_a(s) / 2;
                int n2 = screenHeight - 5 - 14 * affs.size();
                fr.getClass();
                HUDOverlayRenderer.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)fr, (String)s, (int)n, (int)(n2 - 9), (int)0xE0E0E0);
            }
        }
    }

    public void setPinnedRecipe(RecipeRendererBase renderer) {
        this.pinnedRecipe = renderer;
    }

    public void setCastingCantrip(String cantrip, int timer, int chevrons) {
        this.castingCantrip = cantrip;
        if (timer == 0) {
            this.cantripTimer = 60;
            this.showTimerBar = false;
        } else {
            this.cantripTimer = timer;
            this.cantripTimerMax = Math.max(timer, 1);
        }
        this.cantripAlpha = 0.0f;
        this.cantripChevrons = chevrons;
    }

    private void renderCantripTimer(MatrixStack matrixStack, int screenWidth, int screenHeight, float partialTicks) {
        if (this.castingCantrip == null || !GuiTextures.Cantrip_Icon_Mappings.containsKey(this.castingCantrip)) {
            return;
        }
        this.mc.func_110434_K().func_110577_a(GuiTextures.CANTRIP_BOOK);
        Point p = GuiTextures.Cantrip_Icon_Mappings.get(this.castingCantrip);
        int x = screenWidth / 2 - GuiTextures.Cantrip_Icon_Size.x / 2;
        int y = screenHeight / 2 - GuiTextures.Cantrip_Icon_Size.y;
        float alphaF = MathUtilities.clamp01(this.cantripAlpha);
        int alpha = (int)(255.0f * alphaF);
        RenderSystem.enableBlend();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaF);
        this.func_238474_b_(matrixStack, x, y, p.x, p.y, GuiTextures.Cantrip_Icon_Size.x, GuiTextures.Cantrip_Icon_Size.y);
        for (int i = 0; i < this.cantripChevrons; ++i) {
            this.func_238474_b_(matrixStack, x + 9, y + 18 - i * 5, GuiTextures.Cantrip_Chevron_Mappings.x, GuiTextures.Cantrip_Chevron_Mappings.y, GuiTextures.Cantrip_Chevron_Size.x, GuiTextures.Cantrip_Chevron_Size.y);
        }
        if (this.showTimerBar) {
            float pct = ((float)this.cantripTimer + partialTicks) / (float)this.cantripTimerMax;
            AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)x, (int)(y += GuiTextures.Cantrip_Icon_Size.y + 10), (int)((int)((float)x + (float)GuiTextures.Cantrip_Icon_Size.x * pct)), (int)(y + 3), (int)ColorHelper.PackedColor.func_233006_a_((int)alpha, (int)0, (int)0, (int)255));
        }
        RenderSystem.disableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public RecipeRendererBase getPinnedrecipe() {
        return this.pinnedRecipe;
    }
}

