/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui;

import com.google.common.collect.Lists;
import com.ma.KeybindInit;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.events.ClientEventHandler;
import com.ma.gui.radial.GenericRadialMenu;
import com.ma.gui.radial.components.IRadialMenuHost;
import com.ma.gui.radial.components.ItemStackRadialMenuItem;
import com.ma.gui.radial.components.RadialMenuItem;
import com.ma.items.sorcery.ISpellBookInventory;
import com.ma.items.sorcery.ItemSpellBook;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class SpellSelectionScreen
extends Screen {
    private ItemStack stackEquipped;
    private ISpellBookInventory inventory;
    private boolean needsRecheckStacks = true;
    private final List<ItemStackRadialMenuItem> cachedMenuItems = Lists.newArrayList();
    private final GenericRadialMenu menu;
    private Minecraft mc = Minecraft.func_71410_x();

    public SpellSelectionScreen() {
        super((ITextComponent)new StringTextComponent("RADIAL MENU"));
        this.stackEquipped = this.mc.field_71439_g.func_184614_ca();
        if (this.stackEquipped.func_77973_b() instanceof ItemSpellBook) {
            this.inventory = ((ItemSpellBook)this.stackEquipped.func_77973_b()).getInventory(this.stackEquipped, (IPlayerMagic)this.mc.field_71439_g.getCapability(PlayerMagicProvider.MAGIC).orElse(null));
        } else {
            this.func_231175_as__();
        }
        this.menu = new GenericRadialMenu(Minecraft.func_71410_x(), new IRadialMenuHost(){

            @Override
            public void renderTooltip(MatrixStack matrixStack, ItemStack stack, int mouseX, int mouseY) {
                SpellSelectionScreen.this.func_230457_a_(matrixStack, stack, mouseX, mouseY);
            }

            @Override
            public Screen getScreen() {
                return SpellSelectionScreen.this;
            }

            @Override
            public FontRenderer getFontRenderer() {
                return SpellSelectionScreen.this.field_230712_o_;
            }

            @Override
            public ItemRenderer getItemRenderer() {
                return SpellSelectionScreen.this.field_230707_j_;
            }
        }){

            @Override
            public void onClickOutside() {
                this.close();
            }
        };
    }

    @SubscribeEvent
    public static void overlayEvent(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r instanceof SpellSelectionScreen) {
            event.setCanceled(true);
        }
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        ClientEventHandler.wipeOpen();
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.menu.tick();
        if (this.menu.isClosed()) {
            Minecraft.func_71410_x().func_147108_a(null);
            ClientEventHandler.wipeOpen();
        }
        if (!this.menu.isReady() || this.inventory == null) {
            return;
        }
        ItemStack inHand = this.field_230706_i_.field_71439_g.func_184614_ca();
        if (!(inHand.func_77973_b() instanceof ItemSpellBook)) {
            this.inventory = null;
        } else {
            ItemStack stack = inHand;
            if (stack.func_190916_E() <= 0) {
                this.inventory = null;
                this.stackEquipped = null;
            } else if (this.stackEquipped != stack) {
                this.menu.close();
            }
        }
        if (this.inventory == null) {
            Minecraft.func_71410_x().func_147108_a(null);
        } else if (!ClientEventHandler.isKeyDown(KeybindInit.spellBookSelectWheelOpen)) {
            this.processClick(false);
        }
    }

    public boolean func_231048_c_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.processClick(true);
        return super.func_231048_c_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    protected void processClick(boolean triggeredByMouse) {
        this.menu.clickItem();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.inventory == null) {
            return;
        }
        final ItemStack inHand = this.field_230706_i_.field_71439_g.func_184614_ca();
        if (!(inHand.func_77973_b() instanceof ItemSpellBook)) {
            return;
        }
        if (this.needsRecheckStacks) {
            this.cachedMenuItems.clear();
            ItemStack[] activeSpells = this.inventory.getActiveSpells();
            for (int i = 0; i < activeSpells.length; ++i) {
                ItemStack inSlot = activeSpells[i];
                final int index = i;
                ItemStackRadialMenuItem item = new ItemStackRadialMenuItem(this.menu, i, inSlot, (ITextComponent)new TranslationTextComponent("gui.mana-and-artifice.spellbook.empty")){

                    @Override
                    public boolean onClick() {
                        ItemSpellBook.setSlot((PlayerEntity)((SpellSelectionScreen)SpellSelectionScreen.this).mc.field_71439_g, inHand, index, true);
                        SpellSelectionScreen.this.menu.close();
                        return true;
                    }
                };
                item.setVisible(true);
                this.cachedMenuItems.add(item);
            }
            this.menu.clear();
            this.menu.addAll(this.cachedMenuItems);
            this.needsRecheckStacks = false;
        }
        if (this.cachedMenuItems.stream().noneMatch(RadialMenuItem::isVisible)) {
            this.menu.setCentralText((ITextComponent)new TranslationTextComponent("gui.mana-and-artifice.spellbook.empty"));
        } else {
            this.menu.setCentralText(null);
        }
        this.menu.draw(matrixStack, partialTicks, mouseX, mouseY);
    }

    public boolean func_231177_au__() {
        return false;
    }
}

