/*
 * Decompiled with CFR 0.152.
 */
package com.ma.guide;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ma.ManaAndArtifice;
import com.ma.guide.EntryCategories;
import com.ma.guide.RelatedRecipe;
import com.ma.guide.interfaces.IEntrySection;
import com.ma.guide.sections.ImageSection;
import com.ma.guide.sections.ItemSection;
import com.ma.guide.sections.TextSection;
import com.ma.guide.sections.TitleSection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class GuidebookEntry {
    private static final String KEY_CATEGORY = "category";
    private static final String KEY_TIER = "tier";
    private static final String KEY_INDEX = "index";
    private static final String KEY_SECTIONS = "sections";
    private static final String KEY_SECTION_TYPE = "type";
    private static final String KEY_RELATED_RECIPES = "related_recipes";
    private static final int MAX_RELATED_RECIPES = 10;
    private static final HashMap<String, Class<? extends IEntrySection>> typeRegistry = new HashMap<String, Class<? extends IEntrySection>>(){
        {
            this.put("text", TextSection.class);
            this.put("image", ImageSection.class);
            this.put("title", TitleSection.class);
            this.put("item", ItemSection.class);
        }
    };
    private final NonNullList<IEntrySection> sections;
    private final NonNullList<RelatedRecipe> relatedRecipes;
    private final boolean isValid;
    private final EntryCategories category;
    private final Optional<Integer> tier;
    private final int index;
    private final String name;
    int y = 10;
    int x_max = 110;
    int y_max = 158;
    int page = 0;

    public GuidebookEntry(JsonObject entryObject, String name) {
        boolean valid = true;
        this.name = name;
        this.sections = NonNullList.func_191196_a();
        this.relatedRecipes = NonNullList.func_191196_a();
        valid = this.parseSections(entryObject);
        valid = this.parseRelatedRecipes(entryObject);
        this.category = this.parseCategory(entryObject);
        this.tier = this.parseTier(entryObject);
        this.index = this.parseIndex(entryObject);
        if (this.getFirstTitle() == null) {
            ManaAndArtifice.LOGGER.error(String.format("Entry '%s' of the codex is missing the required title section (must have at least one)", name));
            valid = false;
        }
        this.isValid = valid;
    }

    private boolean parseSections(JsonObject entryObject) {
        if (entryObject.has(KEY_SECTIONS)) {
            JsonArray sections = entryObject.get(KEY_SECTIONS).getAsJsonArray();
            for (JsonElement elem : sections) {
                JsonObject elemObj;
                if (!elem.isJsonObject() || !(elemObj = elem.getAsJsonObject()).has(KEY_SECTION_TYPE)) continue;
                String type = elemObj.get(KEY_SECTION_TYPE).getAsString();
                Class<? extends IEntrySection> clazz = typeRegistry.get(type);
                try {
                    IEntrySection section = clazz.newInstance();
                    Collection<IEntrySection> parsed_sections = section.parse(elemObj, this.y, this.y_max, this.x_max, this.page);
                    this.sections.addAll(parsed_sections);
                    for (IEntrySection s : parsed_sections) {
                        if (s.getPage() > this.page) {
                            this.page = s.getPage();
                            this.y = s.getHeight(this.y_max);
                            continue;
                        }
                        this.y += s.getHeight(this.y_max);
                    }
                }
                catch (Exception exception) {
                }
            }
            ((IEntrySection)this.sections.get(this.sections.size() - 1)).setPadding(0);
            return true;
        }
        return false;
    }

    private boolean parseRelatedRecipes(JsonObject entryObject) {
        JsonElement rr;
        if (entryObject.has(KEY_RELATED_RECIPES) && (rr = entryObject.get(KEY_RELATED_RECIPES)).isJsonArray()) {
            JsonArray arr = rr.getAsJsonArray();
            for (JsonElement elem : arr) {
                if (!elem.isJsonObject()) continue;
                JsonObject obj = elem.getAsJsonObject();
                String type = "crafting";
                ResourceLocation[] rLocs = new ResourceLocation[1];
                if (obj.has(KEY_SECTION_TYPE)) {
                    type = obj.get(KEY_SECTION_TYPE).getAsString();
                }
                if (obj.has("locations")) {
                    rLocs = this.parseResourceLocations(obj.get("locations").getAsJsonArray());
                } else {
                    rLocs[0] = new ResourceLocation(obj.get("location").getAsString());
                }
                this.relatedRecipes.add((Object)new RelatedRecipe(rLocs, type));
                if (this.relatedRecipes.size() < 10) continue;
                break;
            }
        }
        return true;
    }

    private EntryCategories parseCategory(JsonObject entryObject) {
        if (entryObject.has(KEY_CATEGORY)) {
            EntryCategories eCat;
            String c = entryObject.get(KEY_CATEGORY).getAsString();
            try {
                eCat = EntryCategories.valueOf(c.toUpperCase());
            }
            catch (Exception ex) {
                eCat = EntryCategories.BASICS;
            }
            return eCat;
        }
        return EntryCategories.BASICS;
    }

    private Optional<Integer> parseTier(JsonObject entryObject) {
        if (entryObject.has(KEY_TIER)) {
            return Optional.of(entryObject.get(KEY_TIER).getAsInt());
        }
        return Optional.empty();
    }

    private int parseIndex(JsonObject entryObject) {
        if (entryObject.has(KEY_INDEX)) {
            return entryObject.get(KEY_INDEX).getAsInt();
        }
        return 0;
    }

    private ResourceLocation[] parseResourceLocations(JsonArray obj) {
        ArrayList<ResourceLocation> rLocs = new ArrayList<ResourceLocation>();
        for (int i = 0; i < obj.size(); ++i) {
            JsonElement elem = obj.get(i);
            if (!elem.isJsonPrimitive()) continue;
            rLocs.add(new ResourceLocation(elem.getAsString()));
        }
        return rLocs.toArray(new ResourceLocation[0]);
    }

    public int getTier() {
        if (this.tier.isPresent()) {
            return this.tier.get();
        }
        if (this.relatedRecipes.size() == 0) {
            return 1;
        }
        Optional<RelatedRecipe> min = this.relatedRecipes.stream().min(Comparator.comparing(RelatedRecipe::getTier));
        return min.isPresent() ? min.get().getTier() : 1;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getFirstTitle() {
        TitleSection title = this.sections.stream().filter(s -> s instanceof TitleSection).map(s -> (TitleSection)s).findFirst().get();
        if (title == null) {
            return null;
        }
        return title.getText();
    }

    public EntryCategories getCategory() {
        return this.category;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public NonNullList<IEntrySection> getSections() {
        return this.sections;
    }

    public NonNullList<RelatedRecipe> getRelatedRecipes() {
        return this.relatedRecipes;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GuidebookEntry) {
            return ((GuidebookEntry)obj).getName().equals(this.getName());
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }
}

