/*
 * Decompiled with CFR 0.152.
 */
package com.ma.guide;

import com.ma.guide.recipe.Recipe3x3;
import com.ma.guide.recipe.RecipeArcaneFurnace;
import com.ma.guide.recipe.RecipeManaweavePattern;
import com.ma.guide.recipe.RecipeManaweaving;
import com.ma.guide.recipe.RecipeRendererBase;
import com.ma.guide.recipe.RecipeRitual;
import com.ma.guide.recipe.RecipeRunescribing;
import com.ma.guide.recipe.RecipeRunesmith;
import com.ma.guide.recipe.RecipeSpellPart;
import com.ma.items.ItemInit;
import com.ma.recipes.spells.ISpellComponentRecipe;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class RelatedRecipe {
    public static final String CRAFTING = "crafting";
    public static final String MANAWEAVING_PATTERN = "manaweaving_pattern";
    public static final String MANAWEAVING_ALTAR = "manaweaving_altar";
    public static final String RITUAL = "ritual";
    public static final String RUNESMITH_ENCHANT = "runesmith_enchant";
    public static final String RUNESMITHING = "runesmithing";
    public static final String ARCANE_FURNACE = "arcane_furnace";
    public static final String RUNESCRIBING = "runescribing";
    public static final String SPELL = "spell_part";
    private String _type;
    private int _tier = -1;
    private ResourceLocation[] _rLocs;
    private NonNullList<ItemStack> _outputItems;
    RecipeRendererBase renderer = null;
    private String key = "";

    public RelatedRecipe(ResourceLocation[] rLocs, String type) {
        this._type = type.replace("-", "_");
        this._rLocs = rLocs;
        StringBuilder sb = new StringBuilder();
        sb.append(this._type);
        for (ResourceLocation rLoc : this._rLocs) {
            sb.append(rLoc.toString());
        }
        this.key = sb.toString();
    }

    public String getType() {
        return this._type;
    }

    public ResourceLocation[] getResourceLocations() {
        return this._rLocs;
    }

    @Nullable
    public RecipeRendererBase constructRenderer(int x, int y, Consumer<List<ITextComponent>> tooltipFunction) {
        if (this.renderer == null || this.renderer.field_230690_l_ != x || this.renderer.field_230691_m_ != y || this.renderer.getTooltipFunction() != tooltipFunction) {
            this.createRenderer(x, y, tooltipFunction);
        }
        return this.renderer;
    }

    public NonNullList<ItemStack> getOutputItems(World world) {
        if (this._outputItems == null) {
            this._outputItems = NonNullList.func_191196_a();
            RecipeManager recipes = world.func_199532_z();
            for (ResourceLocation rLoc : this.getResourceLocations()) {
                Optional recipe = recipes.func_215367_a(rLoc);
                if (recipe == null || !recipe.isPresent()) continue;
                if (recipe.get() instanceof ISpellComponentRecipe) {
                    ItemStack dummy = new ItemStack((IItemProvider)ItemInit.ENCHANTED_VELLUM.get());
                    dummy.func_200302_a((ITextComponent)new TranslationTextComponent(((ISpellComponentRecipe)recipe.get()).getComponent().getRegistryName().toString()));
                    this._outputItems.add((Object)dummy);
                    continue;
                }
                this._outputItems.add((Object)((IRecipe)recipe.get()).func_77571_b());
            }
        }
        return this._outputItems;
    }

    private void createRenderer(int x, int y, Consumer<List<ITextComponent>> tooltipFunction) {
        switch (this._type) {
            case "crafting": {
                this.renderer = new Recipe3x3(x, y);
                break;
            }
            case "manaweaving_pattern": {
                this.renderer = new RecipeManaweavePattern(x, y);
                break;
            }
            case "manaweaving_altar": {
                this.renderer = new RecipeManaweaving(x, y);
                break;
            }
            case "ritual": {
                this.renderer = new RecipeRitual(x, y);
                break;
            }
            case "arcane_furnace": {
                this.renderer = new RecipeArcaneFurnace(x, y);
                break;
            }
            case "runescribing": {
                this.renderer = new RecipeRunescribing(x, y);
                break;
            }
            case "spell_part": {
                this.renderer = new RecipeSpellPart(x, y);
                break;
            }
            case "runesmithing": {
                this.renderer = new RecipeRunesmith(x, y);
            }
        }
        if (this.renderer != null) {
            this.renderer.setTooltipFunction(tooltipFunction);
            this.renderer.init(this.getResourceLocations());
        }
    }

    public int getTier() {
        if (this._tier == -1) {
            this.createRenderer(0, 0, null);
            if (this.renderer != null) {
                this._tier = this.renderer.getTier();
                this.renderer = null;
            } else {
                this._tier = 1;
            }
        }
        return this._tier;
    }

    public String toString() {
        return this.key;
    }
}

