/*
 * Decompiled with CFR 0.152.
 */
package com.ma.guide.recipe;

import com.ma.gui.GuiTextures;
import com.ma.guide.recipe.ICyclingRecipeRenderer;
import com.ma.guide.recipe.RecipeRendererBase;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.ma.recipes.manaweaving.ManaweavingPatternHelper;
import com.ma.recipes.manaweaving.ManaweavingRecipe;
import com.ma.tools.MATags;
import com.ma.tools.render.GuiRenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RecipeManaweaving
extends RecipeRendererBase
implements ICyclingRecipeRenderer<RecipeManaweaving> {
    private ManaweavingRecipe[] patterns;

    public RecipeManaweaving(int x, int y) {
        super(x, y);
    }

    @Override
    public void init_cycling(ResourceLocation[] rLocs) {
        ArrayList<ManaweavingRecipe> patternList = new ArrayList<ManaweavingRecipe>();
        for (ResourceLocation rLoc : rLocs) {
            Optional<IRecipe<?>> pattern = this.resolveRecipe(rLoc);
            if (!pattern.isPresent() || !(pattern.get() instanceof ManaweavingRecipe)) continue;
            patternList.add((ManaweavingRecipe)pattern.get());
        }
        this.patterns = patternList.toArray(new ManaweavingRecipe[0]);
    }

    @Override
    public void init_internal(ResourceLocation recipeLocation) {
        Optional<IRecipe<?>> pattern = this.resolveRecipe(recipeLocation);
        this.patterns = pattern.isPresent() && pattern.get() instanceof ManaweavingRecipe ? new ManaweavingRecipe[]{(ManaweavingRecipe)pattern.get()} : null;
    }

    private Optional<? extends IRecipe<?>> resolveRecipe(ResourceLocation recipeLocation) {
        if (!recipeLocation.func_110623_a().startsWith("manaweaving/")) {
            recipeLocation = new ResourceLocation(recipeLocation.func_110624_b(), "manaweaving/" + recipeLocation.func_110623_a());
        }
        return this.minecraft.field_71441_e.func_199532_z().func_215367_a(recipeLocation);
    }

    @Override
    protected ResourceLocation backgroundTexture() {
        return GuiTextures.GUIDEBOOK_RECIPE_MANAWEAVING_ALTAR;
    }

    @Override
    protected void drawForeground(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int i;
        if (this.patterns.length == 0) {
            return;
        }
        int index = this.getIndex();
        ManaweavingRecipe pattern = this.patterns[index];
        if (pattern == null) {
            return;
        }
        GuiRenderUtils.bindManaweaveTextureRenderer();
        float patternScale = 0.1f;
        int startX = (int)((float)(this.field_230690_l_ + 31) / patternScale);
        int startY = (int)((float)(this.field_230691_m_ + 225) / patternScale);
        RenderSystem.color3f((float)0.5f, (float)0.0f, (float)1.0f);
        for (i = 0; i < pattern.getRequiredPatterns().length; ++i) {
            ManaweavingPattern p = ManaweavingPatternHelper.GetManaweavingRecipe((World)this.minecraft.field_71441_e, pattern.getRequiredPatterns()[i]);
            if (p == null) continue;
            GuiRenderUtils.renderManaweavePattern(matrixStack, startX, startY, patternScale, p);
            startX += (int)Math.floor(33.6f / patternScale);
        }
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        startX = this.field_230690_l_ + 9;
        startY = this.field_230691_m_ + 12;
        for (i = 0; i < pattern.getRequiredItems().length; ++i) {
            List<ItemStack> items = MATags.smartLookupItem(pattern.getRequiredItems()[i]).stream().map(item -> new ItemStack((IItemProvider)item)).collect(Collectors.toList());
            if (items == null || items.size() == 0) continue;
            if (i == 0) {
                this.renderItemStack(items, startX + 66, startY + 33);
            } else {
                this.renderItemStack(items, startX, startY);
            }
            startX += 33;
            if (i == 4) {
                startX += 33;
            }
            if (startX <= this.field_230690_l_ + 108) continue;
            startY += 33;
            startX = this.field_230690_l_ + 42;
        }
        ItemStack output = pattern.func_77571_b();
        this.renderItemStack(output, this.field_230690_l_ + 162, this.field_230691_m_ + 45);
        FontRenderer fr = this.minecraft.field_71466_p;
        String lineFormatted = I18n.func_135052_a((String)"gui.mana-and-artifice.shapeless", (Object[])new Object[0]);
        fr.func_238421_b_(matrixStack, lineFormatted, (float)(this.field_230690_l_ + 171 - fr.func_78256_a(lineFormatted) / 2), (float)(this.field_230691_m_ + 70), 0x404040);
    }

    @Override
    public int getTier() {
        if (this.patterns == null) {
            return 1;
        }
        int minTier = 5;
        for (ManaweavingRecipe pattern : this.patterns) {
            if (pattern.getTier() >= minTier) continue;
            minTier = pattern.getTier();
        }
        return minTier;
    }

    @Override
    public int countRecipes() {
        return this.patterns.length;
    }
}

