/*
 * Decompiled with CFR 0.152.
 */
package com.ma.guide.recipe;

import com.ma.guide.recipe.ICyclingRecipeRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public abstract class RecipeRendererBase
extends Widget {
    private static final int CYCLE_TICKS = 40;
    protected Minecraft minecraft = Minecraft.func_71410_x();
    private ResourceLocation[] rLocs = new ResourceLocation[0];
    private boolean initialized = false;
    private int curMouseX = 0;
    private int curMouseY = 0;
    private static final int ITEMSTACK_WIDTH = 16;
    private Consumer<List<ITextComponent>> tooltipFunction;
    protected int lockIndex = -1;

    public RecipeRendererBase(int xIn, int yIn) {
        super(xIn, yIn, 218, 256, (ITextComponent)new StringTextComponent(""));
    }

    public void setTooltipFunction(Consumer<List<ITextComponent>> tooltipFunction) {
        this.tooltipFunction = tooltipFunction;
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(this.backgroundTexture());
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int i = this.field_230690_l_;
        int j = this.field_230691_m_;
        RecipeRendererBase.func_238463_a_((MatrixStack)matrixStack, (int)i, (int)j, (float)0.0f, (float)0.0f, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)218, (int)256);
        this.curMouseX = mouseX;
        this.curMouseY = mouseY;
        this.drawForeground(matrixStack, this.field_230690_l_, this.field_230691_m_, mouseX, mouseY, partialTicks);
    }

    protected boolean func_230987_a_(int p_isValidClickButton_1_) {
        return false;
    }

    protected abstract void drawForeground(MatrixStack var1, int var2, int var3, int var4, int var5, float var6);

    protected final void renderItemStack(ItemStack stackToRender, int x, int y) {
        this.renderItemStack(Arrays.asList(stackToRender), x, y, 1.0f);
    }

    protected final void renderItemStack(ItemStack stackToRender, int x, int y, float scale) {
        this.renderItemStack(Arrays.asList(stackToRender), x, y, scale);
    }

    protected final void renderItemStack(List<ItemStack> stackToRender, int x, int y) {
        this.renderItemStack(stackToRender, x, y, 1.0f);
    }

    protected final void renderItemStack(List<ItemStack> stackToRender, int x, int y, float scale) {
        if (stackToRender == null || stackToRender.size() == 0) {
            return;
        }
        ItemStack stack = this.getCurrentIndex(stackToRender);
        this.minecraft.func_175599_af().field_77023_b = -50.0f;
        this.minecraft.func_175599_af().func_180450_b(stack, x, y);
        int adjustedX = (int)((float)x * scale + 16.0f * scale);
        int adjustedY = (int)((float)y * scale + 16.0f * scale);
        if (this.tooltipFunction != null && adjustedX >= this.curMouseX && (float)adjustedX <= (float)this.curMouseX + 16.0f * scale && adjustedY >= this.curMouseY && (float)adjustedY <= (float)this.curMouseY + 16.0f * scale) {
            List toolTip = stack.func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            this.tooltipFunction.accept(toolTip);
        }
    }

    private ItemStack getCurrentIndex(List<ItemStack> stacks) {
        if (stacks.size() == 1) {
            return stacks.get(0);
        }
        return stacks.get((int)(this.minecraft.field_71441_e.func_82737_E() / 40L % (long)stacks.size()));
    }

    protected abstract ResourceLocation backgroundTexture();

    protected abstract void init_internal(ResourceLocation var1);

    public void init(ResourceLocation[] recipeLocations) {
        if (this.initialized) {
            return;
        }
        this.rLocs = recipeLocations;
        if (this instanceof ICyclingRecipeRenderer) {
            ((ICyclingRecipeRenderer)((Object)this)).init_cycling(this.rLocs);
        } else {
            this.init_internal(this.rLocs[0]);
        }
    }

    public RecipeRendererBase clone(int x, int y, boolean lock_index) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        try {
            RecipeRendererBase inst = (RecipeRendererBase)((Object)clazz.getDeclaredConstructor(Integer.TYPE, Integer.TYPE).newInstance(x, y));
            inst.init(this.rLocs);
            if (lock_index && this instanceof ICyclingRecipeRenderer) {
                inst.lockIndex = ((ICyclingRecipeRenderer)((Object)this)).getIndex();
            }
            return inst;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof RecipeRendererBase) {
            RecipeRendererBase other = (RecipeRendererBase)((Object)obj);
            if (this.rLocs.length != other.rLocs.length) {
                return false;
            }
            for (int i = 0; i < this.rLocs.length; ++i) {
                if (this.rLocs[i].equals((Object)other.rLocs[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public abstract int getTier();

    public Consumer<List<ITextComponent>> getTooltipFunction() {
        return this.tooltipFunction;
    }
}

