/*
 * Decompiled with CFR 0.152.
 */
package com.ma.guide.recipe;

import com.ma.api.rituals.IRitualReagent;
import com.ma.gui.GuiTextures;
import com.ma.guide.recipe.RecipeRendererBase;
import com.ma.recipes.rituals.RitualRecipe;
import com.ma.recipes.rituals.RitualRecipeHelper;
import com.ma.tools.MATags;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.stream.Collectors;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RecipeRitual
extends RecipeRendererBase {
    private RitualRecipe pattern;
    static final int POINT_RENDER_SIZE = 13;

    public RecipeRitual(int x, int y) {
        super(x, y);
    }

    @Override
    public void init_internal(ResourceLocation recipeLocation) {
        this.pattern = RitualRecipeHelper.GetRitualRecipe((World)this.minecraft.field_71441_e, recipeLocation);
    }

    @Override
    protected ResourceLocation backgroundTexture() {
        return GuiTextures.GUIDEBOOK_RECIPE_BLANK;
    }

    @Override
    protected void drawForeground(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int j;
        int i;
        if (this.pattern == null) {
            return;
        }
        int startX = this.field_230690_l_ + this.field_230688_j_ - 60;
        int startY = this.field_230691_m_ + 60;
        int pointSize = (this.field_230688_j_ - 80) / this.pattern.getPattern().length;
        int centerOffset = (pointSize - 13) / 2;
        int[][] pData = this.pattern.getPattern();
        IRitualReagent[][] reagents = this.pattern.getReagents();
        this.minecraft.field_71446_o.func_110577_a(GuiTextures.GUIDEBOOK_WIDGETS);
        RenderSystem.disableDepthTest();
        for (i = 0; i < pData.length; ++i) {
            for (j = 0; j < pData[i].length; ++j) {
                if (pData[i][j] == 0) continue;
                this.func_238474_b_(matrixStack, startX - j * pointSize - centerOffset, startY + i * pointSize + centerOffset, 13, 0, 13, 13);
            }
        }
        RenderSystem.enableDepthTest();
        for (i = 0; i < reagents.length; ++i) {
            for (j = 0; j < reagents[i].length; ++j) {
                if (reagents[i][j] == null || reagents[i][j].isDynamic()) continue;
                this.renderItemStack(MATags.smartLookupItem(reagents[i][j].getResourceLocation()).stream().map(item -> new ItemStack((IItemProvider)item)).collect(Collectors.toList()), startX - 1 - j * pointSize - centerOffset, startY - 1 + i * pointSize + centerOffset);
            }
        }
        FontRenderer fr = this.minecraft.field_71466_p;
        String patternName = I18n.func_135052_a((String)this.pattern.func_199560_c().toString(), (Object[])new Object[0]);
        fr.func_238421_b_(matrixStack, patternName, (float)(this.field_230690_l_ + this.field_230688_j_ / 2 - fr.func_78256_a(patternName) / 2), (float)(this.field_230691_m_ + 15), 0x404040);
        String patternSize = String.format("%dx%d", this.pattern.getPattern().length, this.pattern.getPattern().length);
        fr.func_238421_b_(matrixStack, patternSize, (float)(this.field_230690_l_ + this.field_230688_j_ / 2 - fr.func_78256_a(patternSize) / 2), (float)(this.field_230691_m_ + 25), 0x404040);
    }

    @Override
    public int getTier() {
        return this.pattern != null ? this.pattern.getTier() : 1;
    }
}

