/*
 * Decompiled with CFR 0.152.
 */
package com.ma.guide.recipe;

import com.ma.Registries;
import com.ma.api.spells.base.ISpellComponent;
import com.ma.gui.GuiTextures;
import com.ma.guide.recipe.RecipeRendererBase;
import com.ma.recipes.ItemAndPatternRecipe;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.ma.recipes.manaweaving.ManaweavingPatternHelper;
import com.ma.tools.MATags;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RecipeSpellPart
extends RecipeRendererBase {
    ItemAndPatternRecipe recipe;
    ISpellComponent output;
    ArrayList<List<ItemStack>> reagents = new ArrayList();

    public RecipeSpellPart(int xIn, int yIn) {
        super(xIn, yIn);
    }

    @Override
    protected void drawForeground(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.recipe == null) {
            return;
        }
        this.renderSpellIcon(matrixStack);
        this.renderManaweavePatterns(matrixStack);
        this.renderRecipeStack(0, 41, 44);
        this.renderRecipeStack(1, 162, 159);
        this.renderRecipeStack(2, 41, 159);
        this.renderRecipeStack(3, 162, 44);
        this.renderRecipeStack(4, 41, 101);
        this.renderRecipeStack(5, 162, 101);
        this.renderRecipeStack(6, 101, 44);
        this.renderRecipeStack(7, 101, 159);
    }

    private void renderRecipeStack(int index, int x, int y) {
        if (index >= this.reagents.size()) {
            return;
        }
        this.renderItemStack(this.reagents.get(index), this.field_230690_l_ + x, this.field_230691_m_ + y + 1);
    }

    private void renderManaweavePatterns(MatrixStack matrixStack) {
        this.minecraft.func_110434_K().func_110577_a(GuiTextures.GUIDEBOOK_WIDGETS);
        float patternScale = 0.1f;
        int POINT_RENDER_SIZE = 13;
        int startX = (int)((float)(this.field_230690_l_ + 31) / patternScale);
        int startY = (int)((float)(this.field_230691_m_ + 225) / patternScale);
        RenderSystem.color3f((float)0.5f, (float)0.0f, (float)1.0f);
        for (int i = 0; i < this.recipe.getRequiredPatterns().length; ++i) {
            ManaweavingPattern p = ManaweavingPatternHelper.GetManaweavingRecipe((World)this.minecraft.field_71441_e, this.recipe.getRequiredPatterns()[i]);
            if (p == null) continue;
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)patternScale, (float)patternScale, (float)patternScale);
            byte[][] pData = p.get();
            int pointSize = 13;
            for (int k = 0; k < pData.length; ++k) {
                for (int j = 0; j < pData[k].length; ++j) {
                    if (pData[k][j] == 0) continue;
                    this.func_238474_b_(matrixStack, startX - j * pointSize, startY + k * pointSize, 0, 0, POINT_RENDER_SIZE, POINT_RENDER_SIZE);
                }
            }
            RenderSystem.popMatrix();
            startX = (int)((float)startX + 34.0f / patternScale);
        }
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderSpellIcon(MatrixStack matrixStack) {
        if (this.output != null) {
            this.minecraft.func_110434_K().func_110577_a(this.output.getGuiIcon());
            RecipeSpellPart.func_238463_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + 102), (int)(this.field_230691_m_ + 101), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
    }

    @Override
    protected ResourceLocation backgroundTexture() {
        return GuiTextures.GUIDEBOOK_RECIPE_SPELLPART;
    }

    @Override
    public void init_internal(ResourceLocation recipeLocation) {
        Optional pattern = this.minecraft.field_71441_e.func_199532_z().func_215367_a(recipeLocation);
        if (pattern.isPresent() && pattern.get() instanceof ItemAndPatternRecipe) {
            this.recipe = (ItemAndPatternRecipe)pattern.get();
        }
        if (this.recipe != null) {
            ResourceLocation rLoc = this.recipe.getOutput();
            if (rLoc.func_110624_b().equals("mana-and-artifice")) {
                rLoc = new ResourceLocation("mana-and-artifice", "shapes/" + this.recipe.getOutput().func_110623_a());
                this.output = (ISpellComponent)Registries.Shape.getValue(rLoc);
                if (this.output == null) {
                    rLoc = new ResourceLocation("mana-and-artifice", "components/" + this.recipe.getOutput().func_110623_a());
                    this.output = (ISpellComponent)Registries.Component.getValue(rLoc);
                }
                if (this.output == null) {
                    rLoc = new ResourceLocation("mana-and-artifice", "modifiers/" + this.recipe.getOutput().func_110623_a());
                    this.output = (ISpellComponent)Registries.Modifier.getValue(rLoc);
                }
            } else {
                this.output = (ISpellComponent)Registries.Shape.getValue(this.recipe.getOutput());
                if (this.output == null) {
                    this.output = (ISpellComponent)Registries.Component.getValue(this.recipe.getOutput());
                }
                if (this.output == null) {
                    this.output = (ISpellComponent)Registries.Modifier.getValue(this.recipe.getOutput());
                }
            }
            for (int i = 0; i < this.recipe.getRequiredItems().length; ++i) {
                this.reagents.add(MATags.smartLookupItem(this.recipe.getRequiredItems()[i]).stream().map(item -> new ItemStack((IItemProvider)item)).collect(Collectors.toList()));
            }
        }
    }

    @Override
    public int getTier() {
        return this.recipe != null ? this.recipe.getTier() : 1;
    }
}

