/*
 * Decompiled with CFR 0.152.
 */
package com.ma.guide.sections;

import com.google.gson.JsonObject;
import com.ma.guide.interfaces.IEntrySection;
import com.ma.guide.sections.SectionBase;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextSection
extends SectionBase {
    protected float SCALE_FACTOR = 1.0f;
    protected boolean CENTER = false;
    protected int PADDING = 5;
    protected int LINE_HEIGHT = 10;
    protected NonNullList<ITextProperties> lines = NonNullList.func_191196_a();
    protected String rawText = "";
    protected boolean newPage = false;
    protected boolean addPadding = false;

    @Override
    public Collection<IEntrySection> parse(JsonObject element, int startY, int maxHeight, int maxWidth, int page) {
        this.rawText = element.get("value").getAsString();
        if (element.has("newPage")) {
            this.newPage = element.get("newPage").getAsBoolean();
        }
        if (this.newPage && startY != 10) {
            ++page;
            startY = 10;
            maxHeight = 158;
        }
        Minecraft m = Minecraft.func_71410_x();
        FontRenderer fr = m.field_71466_p;
        fr.getClass();
        this.LINE_HEIGHT = (int)Math.ceil(9.0f * this.SCALE_FACTOR);
        List split_lines = fr.func_238420_b_().func_238365_g_(this.rawText, (int)Math.floor((float)maxWidth / this.SCALE_FACTOR), Style.field_240709_b_);
        return this.createTextLinesRecursive(split_lines, startY, maxHeight, page);
    }

    private Collection<IEntrySection> createTextLinesRecursive(List<ITextProperties> split_lines, int startY, int maxHeight, int page) {
        NonNullList output = NonNullList.func_191196_a();
        output.add((Object)this);
        if (startY + this.LINE_HEIGHT > maxHeight) {
            ++page;
            startY = 10;
        }
        this.setPage(page);
        int totalHeight = split_lines.size() * this.LINE_HEIGHT + this.PADDING;
        if (totalHeight + startY <= maxHeight) {
            this.lines.addAll(split_lines);
            this.addPadding = true;
        } else if (totalHeight + startY - this.PADDING <= maxHeight) {
            this.lines.addAll(split_lines);
            this.addPadding = false;
        } else {
            int lines_on_current_page = (int)Math.floor((maxHeight - startY) / this.LINE_HEIGHT) - 1;
            this.lines.addAll(split_lines.subList(0, lines_on_current_page));
            List<ITextProperties> subList = split_lines.subList(lines_on_current_page, split_lines.size());
            TextSection newTS = new TextSection();
            output.addAll(newTS.createTextLinesRecursive(subList, 10, 158, page + 1));
        }
        return output;
    }

    @Override
    public void render(MatrixStack matrixStack, int x, int y, int maxWidth, int maxHeight) {
        Minecraft m = Minecraft.func_71410_x();
        FontRenderer fr = m.field_71466_p;
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)this.SCALE_FACTOR, (float)this.SCALE_FACTOR, (float)this.SCALE_FACTOR);
        for (ITextProperties line : this.lines) {
            int pX = x;
            if (this.CENTER) {
                pX = (int)((float)pX + ((float)maxWidth - (float)fr.func_78256_a(line.getString()) * this.SCALE_FACTOR) / 2.0f);
            }
            fr.func_238421_b_(matrixStack, line.getString(), (float)pX / this.SCALE_FACTOR, (float)y / this.SCALE_FACTOR, 0x404040);
            y += this.LINE_HEIGHT;
        }
        RenderSystem.popMatrix();
    }

    @Override
    public int getHeight(int maxHeight) {
        int height = this.lines.size() * this.LINE_HEIGHT;
        if (this.addPadding) {
            height += this.PADDING;
        }
        return height;
    }

    @Override
    public int getWidth(int maxWidth) {
        return (int)((float)maxWidth / this.SCALE_FACTOR);
    }

    @Override
    public boolean canWrap() {
        return true;
    }

    @Override
    public boolean newPage() {
        return this.newPage;
    }

    @Override
    public void setPadding(int i) {
        this.PADDING = i;
    }

    public String getRawText() {
        return this.rawText;
    }
}

