/*
 * Decompiled with CFR 0.152.
 */
package com.ma.interop.jei.categories;

import com.ma.blocks.BlockInit;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.gui.GuiTextures;
import com.ma.interop.jei.RecipeCategoryUIDs;
import com.ma.recipes.arcanefurnace.ArcaneFurnaceRecipe;
import com.ma.tools.MATags;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class ArcaneFurnaceRecipeCategory
implements IRecipeCategory<ArcaneFurnaceRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;
    private int xSize = 144;
    private int ySize = 169;

    public ArcaneFurnaceRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(GuiTextures.GUIDEBOOK_RECIPE_ARCANE_FURNACE, 0, 0, this.xSize, this.ySize).setTextureSize(144, 169).build();
        this.localizedName = I18n.func_135052_a((String)"gui.mana-and-artifice.jei.arcane_furnace", (Object[])new Object[0]);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)BlockInit.RUNEFORGE.get()));
    }

    public ResourceLocation getUid() {
        return RecipeCategoryUIDs.ARCANE_FURNACE;
    }

    public Class<? extends ArcaneFurnaceRecipe> getRecipeClass() {
        return ArcaneFurnaceRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(ArcaneFurnaceRecipe recipe, IIngredients ingredients) {
        ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
        inputs.add(Ingredient.func_234819_a_(MATags.smartLookupItem(recipe.getInputItem()).stream().map(i -> new ItemStack((IItemProvider)i))));
        ingredients.setInputIngredients(inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, ArcaneFurnaceRecipe recipe, IIngredients ingredients) {
        int x = 16;
        int y = 45;
        int reagentIdx = 0;
        if (ingredients.getOutputs(VanillaTypes.ITEM).size() > 0) {
            recipeLayout.getItemStacks().init(reagentIdx, true, x, y);
            recipeLayout.getItemStacks().set(reagentIdx, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
            ++reagentIdx;
        }
        if (ingredients.getOutputs(VanillaTypes.ITEM).size() > 0) {
            recipeLayout.getItemStacks().init(reagentIdx, false, 109, y);
            recipeLayout.getItemStacks().set(reagentIdx, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        }
    }

    public void draw(ArcaneFurnaceRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).resolve().get();
    }
}

