/*
 * Decompiled with CFR 0.152.
 */
package com.ma.interop.jei.categories;

import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.recipes.IRitualRecipe;
import com.ma.api.rituals.IRitualReagent;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.gui.GuiTextures;
import com.ma.interop.jei.JEIInterop;
import com.ma.interop.jei.RecipeCategoryUIDs;
import com.ma.interop.jei.ingredients.ManaweavePatternIngredient;
import com.ma.items.ItemInit;
import com.ma.recipes.rituals.RitualRecipe;
import com.ma.tools.MATags;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class RitualRecipeCategory
implements IRecipeCategory<IRitualRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;
    private int xSize = 164;
    private int ySize = 111;

    public RitualRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiTextures.Jei.RITUAL, 0, 0, this.xSize, this.ySize);
        this.localizedName = I18n.func_135052_a((String)"gui.mana-and-artifice.jei.ritual", (Object[])new Object[0]);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ItemInit.RUNE_RITUAL_METAL.get()));
    }

    public ResourceLocation getUid() {
        return RecipeCategoryUIDs.RITUAL;
    }

    public Class<? extends IRitualRecipe> getRecipeClass() {
        return RitualRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(IRitualRecipe recipe, IIngredients ingredients) {
        ArrayList<Ingredient> recipeIngredients = new ArrayList<Ingredient>();
        ArrayList<ManaweavePatternIngredient> patternIngredients = new ArrayList<ManaweavePatternIngredient>();
        IRitualReagent[][] reagents = recipe.getReagents();
        for (int i = 0; i < reagents.length; ++i) {
            for (int j = 0; j < reagents[i].length; ++j) {
                if (reagents[i][j] == null || reagents[i][j].isEmpty() || reagents[i][j].isDynamic()) continue;
                recipeIngredients.add(Ingredient.func_234819_a_(MATags.smartLookupItem(reagents[i][j].getResourceLocation()).stream().map(item -> new ItemStack((IItemProvider)item))));
            }
        }
        for (String rLoc : recipe.getManaweavePatterns()) {
            patternIngredients.add(new ManaweavePatternIngredient(new ResourceLocation(rLoc)));
        }
        ingredients.setInputIngredients(recipeIngredients);
        ingredients.setInputs((IIngredientType)JEIInterop.MANAWEAVE_PATTERN, patternIngredients);
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRitualRecipe recipe, IIngredients ingredients) {
        int xPosOrigin;
        IGuiItemStackGroup stackGroup = recipeLayout.getItemStacks();
        int xc = this.xSize / 2 - 9;
        int yc = this.ySize / 2 - 9;
        int bounds = recipe.getLowerBound();
        int reagentIdx = 0;
        IRitualReagent[][] reagents = recipe.getReagents();
        int xPos = xPosOrigin = xc - 16 * bounds;
        int yPos = yc - 16 * bounds;
        for (int i = 0; i < reagents.length; ++i) {
            xPos = xPosOrigin;
            for (int j = 0; j < reagents[i].length; ++j) {
                if (reagents[i][j] != null && !reagents[i][j].isEmpty() && !reagents[i][j].isDynamic()) {
                    stackGroup.init(reagentIdx, true, xPos, yPos);
                    stackGroup.set(reagentIdx, (List)ingredients.getInputs(VanillaTypes.ITEM).get(reagentIdx));
                    ++reagentIdx;
                }
                xPos += 16;
            }
            yPos += 16;
        }
    }

    public void draw(IRitualRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71466_p != null) {
            int playerTier;
            int tier = recipe.getTier();
            int color = tier <= (playerTier = ((IPlayerProgression)mc.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).resolve().get()).getTier()) ? ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)255, (int)255) : ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)0, (int)0);
            mc.field_71466_p.func_238421_b_(matrixStack, I18n.func_135052_a((String)((RitualRecipe)recipe).func_199560_c().toString(), (Object[])new Object[0]), (float)(this.xSize / 2), 5.0f, color);
        }
    }
}

