/*
 * Decompiled with CFR 0.152.
 */
package com.ma.interop.jei.categories;

import com.ma.blocks.BlockInit;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.gui.GuiTextures;
import com.ma.interop.jei.RecipeCategoryUIDs;
import com.ma.recipes.runeforging.RunescribingRecipe;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class RunescribingRecipeCategory
implements IRecipeCategory<RunescribingRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;
    private int xSize = 144;
    private int ySize = 169;

    public RunescribingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(GuiTextures.GUIDEBOOK_RECIPE_RUNESCRIBING, 0, 0, this.xSize, this.ySize).setTextureSize(144, 169).build();
        this.localizedName = I18n.func_135052_a((String)"gui.mana-and-artifice.jei.runescribing", (Object[])new Object[0]);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)BlockInit.RUNESCRIBING_TABLE.get()));
    }

    public ResourceLocation getUid() {
        return RecipeCategoryUIDs.RUNESCRIBING;
    }

    public Class<? extends RunescribingRecipe> getRecipeClass() {
        return RunescribingRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(RunescribingRecipe recipe, IIngredients ingredients) {
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, RunescribingRecipe recipe, IIngredients ingredients) {
        if (ingredients.getOutputs(VanillaTypes.ITEM).size() > 0) {
            recipeLayout.getItemStacks().init(0, false, this.xSize / 2 - 8, 5);
            recipeLayout.getItemStacks().set(0, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        }
    }

    public void draw(RunescribingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).resolve().get();
        mc.field_71446_o.func_110577_a(GuiTextures.GUIDEBOOK_WIDGETS);
        int startX = 7;
        int startY = 45;
        int grid = 16;
        int count = 0;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 8; ++j) {
                if ((recipe.getHMutex() & 1L << count) != 0L) {
                    AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(startX + j * grid), (int)(startY + i * grid), (float)26.0f, (float)0.0f, (int)grid, (int)1, (int)256, (int)256);
                }
                if ((recipe.getVMutex() & 1L << count) != 0L) {
                    AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(startX + (i + 1) * grid), (int)(startY + (j - 1) * grid), (float)26.0f, (float)0.0f, (int)1, (int)grid, (int)256, (int)256);
                }
                ++count;
            }
        }
    }
}

