/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.armor;

import com.ma.api.items.ManaBatteryItem;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.items.armor.BrokenMageArmor;
import com.ma.items.armor.ISetItem;
import com.ma.tools.RLoc;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableObject;

public class DyeableMageArmor
extends DyeableArmorItem
implements ISetItem {
    private static final ResourceLocation mage_armor_set_bonus = RLoc.create("mage_armor_set_bonus");
    private static final String mage_armor_set_bonus_key = "mage_armor_set_bonus";
    private final float manaPerRepairTick;
    private final float repairPerTick;

    public DyeableMageArmor(IArmorMaterial armorMaterial, EquipmentSlotType slot, Item.Properties properties, float manaPerRepairTick, float repairPerTick) {
        super(armorMaterial, slot, properties);
        this.manaPerRepairTick = manaPerRepairTick;
        this.repairPerTick = repairPerTick;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77951_h() && entityIn instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityIn;
            MutableObject consumedMana = new MutableObject((Object)false);
            Optional<ItemStack> manaCrystal = player.field_71071_by.field_70462_a.stream().filter(i -> i.func_77973_b() instanceof ManaBatteryItem && ((ManaBatteryItem)i.func_77973_b()).getMana((ItemStack)i) > 0.0f).findFirst();
            if (manaCrystal.isPresent() && ((ManaBatteryItem)manaCrystal.get().func_77973_b()).consumeMana(manaCrystal.get(), this.manaPerRepairTick, player)) {
                consumedMana.setValue((Object)true);
            }
            player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                int repairAmount;
                if (!((Boolean)consumedMana.getValue()).booleanValue() && m.getMana() >= this.manaPerRepairTick) {
                    m.consume(this.manaPerRepairTick);
                    consumedMana.setValue((Object)true);
                }
                if (((Boolean)consumedMana.getValue()).booleanValue() && (repairAmount = m.bankArmorRepair(itemSlot, this.repairPerTick)) > 0) {
                    stack.func_222118_a(-repairAmount, (LivingEntity)player, p -> {});
                }
            });
        }
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        int dmg = amount * 5;
        if (stack.func_77952_i() + dmg >= stack.func_77958_k() && entity instanceof LivingEntity) {
            BrokenMageArmor brokenItem = BrokenMageArmor.getBySlot(this.func_185083_B_());
            if (brokenItem == null) {
                return dmg;
            }
            ItemStack brokenStack = brokenItem.convertFrom(stack);
            entity.func_184201_a(this.func_185083_B_(), brokenStack);
            return 0;
        }
        return dmg;
    }

    public int func_200886_f(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_179543_a("display");
        return compoundnbt != null && compoundnbt.func_150297_b("color", 99) ? compoundnbt.func_74762_e("color") : ColorHelper.PackedColor.func_233006_a_((int)255, (int)50, (int)18, (int)51);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ISetItem.super.addSetTooltip(tooltip);
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public ResourceLocation getSetIdentifier() {
        return mage_armor_set_bonus;
    }

    @Override
    public void applySetBonus(LivingEntity living, EquipmentSlotType ... setSlots) {
        if (living instanceof PlayerEntity) {
            ((PlayerEntity)living).getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                m.addMaxManaModifier(mage_armor_set_bonus_key, 50.0f);
                m.addRegenTickModifier(mage_armor_set_bonus_key, -0.25f);
            });
        }
    }

    @Override
    public void removeSetBonus(LivingEntity living, EquipmentSlotType ... setSlots) {
        if (living instanceof PlayerEntity) {
            ((PlayerEntity)living).getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                m.removeMaxManaModifier(mage_armor_set_bonus_key);
                m.removeRegenTickModifier(mage_armor_set_bonus_key);
            });
        }
    }
}

