/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.artifice;

import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.capabilities.IRitualTeleportLocation;
import com.ma.api.capabilities.IWorldMagic;
import com.ma.api.particles.ParticleInit;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.worlddata.WorldMagicProvider;
import com.ma.gui.containers.providers.NamedEnderDisc;
import com.ma.items.IItemWithGui;
import com.ma.items.MAItemGroups;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;

public class ItemEnderDisk
extends Item
implements IItemWithGui<ItemEnderDisk> {
    private static final String KEY_NBT = "ender_disk_data";
    private static final String KEY_COUNT = "count";
    private static final String KEY_ENTRY_PREFIX = "reagent_";

    public ItemEnderDisk() {
        super(new Item.Properties().func_200916_a(MAItemGroups.artifice));
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    @Override
    public INamedContainerProvider getProvider(ItemStack stack) {
        return new NamedEnderDisc();
    }

    private void teleport(World world, PlayerEntity player, ItemStack stack) {
        if (world.field_72995_K) {
            float particle_spread = 1.0f;
            float v = 1.0f;
            int particleCount = 25;
            for (int i = 0; i < particleCount; ++i) {
                Vector3d velocity = new Vector3d(0.0, Math.random() * (double)v, 0.0);
                world.func_195594_a((IParticleData)ParticleInit.ENDER_VELOCITY.get(), (double)player.func_233580_cy_().func_177958_n() + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), (double)player.func_233580_cy_().func_177956_o() + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), (double)player.func_233580_cy_().func_177952_p() + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
            }
            return;
        }
        ArrayList<ResourceLocation> pattern = ItemEnderDisk.getPattern(stack);
        if (pattern.size() == 0) {
            return;
        }
        LazyOptional worldMagicContainer = world.getCapability(WorldMagicProvider.MAGIC);
        if (worldMagicContainer.isPresent()) {
            IRitualTeleportLocation teleportPosition = ((IWorldMagic)worldMagicContainer.orElse(null)).getRitualTeleportBlockLocation(pattern, (RegistryKey<World>)world.func_234923_W_());
            if (teleportPosition == null) {
                return;
            }
            if (!teleportPosition.getWorldType().equals((Object)world.func_234923_W_())) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:rituals/return.wrong_dimension"), Util.field_240973_b_);
                return;
            }
            ((ServerWorld)world).func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, (float)((double)0.7f + Math.random() * (double)0.3f));
            ((ServerWorld)world).func_184133_a(null, teleportPosition.getPos(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, (float)((double)0.7f + Math.random() * (double)0.3f));
            player.func_70634_a((double)((float)teleportPosition.getPos().func_177958_n() + 0.5f), (double)teleportPosition.getPos().func_177984_a().func_177956_o(), (double)((float)teleportPosition.getPos().func_177952_p() + 0.5f));
        }
    }

    public static ArrayList<ResourceLocation> getPattern(ItemStack stack) {
        ArrayList<ResourceLocation> output = new ArrayList<ResourceLocation>(8);
        if (stack == null) {
            return output;
        }
        CompoundNBT nbt = stack.func_179543_a(KEY_NBT);
        if (nbt != null) {
            int count = Math.min(nbt.func_74762_e(KEY_COUNT), 8);
            for (int i = 0; i < count; ++i) {
                output.add(new ResourceLocation(nbt.func_74779_i(KEY_ENTRY_PREFIX + i)));
            }
        }
        while (output.size() < 8) {
            output.add(new ResourceLocation("minecraft:air"));
        }
        return output;
    }

    public static void setPattern(ItemStack stack, List<ResourceLocation> locations) {
        CompoundNBT nbt = stack.func_190925_c(KEY_NBT);
        nbt.func_74768_a(KEY_COUNT, locations.size());
        int count = 0;
        for (ResourceLocation loc : locations) {
            nbt.func_74778_a(KEY_ENTRY_PREFIX + count++, loc.toString());
        }
        stack.func_77978_p().func_218657_a(KEY_NBT, (INBT)nbt);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        IPlayerMagic magic = (IPlayerMagic)playerIn.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (!magic.isMagicUnlocked()) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (!this.openGuiIfModifierPressed(playerIn.func_184586_b(handIn), playerIn, worldIn)) {
            this.teleport(worldIn, playerIn, stack);
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        IPlayerMagic magic = (IPlayerMagic)context.func_195999_j().getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (!magic.isMagicUnlocked()) {
            return ActionResultType.FAIL;
        }
        if (!this.openGuiIfModifierPressed(context.func_195996_i(), context.func_195999_j(), context.func_195991_k())) {
            this.teleport(context.func_195991_k(), context.func_195999_j(), context.func_195996_i());
        }
        return ActionResultType.PASS;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        IItemWithGui.super.addInformation(stack, worldIn, tooltip, flagIn);
    }
}

