/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.manaweaving;

import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.items.IShowHud;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.entities.manaweaving.EntityManaweave;
import com.ma.items.MAItemGroups;
import com.ma.network.ClientMessageDispatcher;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.ma.sound.ItemInUseLoopingSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;

public class ItemManaweaverWand
extends Item
implements IShowHud {
    public static final float MANA_COST_PER_TICK = 1.0f;

    public ItemManaweaverWand() {
        this(new Item.Properties().func_200917_a(1).func_200916_a(MAItemGroups.items));
    }

    public ItemManaweaverWand(Item.Properties props) {
        super(props);
    }

    public boolean canEquip(ItemStack stack, EquipmentSlotType armorType, Entity entity) {
        return armorType == EquipmentSlotType.MAINHAND;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (!(entityLiving instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityLiving;
        if (worldIn.field_72995_K) {
            IPlayerMagic magic = (IPlayerMagic)entityLiving.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
            IPlayerProgression progression = (IPlayerProgression)entityLiving.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
            if (magic != null && progression != null) {
                Vector3f[] points = magic.getRememberedPoints();
                Vector3f[] looks = magic.getRememberedLooks();
                if (points.length > 0) {
                    ManaweavingPattern pattern = ManaweavingPattern.match(worldIn, points, looks);
                    if (pattern == null) {
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.manaweaver_wand.not_recognized"), Util.field_240973_b_);
                    } else {
                        if (pattern.getTier() > progression.getTier()) {
                            player.func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.manaweaver_wand.low_tier"), Util.field_240973_b_);
                            return;
                        }
                        Vector3d eyePos = player.func_213303_ch().func_72441_c(0.0, 1.0, 0.0);
                        Vector3d look = player.func_70040_Z();
                        Vector3d entityPosition = eyePos.func_178787_e(look.func_186678_a(1.5));
                        ClientMessageDispatcher.sendManaweavePatternDrawn(player, pattern.func_199560_c(), entityPosition);
                    }
                }
            }
        }
        player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 20);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        if (worldIn.field_72995_K) {
            LazyOptional magicContainer = playerIn.getCapability(PlayerMagicProvider.MAGIC);
            if (magicContainer.isPresent()) {
                ((IPlayerMagic)magicContainer.orElse(null)).clearRememberedPoints();
            }
            this.PlayLoopingSound(SFX.Loops.MANAWEAVING, playerIn);
        }
        return ActionResult.func_226249_b_((Object)itemstack);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        return ActionResultType.PASS;
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        EntityManaweave mw;
        if (entity instanceof EntityManaweave && !(mw = (EntityManaweave)entity).isMerging()) {
            IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
            if (magic != null) {
                magic.setMana(magic.getMana() + mw.getManaReturn(player));
            }
            player.field_70170_p.func_184133_a(player, player.func_233580_cy_(), SoundEvents.field_187528_aR, SoundCategory.PLAYERS, 1.0f, 1.0f);
            mw.remove(false);
            return false;
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        return 999999;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        LazyOptional magicContainer = player.getCapability(PlayerMagicProvider.MAGIC);
        if (magicContainer.isPresent()) {
            IPlayerMagic magic = (IPlayerMagic)magicContainer.orElse(null);
            if (!magic.isMagicUnlocked() || magic.getMana() < 1.0f) {
                player.func_184597_cx();
                return;
            }
            if (player.field_70170_p.field_72995_K) {
                Vector3d eyePos = player.func_174824_e(0.0f);
                Vector3d look = player.func_70040_Z();
                Vector3d position = eyePos.func_178787_e(look);
                Vector3d particlePosition = eyePos.func_178787_e(look.func_186678_a(1.5));
                ((IPlayerMagic)magicContainer.orElse(null)).addRememberedPoint(new Vector3f(position), new Vector3f(MathHelper.func_76142_g((float)player.field_70177_z), MathHelper.func_76142_g((float)player.field_70125_A), 0.0f));
                player.field_70170_p.func_195594_a((IParticleData)ParticleInit.SPARKLE_STATIONARY.get(), particlePosition.field_72450_a, particlePosition.field_72448_b, particlePosition.field_72449_c, 0.0, 0.0, 0.0);
            }
            magic.consume(1.0f);
        }
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void PlayLoopingSound(SoundEvent soundID, PlayerEntity player) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new ItemInUseLoopingSound(soundID, player));
    }
}

