/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.renderers;

import com.ma.api.affinity.Affinity;
import com.ma.api.particles.ParticleInit;
import com.ma.items.SpellIconList;
import com.ma.items.sorcery.ItemSpell;
import com.ma.spells.crafting.SpellRecipe;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.ForgeHooksClient;

public class ItemSpellRenderer
extends ItemStackTileEntityRenderer {
    private static HashMap<Integer, IBakedModel> bakedSpellModels;
    private IBakedModel defaultSpellModel;
    private final ResourceLocation location = new ResourceLocation("mana-and-artifice", "item/spell_texture");

    public ItemSpellRenderer() {
        if (bakedSpellModels == null) {
            bakedSpellModels = new HashMap();
        }
    }

    public void func_239207_a_(ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (transformType != ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND && transformType != ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
            if (transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
                this.renderArm(matrixStack, buffer, combinedLight, HandSide.RIGHT);
                this.spawnFirstPersonParticlesForStack(stack, HandSide.RIGHT);
            } else if (transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
                this.renderArm(matrixStack, buffer, combinedLight, HandSide.LEFT);
                this.spawnFirstPersonParticlesForStack(stack, HandSide.LEFT);
            } else {
                this.renderDefaultSpellItem(stack, transformType, matrixStack, buffer, combinedLight, combinedOverlay);
            }
        }
    }

    private void renderDefaultSpellItem(ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (!stack.func_190926_b()) {
            IBakedModel spellModel;
            IBakedModel iBakedModel = spellModel = transformType == ItemCameraTransforms.TransformType.GUI ? this.getSpellModel(stack) : this.getDefaultSpellModel();
            if (spellModel.isLayered()) {
                ForgeHooksClient.drawItemLayered((ItemRenderer)Minecraft.func_71410_x().func_175599_af(), (IBakedModel)this.defaultSpellModel, (ItemStack)stack, (MatrixStack)matrixStack, (IRenderTypeBuffer)buffer, (int)combinedLight, (int)combinedOverlay, (boolean)true);
            } else {
                matrixStack.func_227865_b_();
                matrixStack.func_227860_a_();
                RenderHelper.func_227783_c_();
                Minecraft.func_71410_x().func_175599_af().func_229111_a_(stack, transformType, transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, matrixStack, buffer, combinedLight, combinedOverlay, spellModel);
            }
        }
    }

    private IBakedModel getSpellModel(ItemStack stack) {
        IBakedModel customModel;
        int customIconIndex = ItemSpell.getCustomIcon(stack);
        if (customIconIndex < 0 || customIconIndex >= SpellIconList.ALL.length) {
            return this.getDefaultSpellModel();
        }
        if (!bakedSpellModels.containsKey(customIconIndex)) {
            bakedSpellModels.put(customIconIndex, Minecraft.func_71410_x().func_209506_al().getModel(SpellIconList.ALL[customIconIndex]));
        }
        return (customModel = bakedSpellModels.get(customIconIndex)) != null ? customModel : this.getDefaultSpellModel();
    }

    private IBakedModel getDefaultSpellModel() {
        if (this.defaultSpellModel == null) {
            this.defaultSpellModel = Minecraft.func_71410_x().func_209506_al().getModel(this.location);
        }
        return this.defaultSpellModel;
    }

    private void renderArm(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, HandSide side) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(mc.field_71439_g.func_110306_p());
        PlayerRenderer playerrenderer = (PlayerRenderer)mc.func_175598_ae().func_78713_a((Entity)mc.field_71439_g);
        matrixStackIn.func_227860_a_();
        if (side == HandSide.RIGHT) {
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(12.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-35.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(5.0f));
            matrixStackIn.func_227861_a_(1.0, -0.4, 0.8);
            playerrenderer.func_229144_a_(matrixStackIn, bufferIn, combinedLightIn, (AbstractClientPlayerEntity)mc.field_71439_g);
        } else {
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-12.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-35.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(5.0f));
            matrixStackIn.func_227861_a_(0.0, -0.3, 0.6);
            playerrenderer.func_229146_b_(matrixStackIn, bufferIn, combinedLightIn, (AbstractClientPlayerEntity)mc.field_71439_g);
        }
        matrixStackIn.func_227865_b_();
    }

    private void spawnFirstPersonParticlesForStack(ItemStack stack, HandSide hand) {
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemSpell)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        boolean playerIsRightHanded = player.func_184591_cq() == HandSide.RIGHT;
        boolean itemIsInUse = player.func_184605_cv() > 0;
        Hand activeHand = player.func_184600_cs();
        if (!itemIsInUse || playerIsRightHanded && activeHand == Hand.MAIN_HAND && hand == HandSide.LEFT || !playerIsRightHanded && activeHand == Hand.MAIN_HAND && hand == HandSide.RIGHT) {
            Vector3d particlePos = player.func_213303_ch().func_72441_c(0.0, (double)(player.func_70047_e() - 0.2f), 0.0);
            Vector3d look = player.func_70040_Z().func_72432_b().func_186678_a(0.5);
            Vector3d perp = look.func_72431_c(new Vector3d(0.0, 1.0, 0.0)).func_72432_b().func_186678_a(hand == HandSide.LEFT ? (double)-0.4f : (double)0.4f);
            particlePos = particlePos.func_178787_e(look).func_178787_e(perp);
            SpellRecipe recipe = SpellRecipe.fromNBT(((ItemSpell)stack.func_77973_b()).getSpellCompound(stack, (PlayerEntity)player));
            Affinity[] affs = recipe.getAffinity().keySet().toArray(new Affinity[0]);
            switch (affs[(int)(Math.random() * (double)affs.length)]) {
                case ARCANE: {
                    Vector3d origin = new Vector3d(particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c);
                    Vector3d offset = new Vector3d(player.field_70170_p.field_73012_v.nextGaussian(), player.field_70170_p.field_73012_v.nextGaussian(), player.field_70170_p.field_73012_v.nextGaussian()).func_72432_b().func_186678_a((double)0.3f);
                    origin = origin.func_178787_e(offset);
                    player.field_70170_p.func_195594_a((IParticleData)ParticleInit.ARCANE_LERP.get(), origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c);
                    break;
                }
                case EARTH: {
                    player.field_70170_p.func_195594_a((IParticleData)ParticleInit.DUST.get(), particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, (double)-0.005f + Math.random() * (double)0.01f, (double)0.03f, (double)-0.005f + Math.random() * (double)0.01f);
                    break;
                }
                case ENDER: {
                    Vector3d origin = new Vector3d(particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c);
                    Vector3d offset = new Vector3d(player.field_70170_p.field_73012_v.nextGaussian(), player.field_70170_p.field_73012_v.nextGaussian(), player.field_70170_p.field_73012_v.nextGaussian()).func_72432_b().func_186678_a((double)0.3f);
                    origin = origin.func_178787_e(offset);
                    player.field_70170_p.func_195594_a((IParticleData)ParticleInit.ENDER.get(), origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c);
                    break;
                }
                case FIRE: {
                    player.field_70170_p.func_195594_a((IParticleData)ParticleInit.FLAME.get(), particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, 0.0, 0.0, 0.0);
                    break;
                }
                case HELLFIRE: {
                    player.field_70170_p.func_195594_a((IParticleData)ParticleInit.HELLFIRE.get(), particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, 0.0, 0.0, 0.0);
                    break;
                }
                case LIGHTNING: {
                    player.field_70170_p.func_195594_a((IParticleData)ParticleInit.LIGHTNING_BOLT.get(), particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, particlePos.field_72450_a - (double)0.2f + Math.random() * (double)0.4f, particlePos.field_72448_b - (double)0.2f + Math.random() * (double)0.4f, particlePos.field_72449_c - (double)0.2f + Math.random() * (double)0.4f);
                    break;
                }
                case WATER: {
                    player.field_70170_p.func_195594_a((IParticleData)ParticleInit.WATER.get(), particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, -0.05 * Math.random() * 0.1, Math.random() * 0.05, -0.05 * Math.random() * 0.1);
                    break;
                }
                case ICE: {
                    player.field_70170_p.func_195594_a((IParticleData)ParticleInit.FROST.get(), particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, 0.0, 0.0, 0.0);
                    break;
                }
                case WIND: {
                    player.field_70170_p.func_195594_a((IParticleData)ParticleInit.AIR_ORBIT.get(), particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, (double)0.3f, (double)0.01f, (double)0.05f);
                    break;
                }
            }
        }
    }
}

