/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.ritual;

import com.ma.ManaAndArtifice;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.rituals.IRitualReagent;
import com.ma.api.rituals.RitualBlockPos;
import com.ma.api.rituals.RitualEffect;
import com.ma.blocks.BlockInit;
import com.ma.blocks.ritual.BlockChalkRune;
import com.ma.blocks.tileentities.TileEntityChalkRune;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.entities.EntityInit;
import com.ma.entities.rituals.EntityRitual;
import com.ma.gui.containers.providers.NamedRitualKit;
import com.ma.inventory.InventoryRitualKit;
import com.ma.inventory.ItemInventoryBase;
import com.ma.items.ItemBagBase;
import com.ma.items.ItemInit;
import com.ma.items.filters.ItemFilterGroup;
import com.ma.items.ritual.ItemWizardChalk;
import com.ma.recipes.rituals.RitualRecipe;
import com.ma.rituals.MatchedRitual;
import com.ma.rituals.RitualInit;
import com.ma.rituals.RitualReagent;
import com.ma.rituals.contexts.RitualCheckContext;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemRitualKit
extends ItemBagBase {
    private static final String TAG_MASTER = "ritual_kit_data";
    private static final String TAG_RITUAL_RLOC = "ritual_rloc";
    private static final String TAG_RITUAL_POSITION_COUNT = "ritual_position_count";
    private static final String TAG_RITUAL_POSITION_PREFIX = "position_";
    private static final String TAG_RITUAL_REAGENT_COUNT = "ritual_reagent_count";
    private static final String TAG_RITUAL_REAGENT_PREFIX = "reagent_";
    public static final String ID = "mana-and-artifice:ritual_bag";
    public static String NBT_ID = "mana-and-artifice:ritual_bag_data";

    public ItemRitualKit() {
        super(ID);
    }

    @Override
    public ItemInventoryBase getInventory(ItemStack bag, ItemStack stack) {
        if (stack.func_190916_E() > 0 && this.filterGroup().anyMatchesFilter(stack)) {
            return new InventoryRitualKit(bag);
        }
        return null;
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        if (!world.field_72995_K && hand == Hand.MAIN_HAND) {
            this.openGuiIfModifierPressed(player.func_184586_b(hand), player, world);
        }
        return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        ItemStack stack = context.func_195996_i();
        BlockPos pos = context.func_195995_a();
        if (!world.field_72995_K && context.func_221531_n() == Hand.MAIN_HAND && this.openGuiIfModifierPressed(context.func_195996_i(), context.func_195999_j(), context.func_195991_k())) {
            return ActionResultType.SUCCESS;
        }
        IPlayerMagic magic = (IPlayerMagic)context.func_195999_j().getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        IPlayerProgression progression = (IPlayerProgression)context.func_195999_j().getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (!magic.isMagicUnlocked()) {
            return ActionResultType.FAIL;
        }
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == BlockInit.CHALK_RUNE.get() && context.func_195999_j().func_213453_ef()) {
            MatchedRitual ritualMatch = RitualRecipe.matchAnyInWorld(pos, world);
            if (ritualMatch != null) {
                if (!ritualMatch.getRitual().getIsKittable()) {
                    context.func_195999_j().func_145747_a((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.mana-and-artifice.ritual_kit.not_kittable", (Object[])new Object[0])), Util.field_240973_b_);
                } else if (this.setRitual(ritualMatch, world, stack)) {
                    context.func_195999_j().func_145747_a((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.mana-and-artifice.ritual_kit.stored", (Object[])new Object[0])), Util.field_240973_b_);
                } else {
                    context.func_195999_j().func_145747_a((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.mana-and-artifice.ritual_kit.store_failed", (Object[])new Object[0])), Util.field_240973_b_);
                }
            } else {
                context.func_195999_j().func_145747_a((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.mana-and-artifice.ritual_kit.not_found", (Object[])new Object[0])), Util.field_240973_b_);
            }
            return ActionResultType.SUCCESS;
        }
        RitualRecipe ritual = this.getRitual(context.func_195991_k(), stack);
        if (ritual == null) {
            return ActionResultType.SUCCESS;
        }
        if (ritual.getTier() > progression.getTier()) {
            context.func_195999_j().func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:ritual-start-tier-fail"), Util.field_240973_b_);
            return ActionResultType.FAIL;
        }
        int bound = ritual.getLowerBound();
        for (int i = -bound; i <= bound; ++i) {
            for (int j = -bound; j <= bound; ++j) {
                if (!Block.func_220064_c((IBlockReader)world, (BlockPos)pos.func_177982_a(i, 0, j))) {
                    return ActionResultType.PASS;
                }
                if (world.func_175623_d(pos.func_177982_a(i, 1, j))) continue;
                return ActionResultType.PASS;
            }
        }
        if (!this.ritualReagentsPresent(stack) || !this.chalkPresent(stack, ritual.countRunes())) {
            context.func_195999_j().func_145747_a((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.mana-and-artifice.ritual_kit.not_enough_items", (Object[])new Object[0])), Util.field_240973_b_);
            return ActionResultType.PASS;
        }
        RitualEffect matchedEffect = RitualInit.RITUAL_EFFECTS.getValues().stream().filter(r -> r.matchRitual(ritual.func_199560_c())).findFirst().orElse(null);
        if (matchedEffect == null) {
            context.func_195999_j().func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:ritual-start-failed"), Util.field_240973_b_);
            return ActionResultType.FAIL;
        }
        ITextComponent cantStartReason = matchedEffect.canRitualStart(new RitualCheckContext(context.func_195999_j(), (ServerWorld)world, ritual, pos.func_177984_a()));
        if (cantStartReason != null) {
            context.func_195999_j().func_145747_a(cantStartReason, Util.field_240973_b_);
            return ActionResultType.FAIL;
        }
        if (!this.consumeRitualReagents(ritual, stack) || !this.consumeChalk(stack, ritual.countRunes())) {
            ManaAndArtifice.LOGGER.error("Failed to consume ritual reagents from the ritual bag.  This is a bug!");
            return ActionResultType.PASS;
        }
        if (this.placeRitual(stack, pos, world)) {
            this.activateRitual(context.func_195999_j(), ritual, pos.func_177984_a(), world);
        }
        return ActionResultType.SUCCESS;
    }

    private boolean placeRitual(ItemStack stack, BlockPos center, World world) {
        ArrayList out = new ArrayList();
        ArrayList<ItemStack> reagents = this.getReagents(stack);
        ArrayList<BlockPos> positions = this.getReagentLocations(stack);
        ArrayList<BlockPos> rune_positions = this.getRuneLocations(stack);
        if (reagents.size() != positions.size()) {
            return false;
        }
        for (BlockPos runePos : rune_positions) {
            BlockPos pos = center.func_177982_a(runePos.func_177958_n(), 1, runePos.func_177952_p());
            world.func_175656_a(pos, (BlockState)((BlockState)((BlockState)((Block)BlockInit.CHALK_RUNE.get()).func_176223_P().func_206870_a((Property)BlockChalkRune.RUNEINDEX, (Comparable)Integer.valueOf((int)Math.floor(Math.random() * (double)(BlockChalkRune.RUNEINDEX.func_177700_c().size() - 1))))).func_206870_a((Property)BlockChalkRune.METAL, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockChalkRune.ACTIVATED, (Comparable)Boolean.valueOf(true)));
            TileEntityChalkRune rune = (TileEntityChalkRune)world.func_175625_s(pos);
            if (rune == null) {
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                out.clear();
                return false;
            }
            int count = 0;
            for (BlockPos reagent_pos : positions) {
                if (reagent_pos.func_177958_n() == runePos.func_177958_n() && reagent_pos.func_177952_p() == runePos.func_177952_p()) {
                    if (reagents.get(count).func_190926_b()) break;
                    boolean ghost = false;
                    ItemStack runeStack = reagents.get(count).func_77946_l();
                    if (runeStack.func_190925_c("ritual_tags").func_74767_n("noConsumeReagent")) {
                        ghost = true;
                    }
                    runeStack.func_196083_e("ritual_tags");
                    rune.func_70299_a(0, runeStack.func_77946_l());
                    rune.setGhostItem(ghost);
                    break;
                }
                ++count;
            }
            rune.setReadOnly(true);
        }
        return true;
    }

    @Nullable
    protected Entity activateRitual(PlayerEntity caster, RitualRecipe ritual, BlockPos center, World world) {
        NonNullList<RitualBlockPos> matched = ritual.matchInWorld(center, world);
        if (matched == null) {
            return null;
        }
        IPlayerProgression progression = (IPlayerProgression)caster.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        float speed = 1.0f - 0.2f * (float)(progression.getTier() - ritual.getTier());
        Entity ritualEntity = ((EntityType)EntityInit.RITUAL_ENTITY.get()).func_220331_a((ServerWorld)world, null, null, center.func_177984_a(), SpawnReason.SPAWN_EGG, true, true);
        if (ritualEntity != null && ritualEntity instanceof EntityRitual) {
            ((EntityRitual)ritualEntity).setRitualBlockLocations(matched);
            ((EntityRitual)ritualEntity).setSpeed(speed);
            ((EntityRitual)ritualEntity).setRitualName(ritual.func_199560_c());
            ((EntityRitual)ritualEntity).setForceConsumeReagents(true);
            ((EntityRitual)ritualEntity).setCasterUUID(caster.func_110124_au());
            ((EntityRitual)ritualEntity).confirmRitualReagents();
            return ritualEntity;
        }
        return null;
    }

    private boolean ritualReagentsPresent(ItemStack stack) {
        InventoryRitualKit inventory = new InventoryRitualKit(stack);
        ArrayList<ItemStack> reagents = this.getReagents(stack);
        ArrayList<ItemStack> combinedReagents = new ArrayList<ItemStack>();
        for (ItemStack reagent : reagents) {
            boolean found = false;
            for (ItemStack listStack : combinedReagents) {
                if (listStack.func_77973_b() != reagent.func_77973_b()) continue;
                listStack.func_190920_e(listStack.func_190916_E() + 1);
                found = true;
                break;
            }
            if (found) continue;
            combinedReagents.add(reagent.func_77946_l());
        }
        for (ItemStack reagent : combinedReagents) {
            if (inventory.func_213901_a(reagent.func_77973_b()) >= reagent.func_190916_E()) continue;
            return false;
        }
        return true;
    }

    private boolean chalkPresent(ItemStack stack, int requiredUses) {
        InventoryRitualKit inventory = new InventoryRitualKit(stack);
        int foundUses = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i).func_77973_b() != ItemInit.WIZARD_CHALK.get()) continue;
            foundUses += inventory.func_70301_a(i).func_77958_k() - inventory.func_70301_a(i).func_77952_i();
        }
        return foundUses >= requiredUses;
    }

    private boolean consumeChalk(ItemStack stack, int amount) {
        InventoryRitualKit inventory = new InventoryRitualKit(stack);
        int remaining = amount;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack inventoryStack = inventory.func_70301_a(i);
            if (inventoryStack.func_77973_b() != ItemInit.WIZARD_CHALK.get()) continue;
            int uses = inventoryStack.func_77958_k() - inventoryStack.func_77952_i();
            if (uses > remaining) {
                inventoryStack.func_196085_b(inventoryStack.func_77952_i() + remaining);
                inventory.func_70299_a(i, inventoryStack);
                remaining = 0;
                break;
            }
            if (uses == remaining) {
                inventory.func_70304_b(i);
                remaining = 0;
                break;
            }
            remaining -= uses;
            inventory.func_70304_b(i);
        }
        inventory.writeItemStack();
        return remaining == 0;
    }

    private boolean consumeRitualReagents(RitualRecipe recipe, ItemStack stack) {
        InventoryRitualKit inventory = new InventoryRitualKit(stack);
        ArrayList<ItemStack> reagents = this.getReagents(stack);
        RitualReagent[] allreagents = recipe.AllReagents();
        int count = 0;
        block0: for (ItemStack reagent : reagents) {
            if (!allreagents[count].shouldConsumeReagent()) continue;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                if (inventory.func_70301_a(i).func_77973_b() != reagent.func_77973_b()) continue;
                inventory.func_70298_a(i, 1);
                continue block0;
            }
        }
        inventory.writeItemStack();
        return true;
    }

    @Nullable
    private RitualRecipe getRitual(World world, ItemStack stack) {
        ResourceLocation rLoc = new ResourceLocation(this.getRitualRLoc(stack));
        return RitualRecipe.find(world, rLoc);
    }

    private String getRitualRLoc(ItemStack stack) {
        CompoundNBT compound = stack.func_190925_c(TAG_MASTER);
        if (compound == null || !compound.func_74764_b(TAG_RITUAL_RLOC)) {
            return "";
        }
        return compound.func_74779_i(TAG_RITUAL_RLOC);
    }

    private ArrayList<ItemStack> getReagents(ItemStack stack) {
        ArrayList<ItemStack> out = new ArrayList<ItemStack>();
        CompoundNBT nbt = stack.func_190925_c(TAG_MASTER);
        if (nbt == null || !nbt.func_74764_b(TAG_RITUAL_REAGENT_COUNT)) {
            return out;
        }
        int count = nbt.func_74762_e(TAG_RITUAL_REAGENT_COUNT);
        for (int i = 0; i < count; ++i) {
            if (!nbt.func_74764_b(TAG_RITUAL_REAGENT_PREFIX + i)) {
                out.clear();
                return out;
            }
            CompoundNBT reagent_data = nbt.func_74775_l(TAG_RITUAL_REAGENT_PREFIX + i);
            ItemStack reagent = ItemStack.func_199557_a((CompoundNBT)reagent_data);
            if (reagent == null) {
                out.clear();
                return out;
            }
            out.add(reagent);
        }
        return out;
    }

    private ArrayList<BlockPos> getReagentLocations(ItemStack stack) {
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        CompoundNBT nbt = stack.func_190925_c(TAG_MASTER);
        if (nbt == null || !nbt.func_74764_b(TAG_RITUAL_REAGENT_COUNT)) {
            return out;
        }
        int count = nbt.func_74762_e(TAG_RITUAL_REAGENT_COUNT);
        for (int i = 0; i < count; ++i) {
            if (!nbt.func_74764_b(TAG_RITUAL_REAGENT_PREFIX + i)) {
                out.clear();
                return out;
            }
            CompoundNBT reagent_data = nbt.func_74775_l(TAG_RITUAL_REAGENT_PREFIX + i);
            if (!(reagent_data.func_74764_b("x") && reagent_data.func_74764_b("y") && reagent_data.func_74764_b("z"))) {
                out.clear();
                return out;
            }
            out.add(new BlockPos(reagent_data.func_74762_e("x"), reagent_data.func_74762_e("y"), reagent_data.func_74762_e("z")));
        }
        return out;
    }

    private ArrayList<BlockPos> getRuneLocations(ItemStack stack) {
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        CompoundNBT nbt = stack.func_190925_c(TAG_MASTER);
        if (nbt == null || !nbt.func_74764_b(TAG_RITUAL_POSITION_COUNT)) {
            return out;
        }
        int count = nbt.func_74762_e(TAG_RITUAL_POSITION_COUNT);
        for (int i = 0; i < count; ++i) {
            if (!nbt.func_74764_b(TAG_RITUAL_POSITION_PREFIX + i)) {
                out.clear();
                return out;
            }
            CompoundNBT position_data = nbt.func_74775_l(TAG_RITUAL_POSITION_PREFIX + i);
            if (!(position_data.func_74764_b("x") && position_data.func_74764_b("y") && position_data.func_74764_b("z"))) {
                out.clear();
                return out;
            }
            out.add(new BlockPos(position_data.func_74762_e("x"), position_data.func_74762_e("y"), position_data.func_74762_e("z")));
        }
        return out;
    }

    private boolean setRitual(MatchedRitual match, World world, ItemStack stack) {
        int i;
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a(TAG_RITUAL_RLOC, match.getRitual().func_199560_c().toString());
        ArrayList<ItemStack> reagents = new ArrayList<ItemStack>();
        ArrayList<BlockPos> reagent_positions = new ArrayList<BlockPos>();
        ArrayList<BlockPos> rune_positions = new ArrayList<BlockPos>();
        for (RitualBlockPos rbp : match.getPositions()) {
            BlockPos pos = rbp.getBlockPos().func_177973_b((Vector3i)match.getCenter());
            rune_positions.add(pos);
            IRitualReagent reagent = rbp.getReagent();
            if (reagent == null || reagent.isEmpty()) continue;
            TileEntityChalkRune tecr = (TileEntityChalkRune)world.func_175625_s(match.getCenter().func_177982_a(pos.func_177958_n(), 0, pos.func_177952_p()));
            if (tecr == null) {
                return false;
            }
            ItemStack tecrStack = tecr.func_70301_a(0);
            if (tecrStack.func_190926_b()) {
                if (reagent.isOptional()) continue;
                return false;
            }
            tecrStack.func_190925_c("ritual_tags").func_74757_a("noConsumeReagent", !reagent.shouldConsumeReagent());
            reagents.add(tecrStack);
            reagent_positions.add(new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p()));
        }
        compound.func_74768_a(TAG_RITUAL_POSITION_COUNT, rune_positions.size());
        for (i = 0; i < rune_positions.size(); ++i) {
            CompoundNBT positionData = new CompoundNBT();
            positionData.func_74768_a("x", ((BlockPos)rune_positions.get(i)).func_177958_n());
            positionData.func_74768_a("y", ((BlockPos)rune_positions.get(i)).func_177956_o());
            positionData.func_74768_a("z", ((BlockPos)rune_positions.get(i)).func_177952_p());
            compound.func_218657_a(TAG_RITUAL_POSITION_PREFIX + i, (INBT)positionData);
        }
        compound.func_74768_a(TAG_RITUAL_REAGENT_COUNT, reagents.size());
        for (i = 0; i < reagents.size(); ++i) {
            CompoundNBT reagentData = new CompoundNBT();
            reagentData.func_74768_a("x", ((BlockPos)reagent_positions.get(i)).func_177958_n());
            reagentData.func_74768_a("y", ((BlockPos)reagent_positions.get(i)).func_177956_o());
            reagentData.func_74768_a("z", ((BlockPos)reagent_positions.get(i)).func_177952_p());
            ((ItemStack)reagents.get(i)).func_77955_b(reagentData);
            compound.func_218657_a(TAG_RITUAL_REAGENT_PREFIX + i, (INBT)reagentData);
        }
        ITextComponent baseDisplayName = new ItemStack((IItemProvider)stack.func_77973_b()).func_200301_q();
        IFormattableTextComponent stc = new StringTextComponent("").func_230529_a_(baseDisplayName).func_240702_b_(": ");
        stc = stc.func_230529_a_((ITextComponent)new TranslationTextComponent(match.getRitual().func_199560_c().toString())).func_240699_a_(TextFormatting.GOLD);
        stack.func_200302_a((ITextComponent)stc);
        stack.func_196083_e(TAG_MASTER);
        stack.func_196082_o().func_218657_a(TAG_MASTER, (INBT)compound);
        return true;
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        RitualRecipe ritual = this.getRitual(worldIn, stack);
        if (ritual == null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.ritual_kit.no_ritual_stored"));
        } else {
            ArrayList<ItemStack> reagents = this.getReagents(stack);
            InventoryRitualKit irk = new InventoryRitualKit(stack);
            ArrayList<ItemStack> combinedReagents = new ArrayList<ItemStack>();
            tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.ritual_kit.reagents"));
            for (ItemStack reagent : reagents) {
                boolean found = false;
                for (ItemStack listStack : combinedReagents) {
                    if (listStack.func_77973_b() != reagent.func_77973_b()) continue;
                    listStack.func_190920_e(listStack.func_190916_E() + 1);
                    found = true;
                    break;
                }
                if (found) continue;
                combinedReagents.add(reagent.func_77946_l());
            }
            if (this.chalkPresent(stack, ritual.countRunes())) {
                tooltip.add((ITextComponent)new TranslationTextComponent(((ItemWizardChalk)ItemInit.WIZARD_CHALK.get()).func_77658_a()).func_240699_a_(TextFormatting.GREEN));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent(((ItemWizardChalk)ItemInit.WIZARD_CHALK.get()).func_77658_a()).func_240699_a_(TextFormatting.RED));
            }
            for (ItemStack listStack : combinedReagents) {
                if (listStack.func_190926_b()) continue;
                if (irk.func_213901_a(listStack.func_77973_b()) >= listStack.func_190916_E()) {
                    tooltip.add((ITextComponent)new TranslationTextComponent(listStack.func_77973_b().func_77658_a()).func_240699_a_(TextFormatting.GREEN));
                    continue;
                }
                tooltip.add((ITextComponent)new TranslationTextComponent(listStack.func_77973_b().func_77658_a()).func_240699_a_(TextFormatting.RED));
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public ItemFilterGroup filterGroup() {
        return ItemFilterGroup.ALL_ITEMS;
    }

    @Override
    public INamedContainerProvider getProvider(ItemStack stack) {
        return new NamedRitualKit(stack);
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (nbt != null && nbt.func_74764_b(NBT_ID)) {
            stack.func_77982_d(nbt);
        }
        return null;
    }
}

