/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.ritual;

import com.ma.items.MAItemGroups;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemThaumaturgicLink
extends Item {
    private static final String NBT_RECIPEID = "linked_position";
    private static ArrayList<ResourceLocation> all_locations;

    public ItemThaumaturgicLink() {
        super(new Item.Properties().func_200916_a(MAItemGroups.thaumaturgy));
    }

    private ArrayList<ResourceLocation> getAllLocations() {
        if (all_locations == null) {
            all_locations = new ArrayList();
            ForgeRegistries.STRUCTURE_FEATURES.getValues().forEach(s -> all_locations.add(s.getRegistryName()));
            ForgeRegistries.BIOMES.getValues().forEach(b -> all_locations.add(b.getRegistryName()));
        }
        return all_locations;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack stack;
            for (Structure structure : ForgeRegistries.STRUCTURE_FEATURES.getValues()) {
                stack = new ItemStack((IItemProvider)this);
                ItemThaumaturgicLink.setLocationKey(stack, structure);
                items.add((Object)stack);
            }
            for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
                stack = new ItemStack((IItemProvider)this);
                ItemThaumaturgicLink.setLocationKey(stack, biome);
                items.add((Object)stack);
            }
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ResourceLocation recipe = this.getLocationKey(stack, worldIn);
        if (recipe == null) {
            return;
        }
        tooltip.add((ITextComponent)new TranslationTextComponent(recipe.toString()));
    }

    public ItemStack func_190903_i() {
        ItemStack stack = new ItemStack((IItemProvider)this);
        if (ForgeRegistries.STRUCTURE_FEATURES.getValues().size() > 0) {
            ItemThaumaturgicLink.setLocationKey(stack, (Structure)ForgeRegistries.STRUCTURE_FEATURES.getValues().iterator().next());
        }
        return stack;
    }

    @Nullable
    public ResourceLocation getLocationKey(ItemStack stack, World world) {
        if (!stack.func_77942_o() || stack.func_77973_b() != this) {
            return null;
        }
        CompoundNBT nbt = stack.func_77978_p();
        if (!nbt.func_74764_b(NBT_RECIPEID)) {
            return null;
        }
        ResourceLocation rLoc = new ResourceLocation(nbt.func_74781_a(NBT_RECIPEID).func_150285_a_());
        return rLoc;
    }

    public static void setLocationKey(ItemStack stack, Structure<?> recipe) {
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74778_a(NBT_RECIPEID, recipe.getRegistryName().toString());
    }

    public static void setLocationKey(ItemStack stack, Biome biome) {
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74778_a(NBT_RECIPEID, biome.getRegistryName().toString());
    }

    public ItemStack getRandomLink() {
        ItemStack output = new ItemStack((IItemProvider)this);
        output.func_196082_o().func_74778_a(NBT_RECIPEID, this.getAllLocations().get((int)(Math.random() * (double)this.getAllLocations().size())).toString());
        return output;
    }
}

