/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.ritual;

import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.items.MAItemGroups;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public class ItemWorldCharm
extends Item {
    private static final String KEY_WORLD_TARGET_REGISTRY_NAME = "world_key_type";
    private static final String KEY_WORLD_TARGET_LOCATION = "world_key_value";

    public ItemWorldCharm() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(MAItemGroups.items));
    }

    public boolean SetWorldTarget(PlayerEntity entity, ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        LazyOptional magic = entity.getCapability(PlayerMagicProvider.MAGIC);
        if (magic.isPresent()) {
            nbt.func_74778_a(KEY_WORLD_TARGET_REGISTRY_NAME, entity.field_70170_p.func_234923_W_().getRegistryName().toString());
            nbt.func_74778_a(KEY_WORLD_TARGET_LOCATION, entity.field_70170_p.func_234923_W_().func_240901_a_().toString());
            return true;
        }
        return false;
    }

    @Nullable
    public RegistryKey<World> GetWorldTarget(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b(KEY_WORLD_TARGET_REGISTRY_NAME) || !nbt.func_74764_b(KEY_WORLD_TARGET_LOCATION)) {
            return null;
        }
        ResourceLocation registryName = new ResourceLocation(nbt.func_74779_i(KEY_WORLD_TARGET_REGISTRY_NAME));
        ResourceLocation location = new ResourceLocation(nbt.func_74779_i(KEY_WORLD_TARGET_LOCATION));
        return new RegistryKey(registryName, location);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new CompoundNBT();
            }
            if (!nbt.func_74764_b(KEY_WORLD_TARGET_REGISTRY_NAME) && !nbt.func_74764_b(KEY_WORLD_TARGET_LOCATION)) {
                this.SetWorldTarget(playerIn, stack);
                playerIn.func_145747_a((ITextComponent)new StringTextComponent("You've attuned this to the current world!"), Util.field_240973_b_);
            } else {
                playerIn.func_145747_a((ITextComponent)new StringTextComponent("This is already attuned somewhere else."), Util.field_240973_b_);
            }
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b(KEY_WORLD_TARGET_LOCATION)) {
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.mana-and-artifice.world_charm.not_attuned", (Object[])new Object[0])));
            return;
        }
        ResourceLocation worldLocation = new ResourceLocation(nbt.func_74779_i(KEY_WORLD_TARGET_LOCATION));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.world_charm.attuned", new Object[]{worldLocation.toString()}));
    }
}

