/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.runes;

import com.ma.api.capabilities.IPlayerMagic;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.items.ItemInit;
import com.ma.items.runes.ItemRune;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemRuneMarking
extends ItemRune {
    public int getItemStackLimit(ItemStack stack) {
        return this.getLocation(stack) == null ? 64 : 1;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        IPlayerMagic magic = (IPlayerMagic)context.func_195999_j().getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (!magic.isMagicUnlocked() || context.func_221531_n() == Hand.OFF_HAND) {
            return ActionResultType.FAIL;
        }
        ItemStack stack = context.func_195996_i();
        boolean didSplit = false;
        if (stack.func_190916_E() > 1) {
            stack.func_190918_g(1);
            stack = new ItemStack((IItemProvider)ItemInit.RUNE_MARKING.get());
            didSplit = true;
        }
        this.setLocation(stack, context.func_195995_a(), context.func_196000_l(), context.func_195991_k());
        if (didSplit) {
            context.func_195999_j().func_191521_c(stack);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        BlockPos pos = this.getLocation(stack);
        if (pos != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.rune_marking.setPosition", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}));
            TranslationTextComponent block = (TranslationTextComponent)this.getBlockName(stack);
            if (block != null) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.rune_marking.blockWhenSet", new Object[]{block.getString()}).func_240699_a_(TextFormatting.GOLD));
            }
            Direction face = this.getFace(stack);
            tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.rune_marking.face", new Object[]{face.toString()}).func_240699_a_(TextFormatting.GOLD));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.rune_marking.noPosition"));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.getLocation(stack) != null;
    }

    private void setLocation(ItemStack stack, BlockPos pos, Direction face, World world) {
        CompoundNBT nbt = stack.func_190925_c("mark");
        nbt.func_74768_a("x", pos.func_177958_n());
        nbt.func_74768_a("y", pos.func_177956_o());
        nbt.func_74768_a("z", pos.func_177952_p());
        nbt.func_74768_a("face", face.func_176745_a());
        nbt.func_74778_a("block", new ItemStack((IItemProvider)world.func_180495_p(pos).func_177230_c()).func_77977_a());
    }

    @Nullable
    public BlockPos getLocation(ItemStack stack) {
        CompoundNBT nbt = stack.func_190925_c("mark");
        if (nbt.func_74764_b("x") && nbt.func_74764_b("y") && nbt.func_74764_b("z")) {
            return new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
        }
        return null;
    }

    public Direction getFace(ItemStack stack) {
        CompoundNBT nbt = stack.func_190925_c("mark");
        if (nbt.func_74764_b("face")) {
            return Direction.func_82600_a((int)nbt.func_74762_e("face"));
        }
        return Direction.DOWN;
    }

    @Nullable
    public ITextComponent getBlockName(ItemStack stack) {
        CompoundNBT nbt = stack.func_190925_c("mark");
        if (nbt.func_74764_b("block")) {
            return new TranslationTextComponent(nbt.func_74779_i("block"));
        }
        return null;
    }
}

