/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.sorcery;

import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.capabilities.IPlayerRoteSpells;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellComponent;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.parts.Shape;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.rote.PlayerRoteSpellsProvider;
import com.ma.gui.containers.providers.NamedRoteBook;
import com.ma.items.sorcery.ISpellBookInventory;
import com.ma.items.sorcery.ItemSpellBook;
import com.ma.spells.crafting.ModifiedSpellPart;
import com.ma.spells.crafting.SpellRecipe;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemBookOfRote
extends ItemSpellBook {
    @Override
    public INamedContainerProvider getProvider(ItemStack stack) {
        return new NamedRoteBook();
    }

    @Override
    public ISpellBookInventory getInventory(ItemStack item, IPlayerMagic magic) {
        if (magic == null) {
            return null;
        }
        return magic.getRoteInventory();
    }

    @Override
    public CompoundNBT getSpellCompound(ItemStack stack, PlayerEntity player) {
        if (player == null) {
            return new CompoundNBT();
        }
        IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (magic == null) {
            return new CompoundNBT();
        }
        ItemStack selectedStack = magic.getRoteInventory().func_70301_a(ItemBookOfRote.getActiveSpellSlot(stack));
        return selectedStack.func_190925_c("spell");
    }

    @Override
    public int func_77626_a(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("cur_spell_use_duration")) {
            return tag.func_74762_e("cur_spell_use_duration");
        }
        return 9999;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!world.field_72995_K) {
            ItemStack held = player.func_184586_b(hand);
            IPlayerRoteSpells rote = (IPlayerRoteSpells)player.getCapability(PlayerRoteSpellsProvider.ROTE).orElse(null);
            if (rote == null) {
                return ActionResult.func_226251_d_((Object)held);
            }
            ItemStack bookStack = player.func_184586_b(hand);
            ItemStack selectedStack = this.getSelectedStack(bookStack, player);
            SpellRecipe recipe = SpellRecipe.fromNBT(selectedStack.func_190925_c("spell"));
            if (recipe.isValid() && !player.func_225608_bj_()) {
                if (!player.func_184812_l_()) {
                    if (!rote.isRote((ISpellComponent)((ModifiedSpellPart)recipe.getShape()).getPart())) {
                        String shapeName = new TranslationTextComponent(((Shape)((ModifiedSpellPart)recipe.getShape()).getPart()).getRegistryName().toString()).getString();
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.book_of_rote.part_not_rote", new Object[]{shapeName}), Util.field_240973_b_);
                        return ActionResult.func_226251_d_((Object)held);
                    }
                    for (IModifiedSpellPart<Component> component : recipe.getComponents()) {
                        if (rote.isRote(component.getPart())) continue;
                        String componentName = new TranslationTextComponent(component.getPart().getRegistryName().toString()).getString();
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.book_of_rote.part_not_rote", new Object[]{componentName}), Util.field_240973_b_);
                        return ActionResult.func_226251_d_((Object)held);
                    }
                }
                CompoundNBT bookTag = bookStack.func_196082_o();
                bookTag.func_74768_a("cur_spell_use_duration", recipe.getMaxChannelTime());
                bookStack.func_77982_d(bookTag);
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    @Override
    protected ItemStack getSelectedStack(ItemStack bookStack, @Nullable PlayerEntity player) {
        Inventory bookInv;
        if (bookStack.func_77973_b() instanceof ItemSpellBook && (bookInv = (Inventory)this.getInventory(bookStack, player != null ? (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null) : null)) != null) {
            ItemStack selectedStack = bookInv.func_70301_a(ItemBookOfRote.getActiveSpellSlot(bookStack));
            return selectedStack;
        }
        return ItemStack.field_190927_a;
    }
}

