/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.sorcery;

import com.ma.api.items.IShowHud;
import com.ma.api.particles.ParticleInit;
import com.ma.items.MAItemGroups;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemCrystalOfMemories
extends Item
implements IShowHud {
    private static final String KEY_MODE = "memory_crystal_fragment_mode";
    private static final int MODE_INFUSE = 0;
    private static final int MODE_SUPPLEMENT = 1;

    public ItemCrystalOfMemories() {
        super(new Item.Properties().func_200918_c(20000).setNoRepair().func_200916_a(MAItemGroups.items));
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        return ActionResultType.PASS;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        return 100;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return true;
    }

    public void onUsingTick(ItemStack stack, LivingEntity living, int count) {
        if (living instanceof PlayerEntity) {
            PlayerEntity p = (PlayerEntity)living;
            switch (this.getMode(stack)) {
                case 1: {
                    if (stack.func_77952_i() >= stack.func_77958_k() - 1) {
                        return;
                    }
                    int xp = Math.max(p.field_71068_ca, 1);
                    if (stack.func_77952_i() + xp >= stack.func_77958_k()) {
                        xp = stack.func_77958_k() - stack.func_77952_i() - 1;
                    }
                    p.func_195068_e(xp);
                    stack.func_222118_a(xp, (LivingEntity)p, entity -> {});
                    break;
                }
                default: {
                    int xp;
                    if (stack.func_77952_i() == 0) {
                        return;
                    }
                    int n = xp = p.field_71068_ca == 0 ? p.field_71067_cb : p.field_71068_ca;
                    if (stack.func_77952_i() < xp) {
                        xp = stack.func_77952_i();
                    }
                    p.func_195068_e(-xp);
                    stack.func_222118_a(-xp, (LivingEntity)p, entity -> {});
                }
            }
        }
        if (living.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                living.field_70170_p.func_195594_a((IParticleData)ParticleInit.BLUE_SPARKLE_GRAVITY.get(), living.func_226277_ct_() - 0.5 + Math.random(), living.func_226278_cu_() + Math.random(), living.func_226281_cx_() - 0.5 + Math.random(), 0.0, (double)0.1f, 0.0);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_225608_bj_()) {
            if (!worldIn.field_72995_K) {
                if (this.getMode(stack) == 0) {
                    this.setMode(stack, 1);
                } else {
                    this.setMode(stack, 0);
                }
            }
            return ActionResult.func_226248_a_((Object)stack);
        }
        playerIn.func_184598_c(handIn);
        return ActionResult.func_226249_b_((Object)stack);
    }

    public int getMode(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(KEY_MODE)) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e(KEY_MODE);
    }

    private void setMode(ItemStack stack, int mode) {
        stack.func_196082_o().func_74768_a(KEY_MODE, mode);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77952_i() == 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.crystal_of_memories.full", new Object[]{stack.func_77958_k()}).func_240699_a_(TextFormatting.ITALIC));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.crystal_of_memories.contains", new Object[]{stack.func_77958_k() - stack.func_77952_i(), stack.func_77958_k()}).func_240699_a_(TextFormatting.ITALIC));
        }
        switch (this.getMode(stack)) {
            case 1: {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.crystal_of_memories.supplement"));
                break;
            }
            default: {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.crystal_of_memories.infusion"));
            }
        }
    }
}

