/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.sorcery;

import com.ma.Registries;
import com.ma.api.spells.parts.Modifier;
import com.ma.items.MAItemGroups;
import com.ma.recipes.RecipeInit;
import com.ma.recipes.spells.ModifierRecipe;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemModifierBook
extends Item {
    public static final String NBT_MODIFIER_ID = "key_modifier";

    public ItemModifierBook() {
        super(new Item.Properties().func_200916_a(MAItemGroups.items));
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ItemModifierBook.getModifier(stack).ifPresent(m -> tooltip.add((ITextComponent)new TranslationTextComponent(m.getRegistryName().toString()).func_240699_a_(TextFormatting.AQUA)));
    }

    @Nullable
    public static final Optional<Modifier> getModifier(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(NBT_MODIFIER_ID)) {
            return Optional.empty();
        }
        ResourceLocation rLoc = new ResourceLocation(stack.func_77978_p().func_74779_i(NBT_MODIFIER_ID));
        return Optional.ofNullable(Registries.Modifier.getValue(rLoc));
    }

    public static final Optional<ModifierRecipe> getRecipe(Modifier modifier, World world) {
        return world.func_199532_z().func_241447_a_(RecipeInit.MODIFIER_TYPE).stream().filter(m -> m.getComponent() == modifier).findFirst();
    }

    public static final void setModifier(ItemStack stack, ResourceLocation modifierRloc) {
        stack.func_196082_o().func_74778_a(NBT_MODIFIER_ID, modifierRloc.toString());
    }
}

