/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.sorcery;

import com.ma.api.items.IShowHud;
import com.ma.api.spells.SpellCastingResult;
import com.ma.api.spells.SpellCastingResultCode;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.parts.Shape;
import com.ma.effects.EffectInit;
import com.ma.gui.containers.providers.NamedSpellAdjust;
import com.ma.gui.containers.providers.NamedSpellCustomization;
import com.ma.items.ItemInit;
import com.ma.items.renderers.ItemSpellRenderer;
import com.ma.items.sorcery.ItemSpellRecipe;
import com.ma.spells.SpellCaster;
import com.ma.spells.crafting.ModifiedSpellPart;
import com.ma.spells.crafting.SpellRecipe;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class ItemSpell
extends ItemSpellRecipe
implements IShowHud {
    public ItemSpell() {
        this(new Item.Properties().func_200917_a(1).setISTER(() -> ItemSpellRenderer::new).func_208103_a(Rarity.EPIC));
    }

    public ItemSpell(Item.Properties properties) {
        super(properties);
    }

    public static final void castSpellOnChannelTick(ItemStack stack, PlayerEntity player, int itemInUseCount, BiPredicate<PlayerEntity, ItemStack> consumeChanneledMana) {
        if (itemInUseCount == 0 || !consumeChanneledMana.test(player, stack) || player.func_70644_a((Effect)EffectInit.SILENCE.get())) {
            player.func_184597_cx();
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        if (entityLiving instanceof PlayerEntity) {
            ((PlayerEntity)entityLiving).func_184597_cx();
        }
        return stack;
    }

    public static final ActionResult<ItemStack> castSpellOnUse(ItemStack spellStack, World world, PlayerEntity player, Hand hand, Function<ItemStack, Boolean> consumeMana) {
        if (!SpellRecipe.stackContainsSpell(spellStack)) {
            return ActionResult.func_226250_c_((Object)spellStack);
        }
        player.func_184609_a(hand);
        SpellCastingResult result = SpellCaster.PlayerCast(spellStack, player, player.func_213303_ch().func_72441_c(0.0, (double)player.func_70047_e(), 0.0), player.func_70040_Z(), world, consumeMana.apply(spellStack));
        if (result.getCode() == SpellCastingResultCode.CHANNEL) {
            player.func_184598_c(hand);
            if (consumeMana.apply(spellStack).booleanValue()) {
                player.func_195064_c(new EffectInstance((Effect)EffectInit.MANA_STUNT.get(), spellStack.func_77988_m(), 5));
            }
            return ActionResult.func_226248_a_((Object)spellStack);
        }
        if (result.getCode() == SpellCastingResultCode.SUCCESS) {
            ItemSpell.setCooldown(player, spellStack);
            return ActionResult.func_226248_a_((Object)spellStack);
        }
        ItemSpell.setCooldown(player, spellStack);
        return ActionResult.func_226251_d_((Object)spellStack);
    }

    public static final ActionResultType castSpellOnRightClickEntity(ItemStack spellStack, World world, PlayerEntity player, Hand hand, Function<ItemStack, Boolean> consumeMana) {
        return ItemSpell.castSpellOnUse(spellStack, world, player, hand, consumeMana).func_188397_a();
    }

    protected boolean shouldConsumeMana(ItemStack stack) {
        return true;
    }

    protected boolean consumeChanneledMana(PlayerEntity player, ItemStack stack) {
        return SpellCaster.consumeChanneledMana(player, stack);
    }

    protected static final void setCooldown(PlayerEntity player, ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemSpellRecipe) {
            ItemSpellRecipe item = (ItemSpellRecipe)stack.func_77973_b();
            SpellRecipe recipe = SpellRecipe.fromNBT(item.getSpellCompound(stack, player));
            SpellCaster.setCooldown(stack.func_77973_b(), player, (int)(recipe.getComplexity() / 4.0f));
        }
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        return ActionResultType.PASS;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == ItemInit.SPELL.get() && ItemSpell.getCustomIcon(itemstack) == -1) {
            if (!world.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new NamedSpellCustomization());
            }
            return ActionResult.func_226248_a_((Object)itemstack);
        }
        if (this.openGuiIfModifierPressed(player.func_184586_b(hand), player, world)) {
            return ActionResult.func_226248_a_((Object)itemstack);
        }
        return ItemSpell.castSpellOnUse(itemstack, world, player, hand, this::shouldConsumeMana);
    }

    @Override
    public INamedContainerProvider getProvider(ItemStack stack) {
        return new NamedSpellAdjust();
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        return ItemSpell.castSpellOnRightClickEntity(stack, playerIn.field_70170_p, playerIn, hand, this::shouldConsumeMana);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (player instanceof PlayerEntity) {
            ItemSpell.castSpellOnChannelTick(stack, (PlayerEntity)player, count, this::consumeChanneledMana);
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            SpellRecipe recipe = SpellRecipe.fromNBT(this.getSpellCompound(stack, player));
            ItemSpell.setCooldown(player, stack);
            if (this.shouldConsumeMana(stack)) {
                if (entityLiving.func_70644_a((Effect)EffectInit.MANA_STUNT.get()) && entityLiving.func_70660_b((Effect)EffectInit.MANA_STUNT.get()).func_76458_c() == 5) {
                    entityLiving.func_195063_d((Effect)EffectInit.MANA_STUNT.get());
                }
                SpellCaster.AddAffinityAndMagicXP(recipe, player, recipe.getMaxChannelTime() - timeLeft);
            }
        }
    }

    public boolean canEquip(ItemStack stack, EquipmentSlotType armorType, Entity entity) {
        return armorType == EquipmentSlotType.MAINHAND || armorType == EquipmentSlotType.OFFHAND;
    }

    public int func_77626_a(ItemStack stack) {
        SpellRecipe recipe = SpellRecipe.fromNBT(stack.func_190925_c("spell"));
        return recipe.getMaxChannelTime();
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return true;
    }

    @Override
    protected ITextComponent getTranslatedDisplayName(SpellRecipe recipe) {
        if (recipe.isMysterious()) {
            return new TranslationTextComponent("item.mana-and-artifice.spell.mysterious");
        }
        TranslationTextComponent shape = new TranslationTextComponent(((Shape)((ModifiedSpellPart)recipe.getShape()).getPart()).getRegistryName().toString());
        StringBuilder sb = new StringBuilder();
        recipe.iterateComponents(c -> {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(new TranslationTextComponent(((Component)c.getPart()).getRegistryName().toString()).getString());
        });
        TranslationTextComponent base = new TranslationTextComponent("item.mana-and-artifice.spell.display_name", new Object[]{shape.getString(), sb.toString()});
        return base;
    }

    public boolean isShield(ItemStack stack, LivingEntity entity) {
        return false;
    }

    public static void setCustomIcon(ItemStack stack, int index) {
        stack.func_196082_o().func_74768_a("icon", index);
    }

    public static int getCustomIcon(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("icon")) {
            return tag.func_74762_e("icon");
        }
        return -1;
    }

    @Override
    public boolean requiresModifierKey() {
        return true;
    }
}

