/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.sorcery;

import com.ma.ManaAndArtifice;
import com.ma.api.spells.SpellReagent;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.parts.Shape;
import com.ma.gui.containers.providers.NamedSpellRecipe;
import com.ma.items.IItemWithGui;
import com.ma.spells.NameProcessors;
import com.ma.spells.SpellAdjuster;
import com.ma.spells.SpellCaster;
import com.ma.spells.crafting.ModifiedSpellPart;
import com.ma.spells.crafting.SpellRecipe;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemSpellRecipe
extends Item
implements IItemWithGui<ItemSpellRecipe> {
    public ItemSpellRecipe(Item.Properties properties) {
        super(properties);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    @Override
    public INamedContainerProvider getProvider(ItemStack stack) {
        return new NamedSpellRecipe();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack heldStack = playerIn.func_184586_b(handIn);
        if (heldStack.func_77973_b() == this && this.openGuiIfModifierPressed(heldStack, playerIn, worldIn)) {
            return ActionResult.func_226248_a_((Object)heldStack);
        }
        return ActionResult.func_226251_d_((Object)heldStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        ArrayList<ITextComponent> flavorText = this.getFlavorText(stack);
        if (flavorText != null) {
            tooltip.addAll(flavorText);
        }
        SpellRecipe recipe = SpellRecipe.fromNBT(this.getSpellCompound(stack, (PlayerEntity)mc.field_71439_g));
        String displayName = stack.func_200301_q().getString();
        if (recipe.isValid() && !recipe.isMysterious()) {
            SpellCaster.applyAdjusters(stack, (PlayerEntity)mc.field_71439_g, recipe, SpellAdjuster.SpellCastStage.SPELL_TOOLTIP);
            NameProcessors.checkAndAddDisplay(recipe, displayName, tooltip);
            if (Screen.func_231173_s_()) {
                IModifiedSpellPart shape = recipe.getShape();
                if (shape != null) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.spell.shape_attributes").func_240699_a_(TextFormatting.GREEN));
                    for (AttributeValuePair attr : ((Shape)((ModifiedSpellPart)shape).getPart()).getModifiableAttributes()) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.spell.attribute_display", new Object[]{attr.getAttribute().name(), Float.valueOf(((ModifiedSpellPart)shape).getValue(attr.getAttribute()))}).func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
                    }
                }
                tooltip.add((ITextComponent)new StringTextComponent(" "));
                recipe.iterateComponents(component -> {
                    tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.spell.component_attributes").func_240699_a_(TextFormatting.GREEN));
                    for (AttributeValuePair attr : ((Component)component.getPart()).getModifiableAttributes()) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.spell.attribute_display", new Object[]{attr.getAttribute().name(), Float.valueOf(component.getValue(attr.getAttribute()))}).func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
                    }
                });
                tooltip.add((ITextComponent)new StringTextComponent(" "));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.spell.shift_prompt").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
            }
            if (recipe.getReagents(ManaAndArtifice.instance.proxy.getClientPlayer(), null).size() > 0) {
                if (Screen.func_231174_t_()) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.spell.required_reagents").func_240699_a_(TextFormatting.GOLD));
                    for (SpellReagent reagent : recipe.getReagents(ManaAndArtifice.instance.proxy.getClientPlayer(), null)) {
                        tooltip.add((ITextComponent)new StringTextComponent(String.format("%d x ", reagent.getReagentStack().func_190916_E())).func_230529_a_(reagent.getReagentStack().func_200301_q()));
                    }
                    tooltip.add((ITextComponent)new StringTextComponent(" "));
                } else {
                    tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.spell.alt_prompt").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
                }
            }
            if (recipe.isChanneled()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.spell.channeled_mana_cost_display", new Object[]{String.format("%.2f", Float.valueOf(recipe.getManaCost() * 20.0f))}).func_240699_a_(TextFormatting.GOLD));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.spell.mana_cost_display", new Object[]{String.format("%.2f", Float.valueOf(recipe.getManaCost()))}).func_240699_a_(TextFormatting.GOLD));
            }
            tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.spell.complexity_display", new Object[]{Float.valueOf(recipe.getComplexity())}).func_240699_a_(TextFormatting.GOLD));
        }
        IItemWithGui.super.addInformation(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public boolean requiresModifierKey() {
        return false;
    }

    @Nullable
    protected ArrayList<ITextComponent> getFlavorText(ItemStack stack) {
        return null;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        SpellRecipe recipe = SpellRecipe.fromNBT(this.getSpellCompound(stack, null));
        if (recipe.isValid()) {
            return this.getTranslatedDisplayName(recipe);
        }
        return super.func_200295_i(stack);
    }

    protected ITextComponent getTranslatedDisplayName(SpellRecipe recipe) {
        StringBuilder sb = new StringBuilder();
        recipe.iterateComponents(c -> {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(new TranslationTextComponent(((Component)c.getPart()).getRegistryName().toString()).getString());
        });
        return new TranslationTextComponent("item.mana-and-artifice.spell.recipe_display_name", new Object[]{new TranslationTextComponent(((Shape)((ModifiedSpellPart)recipe.getShape()).getPart()).getRegistryName().toString()).getString(), sb.toString()});
    }

    public boolean func_77651_p() {
        return true;
    }

    public CompoundNBT getSpellCompound(ItemStack stack, @Nullable PlayerEntity player) {
        return stack.func_190925_c("spell");
    }
}

