/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.sorcery;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.ma.Registries;
import com.ma.api.items.ItemUtils;
import com.ma.api.spells.SpellReagent;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.parts.Shape;
import com.ma.items.ItemInit;
import com.ma.items.MAItemGroups;
import com.ma.items.sorcery.ItemSpell;
import com.ma.spells.crafting.ModifiedSpellPart;
import com.ma.spells.crafting.SpellRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemStaff
extends ItemSpell {
    private static final String KEY_CHARGES = "charges";
    protected float attackDamage = 4.5f;
    private final int enchantability = 25;
    private static int charge_modifier = 40;
    private final ArrayList<Enchantment> allowedEnchantments = new ArrayList();
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public ItemStaff(float attackDamage) {
        super(new Item.Properties().func_200915_b(100).func_200916_a(MAItemGroups.artifice).func_200918_c(100).setNoRepair());
        this.allowedEnchantments.clear();
        this.allowedEnchantments.add(Enchantments.field_180312_n);
        this.allowedEnchantments.add(Enchantments.field_77334_n);
        this.allowedEnchantments.add(Enchantments.field_180313_o);
        this.allowedEnchantments.add(Enchantments.field_185304_p);
        this.allowedEnchantments.add(Enchantments.field_185303_l);
        this.attackDamage = attackDamage;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -3.0, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    @Override
    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack activeStack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && !this.shouldConsumeMana(activeStack)) {
            this.consumeCharge(activeStack, playerIn, handIn);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public int getMaxDamage(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return super.getMaxDamage(stack);
        }
        CompoundNBT tag = stack.func_77978_p();
        if (!tag.func_74764_b(KEY_CHARGES)) {
            return super.getMaxDamage(stack);
        }
        return tag.func_74762_e(KEY_CHARGES);
    }

    @Override
    protected boolean shouldConsumeMana(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return true;
        }
        return !stack.func_77978_p().func_74764_b(KEY_CHARGES);
    }

    @Override
    protected boolean consumeChanneledMana(PlayerEntity player, ItemStack stack) {
        if (this.shouldConsumeMana(stack)) {
            return super.consumeChanneledMana(player, stack);
        }
        this.consumeCharge(stack, player, player.func_184600_cs());
        return true;
    }

    protected void consumeCharge(ItemStack spellStack, PlayerEntity player, Hand handIn) {
        if (player.func_184812_l_()) {
            return;
        }
        SpellRecipe recipe = SpellRecipe.fromNBT(spellStack.func_196082_o());
        if (!recipe.isValid()) {
            return;
        }
        int chargeConsumed = (int)Math.ceil(recipe.getManaCost());
        if (!recipe.isChanneled()) {
            chargeConsumed *= charge_modifier;
        }
        int charges = ItemUtils.getCharges(spellStack) - chargeConsumed;
        int maxCharges = Math.max(ItemUtils.getMaxCharges(spellStack), 1);
        ItemUtils.writeCharges(spellStack, charges);
        float damagePct = 1.0f - (float)charges / (float)maxCharges;
        int newDamage = (int)((float)spellStack.func_77958_k() * damagePct);
        if (charges <= 0) {
            player.func_213334_d(handIn);
            Item item = spellStack.func_77973_b();
            spellStack.func_190918_g(1);
            player.func_71029_a(Stats.field_199088_e.func_199076_b((Object)item));
            spellStack.func_196085_b(0);
        } else {
            spellStack.func_196085_b(newDamage);
        }
    }

    @Override
    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    @Override
    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return slot == EquipmentSlotType.MAINHAND ? this.attributeModifiers : super.getAttributeModifiers(slot, stack);
    }

    public int getItemEnchantability(ItemStack stack) {
        return 25;
    }

    @Override
    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)book);
        for (Enchantment ench : enchantments.keySet()) {
            if (this.allowedEnchantments.contains(ench)) continue;
            return false;
        }
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return this.allowedEnchantments.contains(enchantment);
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        SpellRecipe recipe = SpellRecipe.fromNBT(stack.func_196082_o());
        if (recipe != null) {
            int charges;
            int chargeConsumed = (int)Math.ceil(recipe.getManaCost());
            if (!recipe.isChanneled()) {
                chargeConsumed *= charge_modifier;
            }
            if ((charges = (int)Math.ceil((float)ItemUtils.getCharges(stack) / Math.max((float)chargeConsumed, 1.0f))) > 0) {
                IFormattableTextComponent comp = new TranslationTextComponent("item.mana-and-artifice.spell.charges_display", new Object[]{charges}).func_240699_a_(TextFormatting.AQUA);
                tooltip.add((ITextComponent)comp);
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public static ItemStack buildRandomSpellStaff() {
        Random random = new Random();
        Item[] items = new Item[]{(Item)ItemInit.STAFF_A.get(), (Item)ItemInit.STAFF_B.get(), (Item)ItemInit.STAFF_C.get(), (Item)ItemInit.WAND.get()};
        Item item = items[random.nextInt(items.length)];
        ItemStack stack = new ItemStack((IItemProvider)item);
        SpellRecipe randomRecipe = new SpellRecipe();
        randomRecipe.setShape(ItemStaff.getRandom(Registries.Shape.getValues()).orElse(null));
        int count = (int)(Math.random() * 4.0) + 1;
        for (int i = 0; i < count; ++i) {
            Component c2 = ItemStaff.getRandom(Registries.Component.getValues().stream().filter(comp -> {
                List<SpellReagent> reagents = comp.getRequiredReagents(null);
                return reagents == null || reagents.size() == 0;
            }).collect(Collectors.toList())).orElse(null);
            if (c2 == null || ((Shape)((ModifiedSpellPart)randomRecipe.getShape()).getPart()).isChanneled() && !c2.canBeChanneled()) continue;
            randomRecipe.addComponent(c2);
        }
        if (randomRecipe.getComponents().size() == 0) {
            return stack;
        }
        int modifiers = (int)(3.0 * Math.random());
        for (int i = 0; i < modifiers; ++i) {
            randomRecipe.setModifier(ItemStaff.getRandom(Registries.Modifier.getValues().stream().filter(m -> {
                ImmutableList<com.ma.api.spells.attributes.Attribute> shapeAttrs = ((ModifiedSpellPart)randomRecipe.getShape()).getContainedAttributes();
                ImmutableList<com.ma.api.spells.attributes.Attribute> componentAttrs = ((ModifiedSpellPart)randomRecipe.getShape()).getContainedAttributes();
                return !Collections.disjoint(shapeAttrs, m.getModifiedAttributes()) || !Collections.disjoint(componentAttrs, m.getModifiedAttributes());
            }).collect(Collectors.toList())).orElse(null), i);
        }
        for (com.ma.api.spells.attributes.Attribute attr : ((ModifiedSpellPart)randomRecipe.getShape()).getContainedAttributes()) {
            if (!randomRecipe.isAttributeModifiable(attr)) continue;
            ((ModifiedSpellPart)randomRecipe.getShape()).setValue(attr, ((ModifiedSpellPart)randomRecipe.getShape()).getMinimumValue(attr) + (((ModifiedSpellPart)randomRecipe.getShape()).getMaximumValue(attr) - ((ModifiedSpellPart)randomRecipe.getShape()).getMinimumValue(attr)) * (float)Math.random());
        }
        randomRecipe.iterateComponents(c -> {
            for (com.ma.api.spells.attributes.Attribute attr : c.getContainedAttributes()) {
                if (!randomRecipe.isAttributeModifiable(attr)) continue;
                c.setValue(attr, c.getMinimumValue(attr) + (c.getMaximumValue(attr) - c.getMinimumValue(attr)) * (float)Math.random());
            }
        });
        randomRecipe.setMysterious(true);
        randomRecipe.writeToNBT(stack.func_196082_o());
        int charges = (int)(20.0f * randomRecipe.getManaCost()) + (int)(Math.random() * (double)(randomRecipe.getManaCost() * 180.0f));
        ItemUtils.writeCharges(stack, charges *= charge_modifier);
        ItemUtils.writeMaxCharges(stack, charges);
        return stack;
    }

    private static <T> Optional<T> getRandom(Collection<T> collection) {
        if (collection == null) {
            return Optional.empty();
        }
        return collection.stream().skip((int)((double)collection.size() * Math.random())).findFirst();
    }
}

