/*
 * Decompiled with CFR 0.152.
 */
package com.ma.loot.modifiers;

import com.google.gson.JsonObject;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.items.ItemInit;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class OreDropChimeriteModifier
extends LootModifier {
    private final int numChimerite;
    private final int magicLevel;
    private final float chance;
    private final ResourceLocation dropsWith;

    public OreDropChimeriteModifier(ILootCondition[] conditions, int numChimerite, int magicLevel, float chance, ResourceLocation dropsWith) {
        super(conditions);
        this.numChimerite = numChimerite;
        this.magicLevel = magicLevel;
        this.chance = chance;
        this.dropsWith = dropsWith;
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        IPlayerMagic magic;
        if (!generatedLoot.stream().filter(i -> i.func_77973_b().getRegistryName().compareTo(this.dropsWith) == 0).findFirst().isPresent()) {
            return generatedLoot;
        }
        Entity e = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        if (e instanceof PlayerEntity && (magic = (IPlayerMagic)((PlayerEntity)e).getCapability(PlayerMagicProvider.MAGIC).orElse(null)) != null && magic.getMagicLevel() >= this.magicLevel && Math.random() <= (double)this.chance) {
            generatedLoot.add(new ItemStack((IItemProvider)ItemInit.CHIMERITE_GEM.get(), (int)Math.ceil(Math.random() * (double)this.numChimerite)));
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<OreDropChimeriteModifier> {
        public OreDropChimeriteModifier read(ResourceLocation location, JsonObject object, ILootCondition[] ailootcondition) {
            int numChimerite = JSONUtils.func_151203_m((JsonObject)object, (String)"numChimerite");
            int magicLevel = JSONUtils.func_151203_m((JsonObject)object, (String)"magicLevel");
            float chance = JSONUtils.func_151217_k((JsonObject)object, (String)"chance");
            ResourceLocation dropWith = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"dropsWith"));
            return new OreDropChimeriteModifier(ailootcondition, numChimerite, magicLevel, chance, dropWith);
        }

        public JsonObject write(OreDropChimeriteModifier instance) {
            JsonObject obj = new JsonObject();
            obj.addProperty("numChimerite", (Number)instance.numChimerite);
            obj.addProperty("magicLevel", (Number)instance.magicLevel);
            obj.addProperty("chance", (Number)Float.valueOf(instance.chance));
            obj.addProperty("dropsWith", instance.dropsWith.toString());
            return obj;
        }
    }
}

