/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network;

import com.ma.api.capabilities.IPlayerMagic;
import com.ma.blocks.tileentities.ITileEntityUUID;
import com.ma.blocks.tileentities.TileEntityInscriptionTable;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.capabilities.playerdata.rote.PlayerRoteSpellsProvider;
import com.ma.entities.IAnimPacketSync;
import com.ma.network.MAPacketHandler;
import com.ma.network.messages.to_client.CantripCastingTimerMessage;
import com.ma.network.messages.to_client.EntityStateMessage;
import com.ma.network.messages.to_client.MagicSyncMessageToClient;
import com.ma.network.messages.to_client.ProgressionSyncMessageToClient;
import com.ma.network.messages.to_client.RoteProgressSyncMessageToClient;
import com.ma.network.messages.to_client.SetLiftPositionMessage;
import com.ma.network.messages.to_client.SetRitualCollectedReagentsMessage;
import com.ma.network.messages.to_client.SpawnParticleMessage;
import com.ma.network.messages.to_client.TileEntitySetUUIDMessage;
import com.ma.network.messages.to_server.InscriptionTableCraftingUpdateMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;

public class ServerMessageDispatcher {
    public static void sendMagicSyncMessage(ServerPlayerEntity player) {
        LazyOptional magic = player.getCapability(PlayerMagicProvider.MAGIC);
        if (!magic.isPresent()) {
            return;
        }
        MAPacketHandler.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)MagicSyncMessageToClient.fromCapability((IPlayerMagic)magic.orElse(null)));
    }

    public static void sendEntityStateMessage(IAnimPacketSync<?> entity) {
        MAPacketHandler.network.send(PacketDistributor.TRACKING_ENTITY.with(() -> (Entity)entity), (Object)EntityStateMessage.fromEntity(entity));
    }

    public static void sendEntityStateMessage(IAnimPacketSync<?> entity, ServerPlayerEntity player) {
        MAPacketHandler.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)EntityStateMessage.fromEntity(entity));
    }

    public static void sendProgressionSyncMessage(ServerPlayerEntity player) {
        player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> MAPacketHandler.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)ProgressionSyncMessageToClient.fromCapability(p)));
    }

    public static void sendRoteSyncMessage(ServerPlayerEntity player) {
        player.getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(r -> MAPacketHandler.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)RoteProgressSyncMessageToClient.fromCapability(r)));
    }

    public static void sendInscriptionTableCraftingUpdate(TileEntityInscriptionTable te) {
        ServerWorld world = (ServerWorld)te.func_145831_w();
        BlockPos pos = te.func_174877_v();
        MAPacketHandler.network.send(PacketDistributor.TRACKING_CHUNK.with(() -> (Chunk)world.func_217349_x(pos)), (Object)InscriptionTableCraftingUpdateMessage.fromInscriptionTable(te));
    }

    public static void sendTileEntityUUID(ITileEntityUUID te) {
        ServerWorld world = (ServerWorld)((TileEntity)te).func_145831_w();
        BlockPos pos = ((TileEntity)te).func_174877_v();
        MAPacketHandler.network.send(PacketDistributor.TRACKING_CHUNK.with(() -> (Chunk)world.func_217349_x(pos)), (Object)new TileEntitySetUUIDMessage(pos, te.getUUID()));
    }

    public static void sendRitualReagentData(CompoundNBT ritualReagentData, int entityID, ServerWorld world, BlockPos pos) {
        MAPacketHandler.network.send(PacketDistributor.TRACKING_CHUNK.with(() -> (Chunk)world.func_217349_x(pos)), (Object)new SetRitualCollectedReagentsMessage(ritualReagentData, entityID));
    }

    public static void sendParticleSpawn(double x, double y, double z, double vX, double vY, double vZ, float radius, RegistryKey<World> dimension, BasicParticleType type) {
        SpawnParticleMessage msg = new SpawnParticleMessage(x, y, z, vX, vY, vZ, type);
        MAPacketHandler.network.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(x, y, z, (double)radius, dimension)), (Object)msg);
    }

    public static void sendSetLiftPosition(double x, double y, double z, ServerPlayerEntity player) {
        SetLiftPositionMessage msg = new SetLiftPositionMessage(x, y, z);
        MAPacketHandler.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)msg);
    }

    public static void sendCantripTimerMessage(String id, int ticks, int chevrons, ServerPlayerEntity player) {
        CantripCastingTimerMessage msg = new CantripCastingTimerMessage(id, ticks, chevrons);
        MAPacketHandler.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)msg);
    }
}

