/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.handlers;

import com.ma.ManaAndArtifice;
import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.blocks.tileentities.ITileEntityUUID;
import com.ma.blocks.tileentities.TileEntityInscriptionTable;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.capabilities.playerdata.rote.PlayerRoteSpellsProvider;
import com.ma.entities.IAnimPacketSync;
import com.ma.entities.rituals.EntityRitual;
import com.ma.gui.HUDOverlayRenderer;
import com.ma.network.messages.BaseMessage;
import com.ma.network.messages.to_client.CantripCastingTimerMessage;
import com.ma.network.messages.to_client.EntityStateMessage;
import com.ma.network.messages.to_client.MagicSyncMessageToClient;
import com.ma.network.messages.to_client.ProgressionSyncMessageToClient;
import com.ma.network.messages.to_client.RoteProgressSyncMessageToClient;
import com.ma.network.messages.to_client.SetLiftPositionMessage;
import com.ma.network.messages.to_client.SetRitualCollectedReagentsMessage;
import com.ma.network.messages.to_client.SpawnParticleMessage;
import com.ma.network.messages.to_client.TileEntitySetUUIDMessage;
import com.ma.network.messages.to_server.InscriptionTableCraftingUpdateMessage;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientMessageHandler {
    private static <T extends BaseMessage> boolean validateBasics(T message, NetworkEvent.Context ctx) {
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived != LogicalSide.CLIENT) {
            ManaAndArtifice.LOGGER.error(message.getClass().getName() + " received on wrong side: " + sideReceived);
            return false;
        }
        if (!message.isMessageValid()) {
            ManaAndArtifice.LOGGER.error(message.getClass().getName() + " was invalid: " + message);
            return false;
        }
        return true;
    }

    public static void handleMagicSyncMessage(MagicSyncMessageToClient message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("MagicSyncMessageToClient context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> ClientMessageHandler.processMagicSyncMessage((ClientWorld)clientWorld.get(), message));
    }

    public static void handleEntityStateMessage(EntityStateMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("MagicSyncMessageToClient context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> ClientMessageHandler.processEntityStateMessage((ClientWorld)clientWorld.get(), message));
    }

    public static void handleProgressionSyncMessage(ProgressionSyncMessageToClient message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("ProgressionSyncMessageToClient context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> ClientMessageHandler.processProgressionSyncMessage((ClientWorld)clientWorld.get(), message));
    }

    public static void handleRoteSyncMessage(RoteProgressSyncMessageToClient message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("ProgressionSyncMessageToClient context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> ClientMessageHandler.processRoteSyncMessage((ClientWorld)clientWorld.get(), message));
    }

    public static void handleSetTileEntityUUID(TileEntitySetUUIDMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("MagicSyncMessageToClient context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> ClientMessageHandler.processSetTileEntityUUID((ClientWorld)clientWorld.get(), message));
    }

    public static void handleInscriptionTableCraftingUpdate(InscriptionTableCraftingUpdateMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("MagicSyncMessageToClient context could not provide a ClientWorld");
            return;
        }
        TileEntityInscriptionTable.handleCraftingUpdate((World)clientWorld.get(), message);
    }

    public static void handleSpawnParticleMessage(SpawnParticleMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("SpawnParticleMessage context could not provide a ClientWorld");
            return;
        }
        ParticleType resolvedType = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(message.getType());
        if (resolvedType == null) {
            return;
        }
        ((ClientWorld)clientWorld.get()).func_195594_a((IParticleData)((BasicParticleType)resolvedType), (double)message.getPosition().x, (double)message.getPosition().y, (double)message.getPosition().z, (double)message.getSpeed().x, (double)message.getSpeed().y, (double)message.getSpeed().z);
    }

    public static void handleSetLiftPositionMessage(SetLiftPositionMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        LazyOptional magicCap = mc.field_71439_g.getCapability(PlayerMagicProvider.MAGIC);
        if (!magicCap.isPresent()) {
            return;
        }
        IPlayerMagic magicProperties = (IPlayerMagic)magicCap.orElse(null);
        if (magicProperties == null) {
            return;
        }
        magicProperties.setLiftPosition(message.getPosition());
    }

    public static void handleSetRitualReagentData(SetRitualCollectedReagentsMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        Entity e = mc.field_71439_g.field_70170_p.func_73045_a(message.getEntityID());
        if (e != null && e instanceof EntityRitual) {
            ((EntityRitual)e).readCollectedReagents(message.getData().func_150295_c("data", 10));
        }
    }

    public static void handleCantripCastingTimerMessage(CantripCastingTimerMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        HUDOverlayRenderer.instance.setCastingCantrip(message.getCantripId(), message.getTicks(), message.getChevrons());
    }

    private static void processMagicSyncMessage(ClientWorld worldClient, MagicSyncMessageToClient message) {
        int i;
        Minecraft mc = Minecraft.func_71410_x();
        LazyOptional magicCap = mc.field_71439_g.getCapability(PlayerMagicProvider.MAGIC);
        if (!magicCap.isPresent()) {
            return;
        }
        IPlayerMagic magicProperties = (IPlayerMagic)magicCap.orElse(null);
        if (magicProperties == null) {
            return;
        }
        magicProperties.setMagicLevel(message.getLevel());
        magicProperties.clearMaxManaModifiers();
        message.getMaxManaModifiers().forEach((k, v) -> magicProperties.addMaxManaModifier((String)k, v.floatValue()));
        magicProperties.clearRegenTickModifiers();
        message.getRegenTickModifiers().forEach((k, v) -> magicProperties.addRegenTickModifier((String)k, v.floatValue()));
        magicProperties.setMana(message.getMana());
        magicProperties.setMagicXP(message.getXP());
        for (i = 0; i < Math.min(message.getAffinities().length, Affinity.values().length); ++i) {
            magicProperties.setAffinityDepth(Affinity.values()[i], message.getAffinities()[i]);
        }
        if (message.getSyncGrimoire()) {
            magicProperties.getGrimoireInventory().func_174888_l();
            for (i = 0; i < message.getGrimoireInventory().size(); ++i) {
                magicProperties.getGrimoireInventory().func_70299_a(i, (ItemStack)message.getGrimoireInventory().get(i));
            }
            magicProperties.getRoteInventory().func_174888_l();
            for (i = 0; i < message.getRoteInventory().size(); ++i) {
                magicProperties.getRoteInventory().func_70299_a(i, (ItemStack)message.getRoteInventory().get(i));
            }
        }
        if (message.getSyncCantrips()) {
            magicProperties.getCantripData().readFromNBT(message.getCantripData());
        }
    }

    private static void processProgressionSyncMessage(ClientWorld worldClient, ProgressionSyncMessageToClient message) {
        Minecraft mc = Minecraft.func_71410_x();
        IPlayerProgression progressionProperties = (IPlayerProgression)mc.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (progressionProperties == null) {
            return;
        }
        progressionProperties.setTier(message.getTier(), null);
        progressionProperties.setFactionStanding(message.getFactionStanding());
        progressionProperties.setAlliedFaction(message.getFaction());
        progressionProperties.setTierProgression(message.getCompletedProgressionSteps());
    }

    private static void processSetTileEntityUUID(ClientWorld worldClient, TileEntitySetUUIDMessage message) {
        TileEntity te = worldClient.func_175625_s(message.getPosition());
        if (te != null && te instanceof ITileEntityUUID) {
            ((ITileEntityUUID)te).setUUID(message.getUUID());
        }
    }

    private static void processEntityStateMessage(ClientWorld clientWorld, EntityStateMessage message) {
        Entity entity = clientWorld.func_73045_a(message.getEntityID());
        if (entity != null && entity instanceof IAnimPacketSync) {
            ((IAnimPacketSync)entity).handlePacketData(message.getData());
        }
    }

    private static void processRoteSyncMessage(ClientWorld worldClient, RoteProgressSyncMessageToClient message) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71439_g.getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(r -> {
            for (Map.Entry<ResourceLocation, Integer> e : message.getRoteProgress().entrySet()) {
                r.setRoteXP(e.getKey(), e.getValue());
            }
        });
    }
}

