/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.handlers;

import com.ma.ManaAndArtifice;
import com.ma.api.recipes.IManaweavePattern;
import com.ma.blocks.tileentities.ITileEntityUUID;
import com.ma.blocks.tileentities.TileEntityArcaneSentry;
import com.ma.blocks.tileentities.TileEntityInscriptionTable;
import com.ma.blocks.tileentities.TileEntityLodestar;
import com.ma.blocks.tileentities.TileEntityRunescribingTable;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.enchantments.EnchantmentInit;
import com.ma.entities.EntityInit;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.entities.manaweaving.EntityManaweave;
import com.ma.events.EventDispatcher;
import com.ma.gui.containers.providers.NamedSpellCustomization;
import com.ma.items.ItemInit;
import com.ma.items.artifice.ItemEnderDisk;
import com.ma.items.sorcery.ItemModifierBook;
import com.ma.items.sorcery.ItemSpell;
import com.ma.items.sorcery.ItemSpellBook;
import com.ma.network.ServerMessageDispatcher;
import com.ma.network.messages.BaseMessage;
import com.ma.network.messages.to_server.AnimatedConstructSyncRequestMessage;
import com.ma.network.messages.to_server.ArcaneSentryTargetPlayersMessage;
import com.ma.network.messages.to_server.CantripPatternUpdateMessage;
import com.ma.network.messages.to_server.EnderDiscPatternSetMessage;
import com.ma.network.messages.to_server.InscriptionTableAttributeChangeMessage;
import com.ma.network.messages.to_server.InscriptionTableRequestStartCraftingMessage;
import com.ma.network.messages.to_server.InscriptionTableSetComponentMessage;
import com.ma.network.messages.to_server.InscriptionTableSetModifierMessage;
import com.ma.network.messages.to_server.InscriptionTableSetShapeMessage;
import com.ma.network.messages.to_server.LodestarGUIActionMessage;
import com.ma.network.messages.to_server.ManaweavePatternDrawnMessage;
import com.ma.network.messages.to_server.OpenSpellRenameMessage;
import com.ma.network.messages.to_server.PlayerBounceMessage;
import com.ma.network.messages.to_server.PlayerJumpMessage;
import com.ma.network.messages.to_server.RoteSpellsSyncMessageToServer;
import com.ma.network.messages.to_server.RunescribingTableMutexChangeMessage;
import com.ma.network.messages.to_server.SelectedModifierMessage;
import com.ma.network.messages.to_server.SpellAdjustmentsMessage;
import com.ma.network.messages.to_server.SpellBookSlotChangeMessage;
import com.ma.network.messages.to_server.SpellNameAndIconMessage;
import com.ma.network.messages.to_server.TileEntityRequestUUIDMessage;
import com.ma.network.messages.to_server.UIModifierPress;
import com.ma.spells.crafting.SpellRecipe;
import java.util.function.Supplier;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class ServerMessageHandler {
    private static <T extends BaseMessage> boolean validateBasics(T message, NetworkEvent.Context ctx) {
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived != LogicalSide.SERVER) {
            ManaAndArtifice.LOGGER.error(message.getClass().getName() + " received on wrong side: " + sideReceived);
            return false;
        }
        if (!message.isMessageValid()) {
            ManaAndArtifice.LOGGER.error(message.getClass().getName() + " was invalid: " + message);
            return false;
        }
        return true;
    }

    public static void handleUIModifierPress(UIModifierPress message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when SpellCastMessageToServer was received");
        }
        ctx.enqueueWork(() -> sendingPlayer.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.setModifierPressed(message.getPressed())));
    }

    public static void handleInscriptionTableShapeSet(InscriptionTableSetShapeMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when SpellCastMessageToServer was received");
        }
        ctx.enqueueWork(() -> TileEntityInscriptionTable.handleShapeSet(sendingPlayer, message));
    }

    public static void handleInscriptionTableComponentSet(InscriptionTableSetComponentMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when SpellCastMessageToServer was received");
        }
        ctx.enqueueWork(() -> TileEntityInscriptionTable.handleComponentSet(sendingPlayer, message));
    }

    public static void handleInscriptionTableModifierSet(InscriptionTableSetModifierMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when SpellCastMessageToServer was received");
        }
        ctx.enqueueWork(() -> TileEntityInscriptionTable.handleModifierSet(sendingPlayer, message));
    }

    public static void handleInscriptionTableAttributeChange(InscriptionTableAttributeChangeMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when SpellCastMessageToServer was received");
        }
        ctx.enqueueWork(() -> TileEntityInscriptionTable.handleAttributeValueChange(sendingPlayer, message));
    }

    public static void handleInscriptionTableStartCrafting(InscriptionTableRequestStartCraftingMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when SpellCastMessageToServer was received");
        }
        ctx.enqueueWork(() -> TileEntityInscriptionTable.handleRequestStartCrafting(sendingPlayer, message));
    }

    public static void handleTileEntityRequestUUID(TileEntityRequestUUIDMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when SpellCastMessageToServer was received");
        }
        ctx.enqueueWork(() -> {
            if (!sendingPlayer.field_70170_p.func_195588_v(message.getPosition())) {
                return;
            }
            TileEntity te = sendingPlayer.field_70170_p.func_175625_s(message.getPosition());
            if (te != null && te instanceof ITileEntityUUID) {
                ServerMessageDispatcher.sendTileEntityUUID((ITileEntityUUID)te);
            }
        });
    }

    public static void handleManaweavePatternDrawnMessage(ManaweavePatternDrawnMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when SpellCastMessageToServer was received");
        }
        ctx.enqueueWork(() -> {
            if (!sendingPlayer.field_70170_p.isAreaLoaded(new BlockPos(message.getPosition()), 3)) {
                return;
            }
            IRecipe pattern = sendingPlayer.field_70170_p.func_199532_z().func_215367_a(message.getPatternID()).orElse(null);
            if (!(pattern instanceof IManaweavePattern)) {
                return;
            }
            if (!EventDispatcher.DispatchManaweavePatternDrawn((IManaweavePattern)pattern, (PlayerEntity)sendingPlayer)) {
                return;
            }
            Entity weave = ((EntityType)EntityInit.MANAWEAVE_ENTITY.get()).func_200721_a(sendingPlayer.field_70170_p);
            if (weave != null) {
                weave.func_70012_b(message.getPosition().field_72450_a, message.getPosition().field_72448_b, message.getPosition().field_72449_c, 0.0f, 0.0f);
                if (weave instanceof EntityManaweave) {
                    ((EntityManaweave)weave).setPattern(message.getPatternID());
                    ((EntityManaweave)weave).setCaster((PlayerEntity)sendingPlayer);
                }
                sendingPlayer.field_70170_p.func_217376_c(weave);
                sendingPlayer.func_184614_ca().func_222118_a(1, (LivingEntity)sendingPlayer, i -> {});
            }
        });
    }

    public static void handleRunescribingTableMutexChangeMessage(RunescribingTableMutexChangeMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when SpellCastMessageToServer was received");
        }
        ctx.enqueueWork(() -> {
            if (!sendingPlayer.field_70170_p.func_195588_v(message.getPosition())) {
                return;
            }
            ctx.enqueueWork(() -> TileEntityRunescribingTable.handleMutexChangeMessage(sendingPlayer, message));
        });
    }

    public static void handleSpellBookSlotChangeMessage(SpellBookSlotChangeMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when SpellBookSlotChangeMessage was received");
        }
        ctx.enqueueWork(() -> ItemSpellBook.handleSlotChangeMessage(message, sendingPlayer));
    }

    public static void handleEnderDiscPatternSetMessage(EnderDiscPatternSetMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when EnderDiscPatternSetMessage was received");
        }
        ctx.enqueueWork(() -> ItemEnderDisk.setPattern(sendingPlayer.field_71071_by.func_70448_g(), message.getPatterns()));
    }

    public static void handleAnimatedConstructSyncRequestMessage(AnimatedConstructSyncRequestMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when AnimatedConstructSyncRequestMessage was received");
        }
        ctx.enqueueWork(() -> {
            EntityAnimatedConstruct eac = (EntityAnimatedConstruct)sendingPlayer.field_70170_p.func_73045_a(message.getEntityID());
            if (eac != null) {
                eac.setRequestingDiagnostics(message.getDiagnosticsOnly());
                ServerMessageDispatcher.sendEntityStateMessage(eac, sendingPlayer);
                eac.setRequestingDiagnostics(false);
            }
        });
    }

    public static void handleLodestarGUIActionMessage(LodestarGUIActionMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when AnimatedConstructSyncRequestMessage was received");
        }
        ctx.enqueueWork(() -> {
            TileEntityLodestar lodestar;
            if (sendingPlayer.field_70170_p.func_195588_v(message.getPos()) && (lodestar = (TileEntityLodestar)sendingPlayer.field_70170_p.func_175625_s(message.getPos())) != null) {
                lodestar.handleMessage((PlayerEntity)sendingPlayer, message);
            }
        });
    }

    public static void handleArcaneSentryTargetPlayersMessage(ArcaneSentryTargetPlayersMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when ArcaneSentryTargetPlayersMessage was received");
        }
        ctx.enqueueWork(() -> {
            TileEntity te = sendingPlayer.field_70170_p.func_175625_s(message.getBlockPos());
            if (te != null && te instanceof TileEntityArcaneSentry) {
                ((TileEntityArcaneSentry)te).setTargetPlayers(message.getTargetPlayers());
            }
        });
    }

    public static void handleRoteSpellsSyncMessageToServer(RoteSpellsSyncMessageToServer message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when RoteSpellsSyncMessageToServer was received");
        }
        ctx.enqueueWork(() -> sendingPlayer.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
            for (int i = 0; i < message.getInventory().size(); ++i) {
                m.getRoteInventory().func_70299_a(i, (ItemStack)message.getInventory().get(i));
                m.setSyncGrimoire();
                m.forceSync();
            }
        }));
    }

    public static void handlePlayerBounceMessage(PlayerBounceMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when PlayerBounceMessage was received");
        }
        ctx.enqueueWork(() -> {
            sendingPlayer.func_213317_d(message.getVelocity());
            sendingPlayer.field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)sendingPlayer));
        });
    }

    public static void handlePlayerJumpMessage(PlayerJumpMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when PlayerJumpMessage was received");
        }
        ctx.enqueueWork(() -> {
            int enchLevel = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantmentInit.LEAPING.get()), (ItemStack)sendingPlayer.func_184582_a(EquipmentSlotType.FEET));
            sendingPlayer.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                if (m.getAirJumps() < enchLevel) {
                    m.incrementAirJumps((PlayerEntity)sendingPlayer);
                    sendingPlayer.func_70664_aZ();
                    sendingPlayer.field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)sendingPlayer));
                }
            });
        });
    }

    public static void handleCantripPatternUpdateMessage(CantripPatternUpdateMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when CantripPatternUpdateMessage was received");
        }
        ctx.enqueueWork(() -> sendingPlayer.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.getCantripData().readFromNBT(message.getData())));
    }

    public static void handleSpellNameAndIconMessage(SpellNameAndIconMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when SpellNameAndIconMessage was received");
        }
        ctx.enqueueWork(() -> {
            ItemStack stack = sendingPlayer.field_71071_by.func_70448_g();
            stack.func_200302_a((ITextComponent)new StringTextComponent(message.getName()));
            ItemSpell.setCustomIcon(stack, message.getIconIndex());
        });
    }

    public static void handleSpellAdjustmentsMessage(SpellAdjustmentsMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when SpellAdjustmentMessage was received");
        }
        ctx.enqueueWork(() -> {
            SpellRecipe recipe = SpellRecipe.fromNBT(message.getData());
            if (recipe.isValid() && sendingPlayer.field_71071_by.func_70448_g().func_77973_b() instanceof ItemSpell && !(sendingPlayer.field_71071_by.func_70448_g().func_77973_b() instanceof ItemSpellBook)) {
                recipe.writeToNBT(sendingPlayer.field_71071_by.func_70448_g().func_196082_o());
            } else {
                sendingPlayer.func_145747_a((ITextComponent)new StringTextComponent("Error setting spell data values; serverside validation failed!").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            }
        });
    }

    public static void handleOpenSpellRenameMessage(OpenSpellRenameMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when OpenSpellRenameMessage was received");
        }
        ctx.enqueueWork(() -> NetworkHooks.openGui((ServerPlayerEntity)sendingPlayer, (INamedContainerProvider)new NamedSpellCustomization()));
    }

    public static void handleSelectedModifierMessage(SelectedModifierMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when SelectedModifierMessage was received");
        }
        ctx.enqueueWork(() -> {
            ItemStack stack = sendingPlayer.field_71071_by.func_70448_g();
            if (stack.func_77973_b() == ItemInit.MODIFIER_BOOK.get()) {
                ItemModifierBook.setModifier(stack, message.getModifierRLoc());
            } else {
                sendingPlayer.func_145747_a((ITextComponent)new StringTextComponent("Error setting selected modifier, couldn't verify held item"), Util.field_240973_b_);
            }
        });
    }
}

