/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.messages.to_client;

import com.ma.ManaAndArtifice;
import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.network.messages.BaseMessage;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;

public class MagicSyncMessageToClient
extends BaseMessage {
    private float _mana;
    private int _level;
    private int _xp;
    private float[] _affinities;
    private NonNullList<ItemStack> _grimoireInventory;
    private NonNullList<ItemStack> _roteInventory;
    private CompoundNBT _cantripData;
    private boolean syncGrimoire;
    private boolean syncCantrips;
    private HashMap<String, Float> maxManaModifiers;
    private HashMap<String, Float> regenTickModifiers;

    private MagicSyncMessageToClient() {
        this.messageIsValid = false;
        this._grimoireInventory = NonNullList.func_191196_a();
        this._roteInventory = NonNullList.func_191196_a();
        this.maxManaModifiers = new HashMap();
        this.regenTickModifiers = new HashMap();
    }

    public MagicSyncMessageToClient(float mana, int level, int xp, float[] affinities, float regenMod, HashMap<String, Float> maxManaModifiers, HashMap<String, Float> regenTickModifiers) {
        this();
        this._mana = mana;
        this._level = level;
        this._xp = xp;
        this._affinities = affinities;
        this.maxManaModifiers = maxManaModifiers;
        this.regenTickModifiers = regenTickModifiers;
        this.messageIsValid = true;
    }

    public float getMana() {
        return this._mana;
    }

    public int getLevel() {
        return this._level;
    }

    public int getXP() {
        return this._xp;
    }

    public float[] getAffinities() {
        return this._affinities;
    }

    public NonNullList<ItemStack> getGrimoireInventory() {
        return this._grimoireInventory;
    }

    public NonNullList<ItemStack> getRoteInventory() {
        return this._roteInventory;
    }

    public HashMap<String, Float> getMaxManaModifiers() {
        return this.maxManaModifiers;
    }

    public HashMap<String, Float> getRegenTickModifiers() {
        return this.regenTickModifiers;
    }

    @Nullable
    public CompoundNBT getCantripData() {
        return this._cantripData;
    }

    public boolean getSyncGrimoire() {
        return this.syncGrimoire;
    }

    public boolean getSyncCantrips() {
        return this.syncCantrips;
    }

    public static MagicSyncMessageToClient decode(PacketBuffer buf) {
        MagicSyncMessageToClient msg = new MagicSyncMessageToClient();
        try {
            float value;
            String key;
            int i;
            msg._mana = buf.readFloat();
            msg._level = buf.readInt();
            msg._xp = buf.readInt();
            int affC = buf.readInt();
            msg._affinities = new float[affC];
            for (int i2 = 0; i2 < affC; ++i2) {
                msg._affinities[i2] = buf.readFloat();
            }
            int modCount = buf.readInt();
            for (i = 0; i < modCount; ++i) {
                key = buf.func_218666_n();
                value = buf.readFloat();
                msg.maxManaModifiers.put(key, Float.valueOf(value));
            }
            modCount = buf.readInt();
            for (i = 0; i < modCount; ++i) {
                key = buf.func_218666_n();
                value = buf.readFloat();
                msg.regenTickModifiers.put(key, Float.valueOf(value));
            }
            msg.syncGrimoire = buf.readBoolean();
            if (msg.syncGrimoire) {
                int i3;
                int count = buf.readInt();
                for (i3 = 0; i3 < count; ++i3) {
                    msg._grimoireInventory.add((Object)buf.func_150791_c());
                }
                count = buf.readInt();
                for (i3 = 0; i3 < count; ++i3) {
                    msg._roteInventory.add((Object)buf.func_150791_c());
                }
            }
            msg.syncCantrips = buf.readBoolean();
            if (msg.syncCantrips) {
                msg._cantripData = buf.func_150793_b();
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading MagicSyncMessageToClient: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(MagicSyncMessageToClient msg, PacketBuffer buf) {
        int i;
        buf.writeFloat(msg._mana);
        buf.writeInt(msg._level);
        buf.writeInt(msg._xp);
        buf.writeInt(msg._affinities.length);
        for (i = 0; i < msg._affinities.length; ++i) {
            buf.writeFloat(msg._affinities[i]);
        }
        buf.writeInt(msg.maxManaModifiers.size());
        msg.maxManaModifiers.forEach((k, v) -> {
            buf.func_180714_a(k);
            buf.writeFloat(v.floatValue());
        });
        buf.writeInt(msg.regenTickModifiers.size());
        msg.regenTickModifiers.forEach((k, v) -> {
            buf.func_180714_a(k);
            buf.writeFloat(v.floatValue());
        });
        buf.writeBoolean(msg.syncGrimoire);
        if (msg.syncGrimoire) {
            buf.writeInt(msg._grimoireInventory.size());
            for (i = 0; i < msg._grimoireInventory.size(); ++i) {
                buf.func_150788_a((ItemStack)msg._grimoireInventory.get(i));
            }
            buf.writeInt(msg._roteInventory.size());
            for (i = 0; i < msg._roteInventory.size(); ++i) {
                buf.func_150788_a((ItemStack)msg._roteInventory.get(i));
            }
        }
        buf.writeBoolean(msg.syncCantrips);
        if (msg.syncCantrips) {
            buf.func_150786_a(msg._cantripData);
        }
    }

    public static MagicSyncMessageToClient fromCapability(IPlayerMagic capability) {
        float[] f = new float[Affinity.values().length];
        if (capability == null) {
            return new MagicSyncMessageToClient(0.0f, 0, 0, f, 0.0f, new HashMap<String, Float>(), new HashMap<String, Float>());
        }
        int count = 0;
        for (Affinity aff : Affinity.values()) {
            f[count++] = capability.getAffinityDepth(aff);
        }
        MagicSyncMessageToClient msg = new MagicSyncMessageToClient(capability.getMana(), capability.getMagicLevel(), capability.getMagicXP(), f, capability.getRegenModifier(), capability.getMaxManaModifiers(), capability.getRegenTickModifiers());
        if (capability.shouldSyncGrimoire()) {
            int i;
            msg.syncGrimoire = true;
            for (i = 0; i < capability.getGrimoireInventory().func_70302_i_(); ++i) {
                msg._grimoireInventory.add((Object)capability.getGrimoireInventory().func_70301_a(i));
            }
            for (i = 0; i < capability.getRoteInventory().func_70302_i_(); ++i) {
                msg._roteInventory.add((Object)capability.getRoteInventory().func_70301_a(i));
            }
        }
        if (capability.shouldSyncGrimoire()) {
            msg.syncCantrips = true;
            msg._cantripData = capability.getCantripData().writeToNBT(false);
        }
        return msg;
    }
}

