/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.messages.to_client;

import com.ma.ManaAndArtifice;
import com.ma.api.capabilities.IPlayerRoteSpells;
import com.ma.api.spells.base.ISpellComponent;
import com.ma.network.messages.BaseMessage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class RoteProgressSyncMessageToClient
extends BaseMessage {
    private HashMap<ResourceLocation, Integer> roteSpellProgress = new HashMap();

    private RoteProgressSyncMessageToClient() {
        this.messageIsValid = false;
    }

    public RoteProgressSyncMessageToClient(HashMap<ISpellComponent, Integer> roteSpellProgress) {
        this();
        for (Map.Entry<ISpellComponent, Integer> e : roteSpellProgress.entrySet()) {
            if (e == null) continue;
            this.roteSpellProgress.put(e.getKey().getRegistryName(), e.getValue());
        }
        this.messageIsValid = true;
    }

    public HashMap<ResourceLocation, Integer> getRoteProgress() {
        return this.roteSpellProgress;
    }

    public static RoteProgressSyncMessageToClient decode(PacketBuffer buf) {
        RoteProgressSyncMessageToClient msg = new RoteProgressSyncMessageToClient();
        try {
            int count = buf.readInt();
            for (int i = 0; i < count; ++i) {
                ResourceLocation rLoc = buf.func_192575_l();
                int xp = buf.readInt();
                msg.getRoteProgress().put(rLoc, xp);
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading RoteSyncMessageToClient: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(RoteProgressSyncMessageToClient msg, PacketBuffer buf) {
        buf.writeInt(msg.getRoteProgress().size());
        for (Map.Entry<ResourceLocation, Integer> e : msg.getRoteProgress().entrySet()) {
            buf.func_192572_a(e.getKey());
            buf.writeInt(e.getValue().intValue());
        }
    }

    public static RoteProgressSyncMessageToClient fromCapability(IPlayerRoteSpells capability) {
        return new RoteProgressSyncMessageToClient(capability.getRoteData());
    }
}

