/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.messages.to_server;

import com.ma.ManaAndArtifice;
import com.ma.api.spells.attributes.Attribute;
import com.ma.network.messages.TileEntityMessage;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;

public class InscriptionTableAttributeChangeMessage
extends TileEntityMessage {
    private Attribute attr;
    private float value;
    private ChangeType type;

    public InscriptionTableAttributeChangeMessage() {
        super(null, null);
        this.messageIsValid = false;
    }

    public InscriptionTableAttributeChangeMessage(BlockPos position, UUID tableuuid, Attribute attr, float value, ChangeType type) {
        super(position, tableuuid);
        this.attr = attr;
        this.value = value;
        this.type = type;
        this.messageIsValid = true;
    }

    public final Attribute getAttribute() {
        return this.attr;
    }

    public final float getValue() {
        return this.value;
    }

    public final ChangeType getChangeType() {
        return this.type;
    }

    public static final InscriptionTableAttributeChangeMessage decode(PacketBuffer buf) {
        InscriptionTableAttributeChangeMessage msg = new InscriptionTableAttributeChangeMessage();
        try {
            msg.attr = Attribute.valueOf(buf.func_150789_c(Short.MAX_VALUE));
            msg.value = buf.readFloat();
            msg.type = ChangeType.valueOf(buf.func_150789_c(512));
            msg.uuid = UUID.fromString(buf.func_150789_c(512));
            msg.pos = buf.func_179259_c();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading MagicSyncMessageToClient: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static final void encode(InscriptionTableAttributeChangeMessage msg, PacketBuffer buf) {
        buf.func_180714_a(msg.attr.name());
        buf.writeFloat(msg.value);
        buf.func_180714_a(msg.type.name());
        buf.func_180714_a(msg.uuid.toString());
        buf.func_179255_a(msg.pos);
    }

    public static enum ChangeType {
        SHAPE,
        COMPONENT;

    }
}

