/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.messages.to_server;

import com.ma.ManaAndArtifice;
import com.ma.blocks.tileentities.TileEntityInscriptionTable;
import com.ma.network.messages.TileEntityMessage;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;

public class InscriptionTableCraftingUpdateMessage
extends TileEntityMessage {
    private int totalCraftTicks;
    private int craftTicksPassed;
    private int burnTicksRemaining;
    private int paperRemaining;
    private int inkRemaining;

    public InscriptionTableCraftingUpdateMessage() {
        super(null, null);
        this.messageIsValid = false;
    }

    public InscriptionTableCraftingUpdateMessage(BlockPos position, UUID tableuuid, int totalCraftTicks, int craftTicksPassed, int burnTicksRemaining, int paperRemaining, int inkRemaining) {
        super(position, tableuuid);
        this.totalCraftTicks = totalCraftTicks;
        this.craftTicksPassed = craftTicksPassed;
        this.burnTicksRemaining = burnTicksRemaining;
        this.paperRemaining = paperRemaining;
        this.inkRemaining = inkRemaining;
        this.messageIsValid = true;
    }

    public static final InscriptionTableCraftingUpdateMessage decode(PacketBuffer buf) {
        InscriptionTableCraftingUpdateMessage msg = new InscriptionTableCraftingUpdateMessage();
        try {
            msg.uuid = UUID.fromString(buf.func_150789_c(Short.MAX_VALUE));
            msg.pos = buf.func_179259_c();
            msg.totalCraftTicks = buf.readInt();
            msg.craftTicksPassed = buf.readInt();
            msg.burnTicksRemaining = buf.readInt();
            msg.paperRemaining = buf.readInt();
            msg.inkRemaining = buf.readInt();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading MagicSyncMessageToClient: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public int getTotalCraftTicks() {
        return this.totalCraftTicks;
    }

    public int getCraftTicksPassed() {
        return this.craftTicksPassed;
    }

    public int getBurnTimeRemaining() {
        return this.burnTicksRemaining;
    }

    public int getPaperRemaining() {
        return this.paperRemaining;
    }

    public int getInkRemaining() {
        return this.inkRemaining;
    }

    public static final void encode(InscriptionTableCraftingUpdateMessage msg, PacketBuffer buf) {
        buf.func_180714_a(msg.uuid.toString());
        buf.func_179255_a(msg.pos);
        buf.writeInt(msg.totalCraftTicks);
        buf.writeInt(msg.craftTicksPassed);
        buf.writeInt(msg.burnTicksRemaining);
        buf.writeInt(msg.paperRemaining);
        buf.writeInt(msg.inkRemaining);
    }

    public static InscriptionTableCraftingUpdateMessage fromInscriptionTable(TileEntityInscriptionTable te) {
        return new InscriptionTableCraftingUpdateMessage(te.func_174877_v(), te.getUUID(), te.getCraftTicks(), te.getCraftTicksConsumed(), te.getBurnTicksRemaining(), te.getPaperRemaining(), te.getInkRemaining());
    }
}

