/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.messages.to_server;

import com.ma.ManaAndArtifice;
import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.network.messages.BaseMessage;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;

public class LodestarGUIActionMessage
extends BaseMessage {
    private BlockPos tileEntityPos;
    private int index;
    private ConstructActions commandType;
    private Action actionType;

    public LodestarGUIActionMessage(BlockPos pos, int index, ConstructActions commandType, Action action) {
        this.tileEntityPos = pos;
        this.index = index;
        this.commandType = commandType;
        this.actionType = action;
        this.messageIsValid = true;
    }

    private LodestarGUIActionMessage() {
        this.messageIsValid = false;
    }

    public BlockPos getPos() {
        return this.tileEntityPos;
    }

    public int getIndex() {
        return this.index;
    }

    public ConstructActions getCommandType() {
        return this.commandType;
    }

    public Action getActionType() {
        return this.actionType;
    }

    public static final LodestarGUIActionMessage decode(PacketBuffer buf) {
        LodestarGUIActionMessage msg = new LodestarGUIActionMessage();
        try {
            msg.tileEntityPos = buf.func_179259_c();
            msg.index = buf.readInt();
            msg.commandType = ConstructActions.values()[buf.readInt()];
            msg.actionType = Action.values()[buf.readInt()];
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading LodestarGUIActionMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static final void encode(LodestarGUIActionMessage msg, PacketBuffer buf) {
        buf.func_179255_a(msg.getPos());
        buf.writeInt(msg.getIndex());
        buf.writeInt(msg.getCommandType().ordinal());
        buf.writeInt(msg.getActionType().ordinal());
    }

    public static enum Action {
        ADD,
        REMOVE,
        EDIT;

    }
}

