/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.messages.to_server;

import com.ma.ManaAndArtifice;
import com.ma.network.messages.BaseMessage;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3d;

public class PlayerBounceMessage
extends BaseMessage {
    private Vector3d velocity;

    public PlayerBounceMessage() {
        this.messageIsValid = false;
    }

    public PlayerBounceMessage(Vector3d velocity) {
        this.velocity = velocity;
        this.messageIsValid = true;
    }

    public Vector3d getVelocity() {
        return this.velocity;
    }

    public static final PlayerBounceMessage decode(PacketBuffer buf) {
        PlayerBounceMessage msg = new PlayerBounceMessage();
        try {
            msg.velocity = new Vector3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading PlayerBouncePacket: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(PlayerBounceMessage message, PacketBuffer buf) {
        buf.writeDouble(message.velocity.field_72450_a);
        buf.writeDouble(message.velocity.field_72448_b);
        buf.writeDouble(message.velocity.field_72449_c);
    }
}

