/*
 * Decompiled with CFR 0.152.
 */
package com.ma.particles;

import com.ma.tools.math.Vector3;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FXEnder
extends SpriteTexturedParticle {
    private final double startX;
    private final double startY;
    private final double startZ;
    private Vector3 targetPoint;
    private Vector3 bezier_control_point_a;
    private Vector3 bezier_control_point_b;
    private static final byte MOTION_BEZIER = 0;
    private static final byte MOTION_VELOCITY = 1;
    private byte MOTION_TYPE = 0;
    private static final IParticleRenderType NORMAL_RENDER = new IParticleRenderType(){

        public void func_217600_a(BufferBuilder bufferBuilder, TextureManager textureManager) {
            FXEnder.beginRenderCommon(bufferBuilder, textureManager);
        }

        public void func_217599_a(Tessellator tessellator) {
            tessellator.func_78381_a();
            FXEnder.endRenderCommon();
        }

        public String toString() {
            return "mana-and-artifice:ender";
        }
    };

    public FXEnder(ClientWorld world, double x, double y, double z, IAnimatedSprite sprite) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.startX = x;
        this.startY = y;
        this.startZ = z;
        this.field_187130_j *= (double)0.2f;
        this.field_187129_i = 0.0;
        this.field_187131_k = 0.0;
        Vector3 firstColor = new Vector3(0.5490196347236633, 0.2627451f, 0.5764706134796143);
        this.func_82338_g(0.0f);
        this.func_70538_b(firstColor.x, firstColor.y, firstColor.z);
        this.field_190015_G = this.field_190014_F = (float)(-45.0 + Math.random() * 90.0 / (Math.PI / 180));
        this.field_70544_f *= 0.35f;
        this.field_70547_e = 30;
        this.field_190017_n = false;
        this.field_217569_E = sprite.func_217590_a(new Random());
    }

    private void setMoveVelocity(double x, double y, double z) {
        this.field_187129_i = x;
        this.field_187130_j = y;
        this.field_187131_k = z;
        this.MOTION_TYPE = 1;
    }

    private void bezierTowards(double x, double y, double z) {
        this.targetPoint = new Vector3(x, y, z);
        this.generateBezierControlPoints();
        this.MOTION_TYPE = 0;
    }

    private void moveVelocity() {
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        if (this.field_187127_g == this.field_187124_d) {
            this.field_187129_i *= 1.1;
            this.field_187131_k *= 1.1;
        }
        this.field_187129_i *= (double)0.96f;
        this.field_187130_j *= (double)0.96f;
        this.field_187131_k *= (double)0.96f;
        if (this.field_187132_l) {
            this.field_187129_i *= (double)0.7f;
            this.field_187131_k *= (double)0.7f;
        }
    }

    private void generateBezierControlPoints() {
        Vector3 originPoint = this.getOriginPoint();
        Vector3 o1 = new Vector3(originPoint.x, originPoint.y, originPoint.z);
        Vector3 midPoint = new Vector3((originPoint.x + this.targetPoint.x) / 2.0f, (originPoint.y + this.targetPoint.y) / 2.0f, (originPoint.z + this.targetPoint.z) / 2.0f);
        midPoint = midPoint.sub(o1);
        midPoint = midPoint.rotateYaw(1.5707964f);
        this.bezier_control_point_a = new Vector3(originPoint.x + (this.targetPoint.x - originPoint.x) / 3.0f, originPoint.y + (this.targetPoint.y - originPoint.y) / 3.0f, originPoint.z + (this.targetPoint.z - originPoint.z) / 3.0f);
        this.bezier_control_point_b = new Vector3(originPoint.x + (this.targetPoint.x - originPoint.x) / 3.0f * 2.0f, originPoint.y + (this.targetPoint.y - originPoint.y) / 3.0f * 2.0f, originPoint.z + (this.targetPoint.z - originPoint.z) / 3.0f * 2.0f);
        this.bezier_control_point_a = this.bezier_control_point_a.add(midPoint);
        this.bezier_control_point_b = this.bezier_control_point_b.add(midPoint);
    }

    public float func_217561_b(float partialTicks) {
        return this.field_70544_f * (1.0f + (float)this.field_70546_d / (float)this.field_70547_e * 4.0f);
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.field_190015_G = this.field_190014_F;
        this.field_190014_F = (float)((double)this.field_190014_F + Math.random() * Math.PI / 180.0);
        if (!this.apply_aging()) {
            if (this.MOTION_TYPE == 0) {
                this.moveBezierPoint();
            } else if (this.MOTION_TYPE == 1) {
                this.moveVelocity();
            }
        }
    }

    private Vector3 getOriginPoint() {
        return new Vector3(this.startX, this.startY, this.startZ);
    }

    private void moveBezierPoint() {
        this.setPosition(Vector3.bezier(this.getOriginPoint(), this.targetPoint, this.bezier_control_point_a, this.bezier_control_point_b, (float)this.field_70546_d / (float)this.field_70547_e));
    }

    private void setPosition(Vector3 position) {
        this.func_187109_b(position.x, position.y, position.z);
    }

    private boolean apply_aging() {
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
            return false;
        }
        float agePct = (float)this.field_70546_d / (float)this.field_70547_e;
        float alpha_T = 1.0f;
        if (agePct < 0.2f) {
            alpha_T = agePct / 0.2f;
        } else if (agePct > 0.8f) {
            alpha_T = (agePct - 0.8f) / 0.2f;
        }
        Vector3 firstColor = new Vector3(0.5490196347236633, 0.2627451f, 0.5764706134796143);
        Vector3 secondColor = new Vector3(0.0, 0.0, 0.0);
        Vector3 color = Vector3.lerp(firstColor, secondColor, agePct);
        float alpha = (double)agePct < 0.2 ? alpha_T : (agePct > 0.8f ? 1.0f - alpha_T : 1.0f);
        this.func_70538_b(color.x, color.y, color.z);
        this.func_82338_g(alpha);
        return this.field_187133_m;
    }

    public Vector3 getPosition() {
        return new Vector3(this.field_187126_f, this.field_187127_g, this.field_187128_h);
    }

    protected int func_189214_a(float partialTick) {
        return 0xF00000;
    }

    @Nonnull
    public IParticleRenderType func_217558_b() {
        return NORMAL_RENDER;
    }

    private static void beginRenderCommon(BufferBuilder buffer, TextureManager textureManager) {
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.alphaFunc((int)516, (float)0.003921569f);
        RenderSystem.disableLighting();
        textureManager.func_110577_a(AtlasTexture.field_215262_g);
        Texture tex = textureManager.func_229267_b_(AtlasTexture.field_215262_g);
        tex.setBlurMipmap(true, false);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
    }

    private static void endRenderCommon() {
        Minecraft.func_71410_x().field_71446_o.func_229267_b_(AtlasTexture.field_215262_g).restoreLastBlurMipmap();
        RenderSystem.alphaFunc((int)516, (float)0.1f);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FXEnderVelocity
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite spriteSet;

        public FXEnderVelocity(IAnimatedSprite p_i50846_1_) {
            this.spriteSet = p_i50846_1_;
        }

        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FXEnder particle = new FXEnder(worldIn, x, y, z, this.spriteSet);
            particle.setMoveVelocity(xSpeed, ySpeed, zSpeed);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FXEnderBezier
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite spriteSet;

        public FXEnderBezier(IAnimatedSprite p_i50846_1_) {
            this.spriteSet = p_i50846_1_;
        }

        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FXEnder particle = new FXEnder(worldIn, x, y, z, this.spriteSet);
            particle.bezierTowards(xSpeed, ySpeed, zSpeed);
            return particle;
        }
    }
}

