/*
 * Decompiled with CFR 0.152.
 */
package com.ma.particles;

import com.ma.particles.FXMovementType;
import com.ma.tools.math.Vector3;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FXSparkle
extends SpriteTexturedParticle {
    private final IAnimatedSprite sprite;
    private FXMovementType movementType;
    private final double startX;
    private final double startY;
    private final double startZ;
    private Vector3 targetPoint;
    private Vector3 bezier_control_point_a;
    private Vector3 bezier_control_point_b;
    private float offsetFactor = 10.0f;
    private float halfOffsetFactor = 5.0f;
    private static final IParticleRenderType NORMAL_RENDER = new IParticleRenderType(){

        public void func_217600_a(BufferBuilder bufferBuilder, TextureManager textureManager) {
            FXSparkle.beginRenderCommon(bufferBuilder, textureManager);
        }

        public void func_217599_a(Tessellator tessellator) {
            tessellator.func_78381_a();
            FXSparkle.endRenderCommon();
        }

        public String toString() {
            return "mana-and-artifice:particle";
        }
    };

    public FXSparkle(ClientWorld world, double x, double y, double z, IAnimatedSprite sprite) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.startX = x;
        this.startY = y;
        this.startZ = z;
        this.sprite = sprite;
        this.field_187130_j *= (double)0.2f;
        this.field_187129_i = 0.0;
        this.field_187131_k = 0.0;
        this.func_70538_b(1.0f, 0.0f, 1.0f);
        this.field_70544_f *= 0.15f;
        this.field_70547_e = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.field_190017_n = false;
        this.func_217566_b(sprite);
    }

    private void setLerpTowards(double x, double y, double z) {
        this.movementType = FXMovementType.LERP_POINT;
        this.targetPoint = new Vector3(x, y, z);
        this.field_187129_i = 0.0;
        this.field_187130_j = 0.0;
        this.field_187131_k = 0.0;
    }

    private void setStationary() {
        this.movementType = FXMovementType.STATIONARY;
        this.field_70547_e = 100;
    }

    private void setMoveRandomly(double x, double y, double z) {
        this.movementType = FXMovementType.VELOCITY;
        this.field_187129_i = -x + Math.random() * 2.0 * y;
        this.field_187130_j = -y + Math.random() * 2.0 * y;
        this.field_187131_k = -z + Math.random() * 2.0 * z;
    }

    private void bezierTowards(double x, double y, double z) {
        this.movementType = FXMovementType.BEZIER_POINT;
        this.targetPoint = new Vector3(x, y, z);
        this.generateBezierControlPoints();
    }

    private void velocity(double x, double y, double z) {
        this.movementType = FXMovementType.VELOCITY;
        this.field_187129_i = x;
        this.field_187130_j = y;
        this.field_187131_k = z;
    }

    private void gravity(double x, double y, double z) {
        this.movementType = FXMovementType.VELOCITY;
        this.field_187129_i = x;
        this.field_187130_j = y;
        this.field_187131_k = z;
        this.field_70545_g = 0.06f;
    }

    private void generateBezierControlPoints() {
        Vector3 originPoint = this.getOriginPoint();
        this.bezier_control_point_a = new Vector3(originPoint.x + (this.targetPoint.x - originPoint.x) / 3.0f, originPoint.y + (this.targetPoint.y - originPoint.y) / 3.0f, originPoint.z + (this.targetPoint.z - originPoint.z) / 3.0f);
        this.bezier_control_point_b = new Vector3(originPoint.x + (this.targetPoint.x - originPoint.x) / 3.0f * 2.0f, originPoint.y + (this.targetPoint.y - originPoint.y) / 3.0f * 2.0f, originPoint.z + (this.targetPoint.z - originPoint.z) / 3.0f * 2.0f);
        double offsetX = this.field_187122_b.field_73012_v.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        double offsetZ = this.field_187122_b.field_73012_v.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        double offsetY = this.field_187122_b.field_73012_v.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        Vector3 offset = new Vector3(offsetX, offsetY, offsetZ);
        this.bezier_control_point_a = this.bezier_control_point_a.add(offset);
        this.bezier_control_point_b = this.bezier_control_point_b.add(offset);
    }

    public float func_217561_b(float partialTicks) {
        return this.field_70544_f * (float)(this.field_70547_e - this.field_70546_d + 1) / (float)this.field_70547_e;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (!this.apply_aging()) {
            switch (this.movementType) {
                case VELOCITY: {
                    this.moveVelocity();
                    break;
                }
                case BEZIER_POINT: {
                    this.moveBezierPoint();
                    break;
                }
                case LERP_POINT: {
                    this.moveLerpPoint();
                    break;
                }
            }
        }
    }

    private void moveVelocity() {
        this.field_187130_j += 0.004;
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        if (this.field_187127_g == this.field_187124_d) {
            this.field_187129_i *= 1.1;
            this.field_187131_k *= 1.1;
        }
        this.field_187129_i *= (double)0.96f;
        this.field_187130_j *= (double)0.96f;
        this.field_187131_k *= (double)0.96f;
        if (this.field_187132_l) {
            this.field_187129_i *= (double)0.7f;
            this.field_187131_k *= (double)0.7f;
        }
    }

    private Vector3 getOriginPoint() {
        return new Vector3(this.startX, this.startY, this.startZ);
    }

    private void moveLerpPoint() {
        this.setPosition(Vector3.lerp(this.getOriginPoint(), this.targetPoint, (float)this.field_70546_d / (float)this.field_70547_e));
    }

    private void moveBezierPoint() {
        this.setPosition(Vector3.bezier(this.getOriginPoint(), this.targetPoint, this.bezier_control_point_b, this.bezier_control_point_b, this.field_70546_d / this.field_70547_e));
    }

    private boolean apply_aging() {
        this.func_217566_b(this.sprite);
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        return this.field_187133_m;
    }

    private void setPosition(Vector3 position) {
        this.func_187109_b(position.x, position.y, position.z);
    }

    public Vector3 getPosition() {
        return new Vector3(this.field_187126_f, this.field_187127_g, this.field_187128_h);
    }

    protected int func_189214_a(float partialTick) {
        return 0xF00000;
    }

    @Nonnull
    public IParticleRenderType func_217558_b() {
        return NORMAL_RENDER;
    }

    private static void beginRenderCommon(BufferBuilder buffer, TextureManager textureManager) {
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        RenderSystem.alphaFunc((int)516, (float)0.003921569f);
        RenderSystem.disableLighting();
        textureManager.func_110577_a(AtlasTexture.field_215262_g);
        Texture tex = textureManager.func_229267_b_(AtlasTexture.field_215262_g);
        tex.setBlurMipmap(true, false);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
    }

    private static void endRenderCommon() {
        Minecraft.func_71410_x().field_71446_o.func_229267_b_(AtlasTexture.field_215262_g).restoreLastBlurMipmap();
        RenderSystem.alphaFunc((int)516, (float)0.1f);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FXSparkleStationaryFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public FXSparkleStationaryFactory(IAnimatedSprite p_i50846_1_) {
            this.spriteSet = p_i50846_1_;
        }

        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FXSparkle particle = new FXSparkle(worldIn, x, y, z, this.spriteSet);
            particle.setStationary();
            particle.func_82338_g(0.85f);
            particle.func_70538_b(1.0f, 1.0f, 1.0f);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FXSparkleGravityFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public FXSparkleGravityFactory(IAnimatedSprite p_i50846_1_) {
            this.spriteSet = p_i50846_1_;
        }

        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FXSparkle particle = new FXSparkle(worldIn, x, y, z, this.spriteSet);
            particle.gravity(xSpeed, ySpeed, zSpeed);
            particle.func_82338_g(0.85f);
            particle.func_70538_b(1.0f, 1.0f, 1.0f);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FXSparkleVelocityFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public FXSparkleVelocityFactory(IAnimatedSprite p_i50846_1_) {
            this.spriteSet = p_i50846_1_;
        }

        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FXSparkle particle = new FXSparkle(worldIn, x, y, z, this.spriteSet);
            particle.velocity(xSpeed, ySpeed, zSpeed);
            particle.func_82338_g(0.85f);
            particle.func_70538_b(1.0f, 1.0f, 1.0f);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FXSparkleBezierPointFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public FXSparkleBezierPointFactory(IAnimatedSprite p_i50846_1_) {
            this.spriteSet = p_i50846_1_;
        }

        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FXSparkle particle = new FXSparkle(worldIn, x, y, z, this.spriteSet);
            particle.bezierTowards(xSpeed, ySpeed, zSpeed);
            particle.func_82338_g(0.85f);
            particle.func_70538_b(1.0f, 1.0f, 1.0f);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FXSparkleLerpPointFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public FXSparkleLerpPointFactory(IAnimatedSprite p_i50846_1_) {
            this.spriteSet = p_i50846_1_;
        }

        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FXSparkle particle = new FXSparkle(worldIn, x, y, z, this.spriteSet);
            particle.setLerpTowards(xSpeed, ySpeed, zSpeed);
            particle.func_82338_g(0.85f);
            particle.func_70538_b(1.0f, 1.0f, 1.0f);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FXSparkleRandomFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite spriteSet;

        public FXSparkleRandomFactory(IAnimatedSprite p_i50846_1_) {
            this.spriteSet = p_i50846_1_;
        }

        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FXSparkle particle = new FXSparkle(worldIn, x, y, z, this.spriteSet);
            particle.setMoveRandomly(xSpeed, ySpeed, zSpeed);
            particle.func_82338_g(0.85f);
            particle.func_70538_b(1.0f, 1.0f, 1.0f);
            return particle;
        }
    }
}

