/*
 * Decompiled with CFR 0.152.
 */
package com.ma.particles.bolt;

import com.ma.particles.bolt.LightningData;
import com.ma.particles.bolt.Segment;
import com.ma.tools.math.Vector3;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FXWraithBolt
extends SpriteTexturedParticle {
    private LightningData data;
    private static final IParticleRenderType LIGHTNING_BOLT_RENDER = new IParticleRenderType(){

        public void func_217600_a(BufferBuilder bufferBuilder, TextureManager textureManager) {
            FXWraithBolt.beginRenderCommon(bufferBuilder, textureManager);
        }

        public void func_217599_a(Tessellator tessellator) {
            tessellator.func_78381_a();
            FXWraithBolt.endRenderCommon();
        }

        public String toString() {
            return "mana-and-artifice:lightning_bolt";
        }
    };

    public FXWraithBolt(ClientWorld worldIn, double startX, double startY, double startZ, double endX, double endY, double endZ, IAnimatedSprite sprite) {
        super(worldIn, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.field_217569_E = sprite.func_217590_a(this.field_187136_p);
        this.data = new LightningData(new Vector3(startX, startY, startZ), new Vector3(endX, endY, endZ), worldIn.field_73012_v.nextLong());
        this.data.setMaxAge(20);
        this.data.setSpeed(2);
        this.field_70547_e = this.data.getMaxAge();
        this.func_187109_b(startX, startY, startZ);
        this.field_187129_i = 0.0;
        this.field_187130_j = 0.0;
        this.field_187131_k = 0.0;
        this.field_70552_h = 0.75f;
        this.field_70553_i = 0.12f;
        this.field_70551_j = 0.06f;
        this.data.setMaxOffset(0.25f);
        this.data.fractalize(8);
        this.data.finalize();
    }

    public void func_189213_a() {
        super.func_189213_a();
        this.data.onUpdate();
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        Vector3d vec3d = renderInfo.func_216785_c();
        float f = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187123_c, (double)this.field_187126_f) - vec3d.func_82615_a());
        float f1 = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187124_d, (double)this.field_187127_g) - vec3d.func_82617_b());
        float f2 = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187125_e, (double)this.field_187128_h) - vec3d.func_82616_c());
        Vector3 posOffset = new Vector3(f, f1, f2);
        Vector3 particleOrigin = new Vector3(this.field_187126_f, this.field_187127_g, this.field_187128_h);
        int count = 0;
        int maxIndex = (int)Math.ceil(((float)this.data.getAge() + partialTicks) / (float)this.data.getMaxAge() * (float)this.data.numSegments());
        Vector3 lastEnd1 = null;
        Vector3 lastEnd2 = null;
        if (this.data.getAge() == this.data.getMaxAge()) {
            int ticksRemaining = this.field_70547_e - this.field_70546_d;
            this.field_82339_as = (float)ticksRemaining / 10.0f;
        }
        for (Segment s : this.data.getSegments()) {
            if (count > maxIndex) break;
            float width = 0.08f;
            Vector3 start = s.getStart().sub(particleOrigin);
            Vector3 end = s.getEnd().sub(particleOrigin);
            Vector3[] avector3f = new Vector3[]{lastEnd1 == null ? start.add(new Vector3(-width, 0.0, -width)) : lastEnd1, lastEnd2 == null ? start.add(new Vector3(-width, 0.0, width)) : lastEnd2, end.add(new Vector3(width, 0.0, width)), end.add(new Vector3(width, 0.0, -width))};
            lastEnd1 = avector3f[2];
            lastEnd2 = avector3f[3];
            for (int i = 0; i < 4; ++i) {
                avector3f[i] = avector3f[i].add(posOffset);
            }
            float minU = this.func_217563_c();
            float maxU = this.func_217564_d();
            float minV = this.func_217562_e();
            float maxV = this.func_217560_f();
            int j = 0xF00000;
            buffer.func_225582_a_((double)avector3f[3].x, (double)avector3f[3].y, (double)avector3f[3].z).func_225583_a_(maxU, maxV).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
            buffer.func_225582_a_((double)avector3f[2].x, (double)avector3f[2].y, (double)avector3f[2].z).func_225583_a_(maxU, minV).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
            buffer.func_225582_a_((double)avector3f[0].x, (double)avector3f[0].y, (double)avector3f[0].z).func_225583_a_(minU, minV).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
            buffer.func_225582_a_((double)avector3f[1].x, (double)avector3f[1].y, (double)avector3f[1].z).func_225583_a_(minU, maxV).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
            buffer.func_225582_a_((double)avector3f[3].x, (double)avector3f[3].y, (double)avector3f[3].z).func_225583_a_(maxU, maxV).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
            buffer.func_225582_a_((double)avector3f[2].x, (double)avector3f[2].y, (double)avector3f[2].z).func_225583_a_(maxU, minV).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
            buffer.func_225582_a_((double)avector3f[0].x, (double)avector3f[0].y, (double)avector3f[0].z).func_225583_a_(minU, minV).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
            buffer.func_225582_a_((double)avector3f[1].x, (double)avector3f[1].y, (double)avector3f[1].z).func_225583_a_(minU, maxV).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
            ++count;
        }
    }

    public IParticleRenderType func_217558_b() {
        return LIGHTNING_BOLT_RENDER;
    }

    private static void beginRenderCommon(BufferBuilder buffer, TextureManager textureManager) {
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        RenderSystem.alphaFunc((int)516, (float)0.003921569f);
        RenderSystem.disableLighting();
        textureManager.func_110577_a(AtlasTexture.field_215262_g);
        Texture tex = textureManager.func_229267_b_(AtlasTexture.field_215262_g);
        tex.setBlurMipmap(true, false);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
    }

    private static void endRenderCommon() {
        Minecraft.func_71410_x().field_71446_o.func_229267_b_(AtlasTexture.field_215262_g).restoreLastBlurMipmap();
        RenderSystem.alphaFunc((int)516, (float)0.1f);
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FXWraithBoltFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite spriteSet;

        public FXWraithBoltFactory(IAnimatedSprite p_i50846_1_) {
            this.spriteSet = p_i50846_1_;
        }

        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FXWraithBolt particle = new FXWraithBolt(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            return particle;
        }
    }
}

